#
# Makefile for VIM on the Amiga, using SAS/Lattice C 6.0 to 6.56
#
# Do NOT use the peephole optimizer with a version before 6.55!
# It messes up all kinds of things:
# For 6.0 and 6.1, expand_env() will not work correctly.
# For 6.2 and 6.3 the call to free_line in u_freeentry is wrong.
# Don't know about 6.50, might work...
# Version 6.56 seems to be working fine.
# You should use Manx Aztec C whenever possible.
#
# The prototypes from Manx and SAS are incompatible. If the prototypes
# were generated by Manx, first do "touch *.c; make proto" before "make".
# The prototypes generated on Unix work for both.
#
# Note: Not all dependencies are included. This was done to avoid having
#       to compile everything when a global variable or function is added.

#>>>>> choose options:

### See feature.h for a list of optionals.
### Any other defines can be included here.

DEFINES = DEF=NO_ARP

#>>>>> if HAVE_TGETENT is defined objects/termlib.o has to be used
#TERMLIB = objects/termlib.o
TERMLIB = 

#>>>>> choose NODEBUG for normal compiling, the other for debugging and
# profiling
# don't switch on debugging when generating proto files, it crashes the
# compiler.
DBG = NODEBUG
#DBG = DBG=SF

#>>>>> choose NOOPTPEEP for 6.0 to 6.3, NOOPT for debugging
# with version 6.55 you can probably use OPT
#OPTIMIZE=OPT
OPTIMIZE=NOOPTPEEP
#OPTIMIZE=NOOPT

#>>>>> end of choices
###########################################################################

CC = sc
GST = vim.gst
COPTS = SINT SCODE SDATA

CFLAGS = NOLINK $(OPTIMIZE) $(COPTS) DEF=AMIGA DEF=SASC $(DBG) $(DEFINES) GST=$(GST)

PROPT = DEF=PROTO GPROTO GPPARM

SRC =	alloc.c amiga.c buffer.c charset.c cmdcmds.c cmdline.c \
	csearch.c digraph.c edit.c fileio.c getchar.c help.c \
	linefunc.c main.c mark.c memfile.c memline.c message.c misccmds.c \
	normal.c ops.c option.c quickfix.c regexp.c \
	regsub.c screen.c search.c \
	tables.c tag.c term.c undo.c window.c version.c

OBJ =	objects/alloc.o objects/amiga.o objects/buffer.o objects/charset.o \
	objects/cmdcmds.o objects/cmdline.o objects/csearch.o \
	objects/digraph.o objects/edit.o objects/fileio.o objects/getchar.o \
	objects/help.o objects/linefunc.o objects/main.o objects/mark.o \
	objects/memfile.o objects/memline.o objects/message.o \
	objects/misccmds.o objects/normal.o objects/ops.o objects/option.o \
	objects/quickfix.o objects/regexp.o objects/regsub.o \
	objects/screen.o objects/search.o objects/tables.o objects/tag.o \
	objects/term.o objects/undo.o objects/window.o $(TERMLIB)

PRO =	proto/alloc.pro proto/buffer.pro proto/charset.pro proto/cmdcmds.pro \
	proto/cmdline.pro proto/csearch.pro proto/digraph.pro proto/edit.pro \
	proto/fileio.pro proto/getchar.pro proto/help.pro proto/linefunc.pro \
	proto/main.pro proto/mark.pro proto/memfile.pro proto/memline.pro \
	proto/message.pro proto/misccmds.pro proto/normal.pro proto/ops.pro \
	proto/option.pro proto/quickfix.pro proto/regexp.pro proto/regsub.pro \
	proto/screen.pro proto/search.pro proto/tables.pro proto/tag.pro \
	proto/term.pro proto/termlib.pro proto/undo.pro proto/window.pro \
	proto/amiga.pro

Vim: objects $(OBJ) version.c
	$(CC) $(CFLAGS) version.c OBJNAME=objects/
	$(CC) LINK $(COPTS) $(OBJ) objects/version.o $(DBG) PNAME=Vim

debug: objects $(OBJ) version.c
	$(CC) $(CFLAGS) version.c OBJNAME=objects/
	$(CC) LINK $(COPTS) $(OBJ) objects/version.o $(DBG) PNAME=Vim

proto: $(GST) $(PRO)

ctags:
	csh -c ctags $(SRC) *.h

# can't use delete here, too many file names
clean:
	csh -c rm -f $(OBJ) objects/version.o objects/mkcmdtab.o Vim $(GST) mkcmdtab cmdtab.h

$(GST)  : vim.h keymap.h macros.h ascii.h term.h structs.h
	$(CC) $(CFLAGS) MGST=$(GST) vim.h

objects:
	makedir objects

###########################################################################

objects/alloc.o:	alloc.c  $(GST)
	$(CC) $(CFLAGS) alloc.c OBJNAME=objects/

proto/alloc.pro:	alloc.c  $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/alloc.pro $(PROPT) alloc.c

objects/amiga.o:	amiga.c  $(GST)
	$(CC) $(CFLAGS) amiga.c OBJNAME=objects/

proto/amiga.pro:	amiga.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/amiga.pro $(PROPT) amiga.c

objects/buffer.o:	buffer.c  $(GST)
	$(CC) $(CFLAGS) buffer.c OBJNAME=objects/

proto/buffer.pro:	buffer.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/buffer.pro $(PROPT) buffer.c

objects/charset.o:	charset.c  $(GST)
	$(CC) $(CFLAGS) charset.c OBJNAME=objects/

proto/charset.pro:	charset.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/charset.pro $(PROPT) charset.c

objects/cmdcmds.o:	cmdcmds.c  $(GST)
	$(CC) $(CFLAGS) cmdcmds.c OBJNAME=objects/

proto/cmdcmds.pro:	cmdcmds.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/cmdcmds.pro $(PROPT) cmdcmds.c

objects/cmdline.o:	cmdline.c  $(GST) cmdtab.h
	$(CC) $(CFLAGS) cmdline.c OBJNAME=objects/

proto/cmdline.pro:	cmdline.c $(GST) cmdtab.h
	$(CC) $(CFLAGS) GPFILE=proto/cmdline.pro $(PROPT) cmdline.c

objects/csearch.o:	csearch.c  $(GST)
	$(CC) $(CFLAGS) csearch.c OBJNAME=objects/

proto/csearch.pro:	csearch.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/csearch.pro $(PROPT) csearch.c

objects/digraph.o:	digraph.c  $(GST)
	$(CC) $(CFLAGS) digraph.c OBJNAME=objects/

proto/digraph.pro:	digraph.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/digraph.pro $(PROPT) digraph.c

objects/edit.o:	edit.c  $(GST)
	$(CC) $(CFLAGS) edit.c OBJNAME=objects/

proto/edit.pro:	edit.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/edit.pro $(PROPT) edit.c

objects/fileio.o:	fileio.c  $(GST)
	$(CC) $(CFLAGS) fileio.c OBJNAME=objects/

proto/fileio.pro:	fileio.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/fileio.pro $(PROPT) fileio.c

objects/getchar.o:	getchar.c  $(GST)
	$(CC) $(CFLAGS) getchar.c OBJNAME=objects/

proto/getchar.pro:	getchar.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/getchar.pro $(PROPT) getchar.c

objects/help.o:	help.c  $(GST)
	$(CC) $(CFLAGS) help.c OBJNAME=objects/

proto/help.pro:	help.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/help.pro $(PROPT) help.c

objects/linefunc.o:	linefunc.c  $(GST)
	$(CC) $(CFLAGS) linefunc.c OBJNAME=objects/

proto/linefunc.pro:	linefunc.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/linefunc.pro $(PROPT) linefunc.c

objects/main.o:	main.c  $(GST)
	$(CC) $(CFLAGS) main.c OBJNAME=objects/

proto/main.pro:	main.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/main.pro $(PROPT) main.c

objects/mark.o:	mark.c  $(GST)
	$(CC) $(CFLAGS) mark.c OBJNAME=objects/

proto/mark.pro:	mark.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/mark.pro $(PROPT) mark.c

objects/memfile.o:	memfile.c  $(GST)
	$(CC) $(CFLAGS) memfile.c OBJNAME=objects/

proto/memfile.pro:	memfile.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/memfile.pro $(PROPT) memfile.c

objects/memline.o:	memline.c  $(GST)
	$(CC) $(CFLAGS) memline.c OBJNAME=objects/

proto/memline.pro:	memline.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/memline.pro $(PROPT) memline.c

objects/message.o:	message.c  $(GST)
	$(CC) $(CFLAGS) message.c OBJNAME=objects/

proto/message.pro:	message.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/message.pro $(PROPT) message.c

objects/misccmds.o:	misccmds.c  $(GST)
	$(CC) $(CFLAGS) misccmds.c OBJNAME=objects/

proto/misccmds.pro:	misccmds.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/misccmds.pro $(PROPT) misccmds.c

objects/normal.o:	normal.c  $(GST) ops.h
	$(CC) $(CFLAGS) normal.c OBJNAME=objects/

proto/normal.pro:	normal.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/normal.pro $(PROPT) normal.c

objects/ops.o:	ops.c  $(GST) ops.h
	$(CC) $(CFLAGS) ops.c OBJNAME=objects/

proto/ops.pro:	ops.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/ops.pro $(PROPT) ops.c

objects/option.o:	option.c  $(GST)
	$(CC) $(CFLAGS) option.c OBJNAME=objects/

proto/option.pro:	option.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/option.pro $(PROPT) option.c

objects/quickfix.o:	quickfix.c  $(GST)
	$(CC) $(CFLAGS) quickfix.c OBJNAME=objects/

proto/quickfix.pro:	quickfix.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/quickfix.pro $(PROPT) quickfix.c

objects/regexp.o:	regexp.c  $(GST)
	$(CC) $(CFLAGS) regexp.c OBJNAME=objects/

proto/regexp.pro:	regexp.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/regexp.pro $(PROPT) regexp.c

objects/regsub.o:	regsub.c  $(GST)
	$(CC) $(CFLAGS) regsub.c OBJNAME=objects/

proto/regsub.pro:	regsub.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/regsub.pro $(PROPT) regsub.c

objects/screen.o:	screen.c  $(GST)
	$(CC) $(CFLAGS) screen.c OBJNAME=objects/

proto/screen.pro:	screen.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/screen.pro $(PROPT) screen.c

objects/search.o:	search.c  $(GST)
	$(CC) $(CFLAGS) search.c OBJNAME=objects/

proto/search.pro:	search.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/search.pro $(PROPT) search.c

objects/tables.o:	tables.c  $(GST)
	$(CC) $(CFLAGS) tables.c OBJNAME=objects/

proto/tables.pro:	tables.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/tables.pro $(PROPT) tables.c

objects/tag.o:	tag.c  $(GST)
	$(CC) $(CFLAGS) tag.c OBJNAME=objects/

proto/tag.pro:	tag.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/tag.pro $(PROPT) tag.c

objects/term.o:	term.c  $(GST)
	$(CC) $(CFLAGS) term.c OBJNAME=objects/

proto/term.pro:	term.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/term.pro $(PROPT) term.c

objects/termlib.o:	termlib.c  $(GST)
	$(CC) $(CFLAGS) termlib.c OBJNAME=objects/

proto/termlib.pro:	termlib.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/termlib.pro $(PROPT) termlib.c

objects/undo.o:	undo.c  $(GST)
	$(CC) $(CFLAGS) undo.c OBJNAME=objects/

proto/undo.pro:	undo.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/undo.pro $(PROPT) undo.c

objects/window.o:	window.c  $(GST)
	$(CC) $(CFLAGS) window.c OBJNAME=objects/

proto/window.pro:	window.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/window.pro $(PROPT) window.c

cmdtab.h: cmdtab.tab mkcmdtab
	mkcmdtab cmdtab.tab cmdtab.h

objects/mkcmdtab.o:	mkcmdtab.c
	$(CC) $(CFLAGS) mkcmdtab.c OBJNAME=objects/

mkcmdtab: objects/mkcmdtab.o
	$(CC) LINK $(COPTS) objects/mkcmdtab.o PNAME=mkcmdtab
