.lf 1 sql/fetch.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /usr/local/devel/pglite/cvs/src/doc/ref/sql/fetch.cmdsrc,v 1.1 1996/02/24 01:17:06 jolly Exp $
.TH FETCH COMMANDS 01/23/93
.XA 2 Fetch
.SH NAME
fetch \(em fetch instance(s) from a cursor
.SH SYNOPSIS
.(l M
\fBfetch\fR [ (\fBforward\fR | \fBbackward\fR) ] [ ( number | \fBall\fR) ] [\fBin\fR cursor_name]
.)l
.SH DESCRIPTION
.BR Fetch
allows a user to retrieve instances from a cursor named
.IR cursor_name.
The number of instances retrieved is specified by
.IR number .
If the number of instances remaining in the cursor is less than
.IR number ,
then only those available are fetched.  Substituting the keyword
.IR all
in place of a number will cause all remaining instances in the cursor 
to be retrieved.  Instances may be fetched in both
.IR forward
and
.IR backward
directions.  The default direction is
.IR forward .
.PP
Updating data in a cursor is not supported by \*(PG, because mapping
cursor updates back to base classes is impossible in general as with
view updates.  Consequently, users must issue explicit replace
commands to update data.
.PP
Portals may only be used inside of transaction blocks marked by 
.IR begin (commands)
and
.IR end (commands)
because the data that they store spans multiple user queries.
.SH EXAMPLE
.(C
--
--set up and use a cursor 
--
begin 
   declare myportal cursor for 
   select * from pg-user
end 
.)C
.(C
--
--Fetch all the instances available in the portal FOO
--
fetch all in FOO
.)C
.(C
--
--Fetch 5 instances backward in the portal FOO
--
fetch backward 5 in FOO
.)C
.SH "SEE ALSO"
begin(commands),
end(commands),
close(commands),
move(commands),
select(commands).
.SH BUGS
Currently, the smallest transaction in \*(PG is a single \*(PQ
command.  It should be possible for a single fetch to be a
transaction.
