/* Interface to NSString implementation with C-string backing
   Copyright (C) 1995 Free Software Foundation, Inc.

   Written by:  R. Andrew McCallum <mccallum@gnu.ai.mit.edu>
   Date: March 1995

   This file is part of the GNU Objective C Class Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __NSGCString_h_OBJECTS_INCLUDE
#define __NSGCString_h_OBJECTS_INCLUDE

#include <objects/stdobjects.h>
#include <Foundation/NSString.h>

/* NSGCString and NSGMutableCString must have the same initial ivar layout
   because of class_add_behavior() in NSGMutableCString's +initialize. */

@interface NSGCString : NSString
{
  char * _contents_chars;
  int _count;
  BOOL _free_contents;
}
@end

@interface NSGMutableCString : NSMutableString
{
  char * _contents_chars;
  int _count;
  BOOL _free_contents;
  int _capacity;
}
@end

#endif /* __NSGCString_h_OBJECTS_INCLUDE */
