/**
 *
 * $Id: Traversal.c,v 1.12 1996/04/23 17:40:48 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: Traversal.c,v 1.12 1996/04/23 17:40:48 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/DebugUtil.h>
#include <Xm/VendorS.h>
#include <Xm/ManagerP.h>
#include <Xm/List.h>
#include <Xm/ScrollBar.h>
#include <Xm/BulletinBP.h>
#include <stdio.h>

void
XmAddTabGroup(Widget tab_group)
{
}

void
XmRemoveTabGroup(Widget tab_group)
{
}

Widget 
XmGetTabGroup(Widget widget)
{
    Widget w = widget;

    while (!(XmIsManager(w) 
	     || XmIsList(w)
	     || XmIsScrollBar(w)
	     || XtIsShell(w)))
	w = XtParent(w);

    return w;
}

/* this is pretty broken right now.  It follows the guidelines for
   the exclusive tab groups, and doesn't do anything about traversal
   based on screen location */
Boolean
XmProcessTraversal(Widget widget, 
		   XmTraversalDirection direction)
{
    Widget heirarchy = _XmFindTopMostShell(widget);
    Widget tab_group = XmGetTabGroup(widget);

    /* check the XmNkeyboardFocusPolicy of the vendor shell. Return
       false if it's not EXPLICIT */

    switch (direction)
    {
    case XmTRAVERSE_CURRENT: 
	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_CURRENT)\n");

	if (_XmIsNavigable(widget))
	{
	    XtSetKeyboardFocus(heirarchy, widget);
	    XdbDebug(__FILE__, widget, "Returning True\n");
	    return True;
	}
	else
	    return False;
	break;

    case  XmTRAVERSE_HOME:
    {
	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_HOME)\n");

	XtSetKeyboardFocus(heirarchy,
			       MGR_InitialFocus(tab_group));
	break;
    }

    case XmTRAVERSE_NEXT:
    {
	int i;

	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_NEXT)\n");

	for (i=0; i< MGR_NumChildren(tab_group); i++)
	    if (MGR_Children(tab_group)[i] == widget)
		break;

	XtSetKeyboardFocus(heirarchy,
			   MGR_Children(tab_group)[i+1 % MGR_NumChildren(tab_group)]);
	MGR_ActiveChild(heirarchy) = MGR_Children(tab_group)[i+1 % MGR_NumChildren(tab_group)];
	break;
    }
    case  XmTRAVERSE_DOWN:
    {
	int i;

	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_DOWN)\n");

	for (i=0; i< MGR_NumChildren(tab_group); i++)
	    if (MGR_Children(tab_group)[i] == widget)
		break;

	XtSetKeyboardFocus(heirarchy,
			   MGR_Children(tab_group)[i+1 % MGR_NumChildren(tab_group)]);
	MGR_ActiveChild(heirarchy) = MGR_Children(tab_group)[i+1 % MGR_NumChildren(tab_group)];
	break;
    }
    case  XmTRAVERSE_RIGHT:
    {
	int i;

	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_RIGHT)\n");

	for (i=0; i< MGR_NumChildren(tab_group); i++)
	    if (MGR_Children(tab_group)[i] == widget)
		break;

	XtSetKeyboardFocus(heirarchy,
			   MGR_Children(tab_group)[i+1 % MGR_NumChildren(tab_group)]);
	MGR_ActiveChild(heirarchy) = MGR_Children(tab_group)[i+1 % MGR_NumChildren(tab_group)];
	break;
    }

    case XmTRAVERSE_PREV:
    {
	int i;

	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_PREV)\n");

	for (i=0; i< MGR_NumChildren(tab_group); i++)
	    if (MGR_Children(tab_group)[i] == widget)
		break;

	if (i == 0)
	    i = MGR_NumChildren(tab_group)-1;
	else
	    i--;

	XtSetKeyboardFocus(heirarchy,
			   MGR_Children(tab_group)[i]);
	MGR_ActiveChild(heirarchy) = MGR_Children(tab_group)[i];
	break;
    }
    case XmTRAVERSE_UP:
    {
	int i;

	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_UP)\n");

	for (i=0; i< MGR_NumChildren(tab_group); i++)
	    if (MGR_Children(tab_group)[i] == widget)
		break;

	if (i == 0)
	    i = MGR_NumChildren(tab_group)-1;
	else
	    i--;

	XtSetKeyboardFocus(heirarchy,
			   XtParent(MGR_Children(tab_group)[i]));
	MGR_ActiveChild(heirarchy) = MGR_Children(tab_group)[i];
	break;
    }
    case XmTRAVERSE_LEFT:
    {
	int i;

	for (i=0; i< MGR_NumChildren(tab_group); i++)
	    if (MGR_Children(tab_group)[i] == widget)
		break;

	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_LEFT)\n");

	if (i == 0)
	    i = MGR_NumChildren(tab_group)-1;
	else
	    i--;

	XtSetKeyboardFocus(heirarchy,
			   XtParent(MGR_Children(tab_group)[i]));
	MGR_ActiveChild(heirarchy) = MGR_Children(tab_group)[i];
	break;
    }

    case XmTRAVERSE_NEXT_TAB_GROUP:
	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_NEXT_TAB_GROUP)\n");
	break;
    case  XmTRAVERSE_PREV_TAB_GROUP:
	XdbDebug(__FILE__, widget, "XmProcessTraversal(XmTRAVERSE_PREV_TAB_GROUP)\n");
	break;
    }
    
    return True;
}

Widget 
XmGetFocusWidget(Widget widget)
{
    VendorShellWidget vendorShell = (VendorShellWidget)_XmFindTopMostShell(widget);
    Widget child_of_vendorshell;

    if (vendorShell->composite.num_children > 1)
	child_of_vendorshell = vendorShell->composite.children[1]; /* ugly hack ? FIX ME PERHAPS*/
    else
	return NULL;

    if (XmIsManager(child_of_vendorshell))
	return MGR_InitialFocus(child_of_vendorshell);
    else
	return child_of_vendorshell;
}

Boolean
XmIsTraversable(Widget widget)
{
    /* do we need to check if the widget's ancestors are
       traversable?  FIX ME */

    if (XmIsPrimitive(widget))
	return Prim_TraversalOn(widget);
    else if (XmIsManager(widget))
	return MGR_TraversalOn(widget);
    else if (XmIsGadget(widget))
	return G_TraversalOn(widget);
    return False;
}

XmVisibility 
XmGetVisibility(Widget widget)
{
    return XmVISIBILITY_PARTIALLY_OBSCURED; /* FIX ME */
}

/* private functions */

XmFocusData
_XmCreateFocusData()
{
    return NULL;
}

void
_XmDestroyFocusData(XmFocusData focusData)
{
}

void
_XmSetActiveTabGroup(XmFocusData focusData,
		     Widget tabGroup)
{
}

Widget
_XmGetActiveItem(Widget w)
{
    return NULL;
}

void
_XmNavigInitialize(Widget request,
		   Widget new_wid,
		   ArgList args,
		   Cardinal num_args)
{
}

/*
  _XmNavigSetValues

  Responsible for setting the focus to a new widget if the
  one that had it before the call to set_values can no 
  longer have the focus -- e.g., XtNsensitive set to False,
  etc.
*/

Boolean
_XmNavigSetValues(Widget current,
		  Widget request,
		  Widget new_wid,
		  ArgList args,
		  Cardinal *num_args)
{
    return False;
}

/*
  _XmNavigChangeManaged

  Responsible for setting the focus to a new widget if the
  one that had it before the call to change_managed is
  now unmanaged.  This should be the last thing called from
  any XmManager-subclass's change_managed method.
*/
void
_XmNavigChangeManaged(Widget w)
{
    /* if the initial_focus is NULL, set the focus
       to the first Navigable widget which can
       accept the focus */

    if (MGR_InitialFocus(w) == NULL)
    {
	int i;
	
	for (i = 0; i<MGR_NumChildren(w); i++)
	    if (_XmIsNavigable(MGR_Children(w)[i]))
	    {
		_XmSetInitialOfTabGroup(w, MGR_Children(w)[i]);
		return;
	    }
    }
    else 
    { 
	/* check to see if the initial_focus widget
	   has been unmanaged */

	if (XtIsManaged(MGR_InitialFocus(w)))
	    return; /* we're ok */
	/*
	  else
	     Move_the_focus_to_some_other_widget(); FIX ME*/
    }
}

void
_XmNavigResize(Widget wid)
{
}

void
_XmValidateFocus(Widget wid)
{
}

void
_XmNavigDestroy(Widget wid)
{
}

void
_XmCallFocusMoved(Widget old,
		  Widget new_wid,
		  XEvent *event)
{
    Widget par = NULL;

    XdbDebug(__FILE__, NULL, "_XmCallFocusMoved()\n");
    if (old)
	par = XtParent(old);
    else if (new_wid)
	par = XtParent(new_wid);
    if (!par || !new_wid || !_XmIsFastSubclass(XtClass(par),
					       XmBULLETIN_BOARD_BIT))
	return;
    XtCallCallbackList(par, BB_FocusCallback(par), (XtPointer)new_wid);
}

void
_XmMgrTraversal(Widget wid,
		XmTraversalDirection direction)
{
}

void
_XmClearFocusPath(Widget wid)
{
}

Boolean
_XmFocusIsHere(Widget w)
{
    return False;
}

void
_XmProcessTraversal(Widget w,
		    XmTraversalDirection dir,
		    Boolean check)
{
}

/*
  _XmGetFocusPolicy

  Returns the focus policy of the toplevel shell.
  Actually gets it out of the Vender Shell Extension 
  record
 */
unsigned char
_XmGetFocusPolicy(Widget w)
{
    Widget shell = _XmFindTopMostShell(w);
    unsigned char policy;

    XtVaGetValues(shell, 
		  XmNkeyboardFocusPolicy, &policy,
		  NULL);

    return policy;
}

Widget
_XmFindTopMostShell(Widget w)
{
    Widget shell;

    shell = w;

    while (!XmIsVendorShell(shell))
	shell = XtParent(shell);

    return shell;
}

void
_XmFocusModelChanged(Widget wid,
		     XtPointer client_data,
		     XtPointer call_data)
{
}

Boolean
_XmGrabTheFocus(Widget w,
		XEvent *event)
{
    return False;
}

XmFocusData
_XmGetFocusData(Widget wid)
{
    Widget shell = _XmFindTopMostShell(wid);
    XmFocusData foo = _XmCreateFocusData();
    
/*    XtVaGetValues(shell,
		  XmNfocusData, &foo,
		  NULL);*/

    return foo;
}

Boolean
_XmCreateVisibilityRect(Widget w,
			XRectangle *rectPtr)
{
    return False;
}

void
_XmSetRect(XRectangle *rect,
	   Widget w)
{
}

int
_XmIntersectRect(XRectangle *srcRectA,
		 Widget widget,
		 XRectangle *dstRect)
{
    return 0;
}

int
_XmEmptyRect(XRectangle *r)
{
    return 0;
}

void
_XmClearRect(XRectangle *r)
{
}

/*
 * should also check whether the widget or its ancestors are
 * being destroyed, and also whether or not the widget is
 * obscured by its ancestors.  Also whether or not it's
 * mapped -- FIX ME
 */
Boolean
_XmIsNavigable(Widget w)
{
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmIsNavigable()\n");

    if (!w)
	return False;

    if (XtSensitive(w) && XmIsTraversable(w) && XtIsRealized(w))
    {
	bce = _XmGetBaseClassExtPtr(XtClass(w), XmQmotif);
	if ((*bce)->widgetNavigable)
		return (((*bce)->widgetNavigable)(w) != XmNOT_NAVIGABLE);
	return True;
    }
    return False;
}

void
_XmWidgetFocusChange(Widget wid,
		     XmFocusChange change)
{
}

Widget
_XmNavigate(Widget wid,
	    XmTraversalDirection direction)
{
    return NULL;
}

Widget
_XmFindNextTabGroup(Widget wid)
{
    return NULL;
}

Widget
_XmFindPrevTabGroup(Widget wid)
{
    return NULL;
}

void
_XmSetInitialOfTabGroup(Widget tab_group,
			Widget init_focus)
{
    MGR_InitialFocus(tab_group) = init_focus;
}

void
_XmResetTravGraph(Widget wid)
{
}

Boolean
_XmFocusIsInShell(Widget wid)
{
    return False;
}

Boolean
_XmShellIsExclusive(Widget wid)
{
    return False;
}

Widget
_XmGetFirstFocus(Widget wid)
{
    return NULL;
}

