/**
 *
 * $Id: TravAct.c,v 1.6 1996/04/23 17:40:47 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: TravAct.c,v 1.6 1996/04/23 17:40:47 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/BaseClassP.h>
#include <Xm/DebugUtil.h>
#include <Xm/ManagerP.h>
#include <Xm/PrimitiveP.h>
#include <Xm/GadgetP.h>
#include <stdio.h>

/*
 * undocumented, undefined.  But called by PushButtonGadget...
 */
void
_XmSetFocusFlag()
{
}

void
_XmTrackShellFocus(Widget widget,
		   XtPointer client_data,
		   XEvent *event,
		   Boolean *dontSwallow)
{
}

/*
 * these functions, and the related Gadget functions, should not do the
 * highlighting, but should (maybe?) instead invoke the FocusChange proc
 * in the BaseClass extension, with the appropriate args.
 */
void 
_XmPrimitiveEnter(Widget w, 
		  XEvent *event, 
		  String *params, 
		  Cardinal *num_params)
{
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmPrimitiveEnter()\n");

    bce = _XmGetBaseClassExtPtr(XtClass(w), XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmENTER);
}

void 
_XmPrimitiveLeave(Widget w, 
		  XEvent *event, 
		  String *params, 
		  Cardinal *num_params)
{
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmPrimitiveLeave()\n");

    bce = _XmGetBaseClassExtPtr(XtClass(w), XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmLEAVE);
}

void
_XmPrimitiveFocusInInternal(Widget w,
			    XEvent *event,
			    String *params,
			    Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmPrimitiveFocusInInternal()\n");
}

void 
_XmPrimitiveFocusOut(Widget w, 
		    XEvent *event, 
		    String *params, 
		    Cardinal *num_params)
{
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmPrimitiveFocusOut()\n");

    if (_XmIsFastSubclass(XtClass(XtParent(w)), XmMANAGER_BIT)) {
	_XmCallFocusMoved(w, NULL, event);
	MGR_ActiveChild(XtParent(w)) = w;
    }
    XFlush(XtDisplay(w));
    bce = _XmGetBaseClassExtPtr(XtClass(w), XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmFOCUS_OUT);
}

void 
_XmPrimitiveFocusIn(Widget w, 
		    XEvent *event, 
		    String *params, 
		    Cardinal *num_params)
{
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmPrimitiveFocusIn()\n");

    if (_XmIsFastSubclass(XtClass(XtParent(w)), XmMANAGER_BIT)) {
	_XmCallFocusMoved(NULL, w, event);
	MGR_ActiveChild(XtParent(w)) = w;
    }
    XFlush(XtDisplay(w));
    bce = _XmGetBaseClassExtPtr(XtClass(w), XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmFOCUS_IN);
}

void
_XmPrimitiveUnmap(Widget w,
		  XEvent *event,
		  String *params,
		  Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmPrimitiveUnmap()\n");
}

void
_XmEnterGadget(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmGadgetEnter()\n");

    bce = _XmGetBaseClassExtPtr(XtClass(w), XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmENTER);
}

void
_XmLeaveGadget(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    XmGadgetClass gwc = (XmGadgetClass)w->core.widget_class;
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmGadgetLeave()\n");

    bce = _XmGetBaseClassExtPtr(gwc, XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmLEAVE);
}

void
_XmFocusInGadget(Widget w,
		 XEvent *event,
		 String *params,
		 Cardinal *num_params)
{
    XmGadgetClass gwc = (XmGadgetClass)w->core.widget_class;
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmGadgetFocusIn()\n");

    bce = _XmGetBaseClassExtPtr(gwc, XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmFOCUS_IN);
    MGR_ActiveChild(XtParent(w)) = w;
}

void
_XmFocusOutGadget(Widget w,
		  XEvent *event,
		  String *params,
		  Cardinal *num_params)
{
    XmBaseClassExt *bce;

    XdbDebug(__FILE__, w, "_XmGadgetFocusOut()\n");

    bce = _XmGetBaseClassExtPtr(XtClass(w), XmQmotif);
    if ((*bce)->focusChange)
	((*bce)->focusChange)(w, XmFOCUS_OUT);
}

void
_XmManagerEnter(Widget w,
		XEvent *event_in,
		String *params,
		Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmManagerEnter()\n");
}

void
_XmManagerLeave(Widget w,
		XEvent *event_in,
		String *params,
		Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmManagerLeave()\n");
}

void
_XmManagerFocusInInternal(Widget w,
			  XEvent *event,
			  String *params,
			  Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmManagerFocusInInternal()\n");
}

void
_XmManagerFocusIn(Widget w,
		  XEvent *event,
		  String *params,
		  Cardinal *num_params)
{
    XmGadget g;
    unsigned char focus_policy = _XmGetFocusPolicy(w);
    Window root, child;
    int x, y, rx, ry;
    unsigned int mask;

    XdbDebug(__FILE__, w, "_XmManagerFocusIn()\n");

    XQueryPointer(XtDisplay(w), XtWindow(w), &root, &child,
		  &rx, &ry, &x, &y, &mask);

    g = _XmInputForGadget(w, x, y);

    if (g == NULL) {
	if (MGR_SelectedGadget(w) &&
	    _XmIsFastSubclass(XtClass(MGR_SelectedGadget(w)), XmGADGET_BIT)) {
	    if (focus_policy != XmPOINTER) {
		_XmCallFocusMoved(NULL, (Widget)NULL, event);
		XFlush(XtDisplay(w));
		_XmDispatchGadgetInput((Widget)MGR_SelectedGadget(w),
				       event,
				       XmFOCUS_OUT_EVENT);
		MGR_SelectedGadget(w) = NULL;
	    }
	}
    }
    else {
	if (MGR_SelectedGadget(w) &&
	    _XmIsFastSubclass(XtClass(MGR_SelectedGadget(w)), XmGADGET_BIT) &&
	    _XmIsNavigable((Widget)g)) {
	    if (focus_policy != XmPOINTER)
		_XmDispatchGadgetInput((Widget)MGR_SelectedGadget(w),
				       event,
				       XmFOCUS_OUT_EVENT);
	}
	if (_XmIsFastSubclass(XtClass(g), XmGADGET_BIT) &&
	    focus_policy != XmPOINTER && _XmIsNavigable((Widget)g)) {
	    _XmCallFocusMoved((Widget)MGR_SelectedGadget(w), (Widget)g, event);
	    XFlush(XtDisplay(w));
	    _XmDispatchGadgetInput((Widget)g,
				   event,
				   XmFOCUS_IN_EVENT);
	    MGR_SelectedGadget(w) = g;
	}
    }
}

void
_XmManagerFocusOut(Widget w,
		   XEvent *event,
		   String *params,
		   Cardinal *num_params)
{
    unsigned char focus_policy = _XmGetFocusPolicy(w);

    XdbDebug(__FILE__, w, "_XmManagerFocusOut(): MGR_Select: %08x\n",
	     MGR_SelectedGadget(w));
    if (MGR_SelectedGadget(w))
	XdbDebug(__FILE__, w, "SEl: %s\n", XtName(MGR_SelectedGadget(w)));

    if (MGR_SelectedGadget(w) &&
	_XmIsFastSubclass(XtClass(MGR_SelectedGadget(w)), XmGADGET_BIT)) {
	if (focus_policy != XmPOINTER) {
	    _XmCallFocusMoved((Widget)MGR_SelectedGadget(w), NULL, event);
	    XFlush(XtDisplay(w));
	    _XmDispatchGadgetInput((Widget)MGR_SelectedGadget(w),
				   event,
				   XmFOCUS_OUT_EVENT);
	    MGR_SelectedGadget(w) = NULL;
	}
    }
}

void
_XmManagerUnmap(Widget w,
		XEvent *event,
		String *params,
		Cardinal *num_params)
{
    XdbDebug(__FILE__, w, "_XmManagerUnmap()\n");
}

