/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */



#include <stdio.h>
#include "_scm.h"



/* {Files in general}
 */


#if (__TURBOC__==1)
#undef L_tmpnam		/* Not supported in TURBOC V1.0 */
#endif
#ifdef GO32
#undef L_tmpnam
#endif
#ifdef MWC
#undef L_tmpnam
#endif

#ifdef L_tmpnam


PROC (s_tmpnam, "tmpnam", 0, 0, 0, scm_tmpnam);
#ifdef __STDC__
SCM 
scm_tmpnam (void)
#else
SCM 
scm_tmpnam ()
#endif
{
  char name[L_tmpnam];
  SYSCALL (tmpnam (name););
  return scm_makfromstr (name, strlen (name), 0);
}

#else
/* TEMPTEMPLATE is used only if mktemp() is being used instead of
   tmpnam(). */

#ifdef AMIGA
#define TEMPTEMPLATE "T:SchemeaaaXXXXXX";
#else
#ifdef vms
#define TEMPTEMPLATE "sys$scratch:aaaXXXXXX";
#else /* vms */
#ifdef __MSDOS__
#ifdef GO32
#define TEMPTEMPLATE "\\tmp\\TMPaaaXXXXXX";
#else
#define TEMPTEMPLATE "TMPaaaXXXXXX";
#endif
#else /* __MSDOS__ */
#define TEMPTEMPLATE "/tmp/aaaXXXXXX";
#endif /* __MSDOS__ */
#endif /* vms */
#endif /* AMIGA */

char template[] = TEMPTEMPLATE;
#define TEMPLEN (sizeof template/sizeof(char) - 1)
PROC (s_tmpnam, "tmpnam", 0, 0, 0, scm_tmpnam);
#ifdef __STDC__
SCM 
scm_tmpnam (void)
#else
SCM 
scm_tmpnam ()
#endif
{
  SCM name;
  int temppos = TEMPLEN - 9;
  name = scm_makfromstr (template, (sizet) TEMPLEN, 0);
  DEFER_INTS;
inclp:
  template[temppos]++;
  if (!isalpha (template[temppos]))
    {
      template[temppos++] = 'a';
      goto inclp;
    }
#ifndef AMIGA
#ifndef __MSDOS__
  SYSCALL (temppos = !*mktemp (CHARS (name)););
  if (temppos)
    name = BOOL_F;
#endif
#endif
  ALLOW_INTS;
  return name;
}

#endif /* L_tmpnam */


#ifdef M_SYSV
#define remove unlink
#endif

PROC (s_sys_delete_file, "%delete-file", 1, 0, 0, scm_sys_delete_file);
#ifdef __STDC__
SCM 
scm_sys_delete_file (SCM str)
#else
SCM 
scm_sys_delete_file (str)
     SCM str;
#endif
{
  int ans;
  ASSERT (NIMP (str) && STRINGP (str), str, ARG1, s_sys_delete_file);
#ifdef STDC_HEADERS
  SYSCALL (ans = remove (CHARS (str)));
#else
  SYSCALL (ans = unlink (CHARS (str)));
#endif
  return ans ? BOOL_F : BOOL_T;
}



#ifdef __STDC__
void
scm_init_files (void)
#else
void
scm_init_files ()
#endif
{
#include "files.x"
}

