.TH gk_viewport n "5 September 1995" "GroupKit"
.SH NAME
gk_viewport \- Attach scrollbars to a widget
.SH SYNOPSIS
.TP 
\fBgk_viewport\fI pathname child \fR?\fIoptions\fR?

.SH "STANDARD OPTIONS"
.nf
.ta 4c 8c 12c
.VS
\fBbackground	height	takeFocus
\fBborderWidth	highlightBackground	relief
\fBcolormap	highlightThickness	visual
\fBcursor	highlightColor	width

.VE
.fi

See the ``options'' manual entry for details on the standard options.

.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.nf
Name:	\fBscroll\fR
Class:	\fBScroll\fR
Command-Line Switch:	\fB\-scroll\fR
.fi
.IP
Specifies which scrollbars are to be attached.  This option accepts a
list containing one or more of left, right, top or bottom.  Only a single
vertical or a single horizontal scrollbar should be specified.
.LP
.ta 4c
.nf
Name:	\fBmultiUser\fR
Class:	\fBMultiUser\fR
Command-Line Switch:	\fB\-multiuser\fR
.fi
.IP
Specifies whether or not the scrollbars are multi-user scrollbars.  If
true then the are multi-user scrollbars; if false then they are not.
Any Tk boolean value is valid and the default value is true.
.LP

.SH DESCRIPTION
This application attaches a vertical and a horizontal scrollbar to a 
child widget.  Where the scrollbars are placed and which ones are
displayed depends on the value of the scroll option.  The scrollbars 
used by this widget are the GroupKit scrollbars, 
``gk_scrollbar''.  Whether or not they are displayed as multi-user
scrollbars depends on the value of the multiuser option.

The commands that control the horizontal scrolling of the widget are 
defined as follows:
.IP 1.
if the child doesn't have a \fIxscrollcommand\fR then
the horizontal scrolling is ignored.
.IP 2.
if the \fIxscrollcommand\fR for the child widget is \fBNOT\fR
defined then default definitions are used for \fIxscrollcommand\fR
for the child widget and for the \fIcommand\fR.
.IP 3.
if the \fIxscrollcommand\fR for the child widget is definded 
then the default definitions are \fBNOT\fR used.
.LP
A similar approach is used for the vertical scrolling.

.SH "WIDGET COMMAND"
The \fBgk_viewport\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.IP
\fIpathName option \fR?\fIarg arg ...\fR?
.LP
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for gk_viewport widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBgk_viewport\fR
command.
.TP
\fIpathName \fBcget \fIoption\fR
Returns  the  current value of the configuration option
given by option.  Option may have  any  of  the  values
accepted by the text command.
.TP
\fIpathName \fBrepack\fR
Cause the viewport to be repacked.
.TP
\fIpathName \fBxcommand\fR
Return the xscrollbar command for the horizontal scrollbar.
.TP
\fIpathName \fBxscrollbar\fR
Return the path name of the horizontal scrollbar.
.TP
\fIpathName \fBycommand\fR
Return the yscrollbar command for the vertical scrollbar.
.TP
\fIpathName \fByscrollbar\fR
Return the path name of the vertical scrollbar.

.SH "DEFAULT BINDINGS"
The only default bindings are those defined for the GroupKit
 scrollbar, See ``gk_scrollbar'' for further details..

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.  Much of the code is
based on code from the Wigwam package by Jim Wight.

.SH "SEE ALSO"
gk_scrollbar(n)

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)
Ideas borrowed from Jim Wight, author of Wigwam

