// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _DEFINITIONS_H
#define _DEFINITIONS_H

// This defines the different debug levels. They can be used almost
// as you want them. Max debug level is still (1 << 16).
// Add debugging levels as necessary. To use several debugging levels
// at once, just add the values together. ex. level 10 is INIT and TOOLBAR.
enum LYX_DEBUG_LEVELS {
	DEBUG_INFO =       (1),        // 1
	DEBUG_INIT =       (1 << 1),   // 2
	DEBUG_KEY =        (1 << 2),   // 4
	DEBUG_TOOLBAR =    (1 << 3),   // 8
	DEBUG_LEX_PARSER = (1 << 4),   // 16
	DEBUG_LYXRC =      (1 << 5),   // 32
	DEBUG_KBMAP =      (1 << 6),   // 64
	DEBUG_ALL =        (65535)     // 2^16-1
};
extern LYX_DEBUG_LEVELS lyx_debug_level;

#include "config.h"
#include "lyxfont.h"
#include <stdio.h>

// ALL the enums below should be given names, this to get better typechecking.
// some don't have names now because this cause warings when compiling.

enum {
	LYX_UNCHANGED,
	LYX_NEED_LITTLE_REFRESH,
	LYX_NEED_MORE_REFRESH,
	LYX_NEED_VERY_LITTLE_REFRESH
};

/* the footnoteflag */
enum LYX_FOOTNOTE_FLAG {
	LYX_NO_FOOTNOTE,
	LYX_OPEN_FOOTNOTE,
	LYX_CLOSED_FOOTNOTE
};

/* the footnotekinds */
enum LYX_FOOTNOTE_KIND {
	LYX_FOOTNOTE,
	LYX_MARGIN,
	LYX_FIG,
	LYX_TAB
};

// enum { // LYX_FONT_FAMILY
// 	LYX_ROMAN_FAMILY,
// 	LYX_SANS_FAMILY,
// 	LYX_TYPEWRITER_FAMILY,
// 	LYX_MODERN_FAMILY,	       /* obsolete */
// 	LYX_SYMBOL_FAMILY
// };

// enum { // LYX_FONT_SERIES
// 	LYX_MEDIUM_SERIES,
// 	LYX_BOLD_SERIES
// };

// enum { // LYX_FONT_SHAPE
// 	LYX_UP_SHAPE,
// 	LYX_ITALIC_SHAPE,
// 	LYX_SMALLCAPS_SHAPE
// };

// enum { // LYX_FONT_SHAPE
// 	LYX_SIZE_TINY,
// 	LYX_SIZE_SMALL,
// 	LYX_SIZE_NORMAL,
// 	LYX_SIZE_LARGE,
// 	LYX_SIZE_LARGER,
// 	LYX_SIZE_LARGEST,
// 	LYX_SIZE_HUGE,
// 	LYX_SIZE_GIANT
// };

// enum LYX_FONT_BAR {
// 	LYX_NO_BAR,
// 	LYX_UNDER_BAR
// };

enum { // no good name for this
        LYX_ENVIRONMENT_DEFAULT = 97,
//	LYX_NO_FONT_CHANGE = 98,
	LYX_LAYOUT_DEFAULT = 99
};

enum { // LYX_LATEX ?
	LYX_NO_LATEX,
	LYX_LATEX,
	LYX_FORMULA_LATEX,
	LYX_PROTECTED_LATEX, // unused ?!
	LYX_PROTECTED_FORMULA_LATEX // unused ?!  Matthias
};

enum LYX_ZOOM {
	LYX_SMALL_ZOOM,
	LYX_NORMAL_ZOOM,
	LYX_LARGE_ZOOM
};

enum LYX_META_KIND {
	LYX_META_FOOTNOTE = 1,
	LYX_META_MARGIN,
	LYX_META_FIG,
	LYX_META_TAB,
	LYX_META_HFILL,
	LYX_META_NEWLINE,
	LYX_META_PROTECTED_SEPARATOR,
	LYX_META_INSET
};

enum LYX_ALIGNMENT {
	LYX_ALIGN_BLOCK = 1,
	LYX_ALIGN_LEFT = 2,
	LYX_ALIGN_RIGHT = 4,
	LYX_ALIGN_CENTER = 8,
	LYX_ALIGN_FORMULA = 16,
	LYX_ALIGN_LAYOUT = 32
};

#define LYX_DUMMY_LAYOUT 99


enum LYX_PARSEP {
	LYX_PARSEP_INDENT,
	LYX_PARSEP_SKIP
};

enum LYX_PAPER_SIZE {
	PAPER_A4PAPER,
	PAPER_A4,
	PAPER_A4WIDE,
	PAPER_WIDEMARGINSA4,
	PAPER_USLETTER,
	PAPER_A5PAPER,
	PAPER_B5PAPER,
	PAPER_EXECUTIVEPAPER,
	PAPER_LEGALPAPER
};

enum LYX_PROCESS_MODE {
	MODE_FINAL,
	MODE_DRAFT
};

enum LYX_PAPER_ORIENTATION {
	ORIENTATION_PORTRAIT,
	ORIENTATION_LANDSCAPE
};

enum LYX_PAGESTYLE {
	PAGESTYLE_PLAIN,
	PAGESTYLE_HEADINGS,
	PAGESTYLE_FANCYHDR,
	PAGESTYLE_EMPTY
};

enum LYX_QUOTE_LANGUAGE {
	GERMAN,
	ENGLISH,
	FRENCH
};

/* LyX code for Insets */
enum LYX_CODE {
	LYX_NO_CODE,
	LYX_TOC_CODE,
	LYX_QUOTE_CODE,
	LYX_MARK_CODE,
	LYX_REF_CODE,
	LYX_URL_CODE,
	LYX_HTMLURL_CODE,
	LYX_SEPARATOR_CODE,
	LYX_ENDING_CODE,
	LYX_LABEL_CODE,
	LYX_IGNORE_CODE,
	LYX_ACCENT_CODE,
	LYX_MATH_CODE
};

void SetZoom(char new_zoom);
//char GetZoom(); // seems to be unused. (Lgb)

/* load a style-file, still VERY dump */ 
void LyXSetStyle(const char *path);

char* date();


/*
 * Inlined Functions
 */

inline
int Maximum(int a, int b)
{
	return ((a>b) ? a : b);
}


inline
int Minimum(int a, int b)
{
	return ((a<b) ? a : b);
}


inline
bool StringEqual(const char* a, const char* b)
{
	int i;
	if (a == b) return true;
	
	if (!a || !b) return false;
	
	for (i=0;a[i] && b[i] && a[i]==b[i];i++);
	
	return (a[i]==b[i]);
}


inline
char* StringCopy(const char* a)
{
	if (!a) return NULL;

	int i,n;
	for (n=0; a[n]; n++);
	char* new_string = new char[n+2];
	for (i=0; i<=n; i++)
		new_string[i] = a[i];
	return new_string;
}


inline
char* StringReplace (char *b, const char* a)
//a function to delete b and retrun a new string to replace it
//we should really have a string class but that's too slow
{
	if (b) delete[] b;

        return StringCopy(a);
}
#endif
