%% This is the chkconfig document class which provides tools to
%% inspect your LaTeX configuration, to be used by LyX
%% Author: Jean-Marc Lasgouttes (Jean-Marc.Lasgouttes@inria.fr)

%%% Basic definition to have a real LaTeX document class
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{chkconfig}[1996/10/07 LyX chkconfig class]
% This seems to be needed, although we do not produce output.
\setlength{\textwidth}{6.5in}
\setlength{\textheight}{8in}
\renewcommand\normalsize{\fontsize{10pt}{12pt}\selectfont}
% Cryptic commands shamelessly stolen from the syntonly package to
% suppress output and hopefully speed-up things.
\output{\setbox\z@\box\@cclv
        \setbox\z@\box\footins
        \deadcycles\z@}

%%% Several commands are defined to test for packages:
%%%  \AddLayout{<layout>} adds an entry for <layout> in textclass.def
%%%  \TestDocClass{<name>}{<desc>}{<location>} tests whether <name>.cls
%%%   exists and creates a new entry with \AddLayout if this is the
%%%   case. The description in <desc> is added to the right section of the
%%%   doc. The location in <location> is used if the documentclass is not
%%%   available 
%%%  \TestPackage[<file>]{<name>}{<desc>}{<location>} tests whether the
%%%   package <name> exists. Its options are similar to those of
%%%   \TestDocClass, except that it accept an optional argument <file>,
%%%   which is the name of the file to test (by default <name>.sty). No
%%%   action is performed beside writing the description in the LyX file.
%%% The contents of the LyX file can be formatted using the following
%%% commands:
%%%  \layout{<layout>} begins a new paragraph with layout <layout>.
%%%  \textit, \emph, textsf and textbf can be used as in a normal LaTeX
%%%   file (except that they have been redefined to do the right thing!).
%%%  & is used to quote a lyx command.

\catcode`\&=\active \let&=\string

%%% A few crude macros to format LyX files
\newcommand\layout[1]{^^J^^J&\layout& #1^^J}
\renewcommand{\textit}[1]{^^J&\shape& italic^^J#1^^J&\shape& default^^J}
\renewcommand{\emph}{\textit}
\renewcommand{\textsf}[1]{^^J&\family& sans^^J#1^^J&\family& default^^J}
\renewcommand{\textbf}[1]{^^J&\series& bold^^J#1^^J&\series& default^^J}

%%% Macros to test for packages
\newcommand{\prefix}{+}
\newcommand{\defaulttext}{\layout{Standard}\textit{None.}}
\newcommand\CTAN[1]{You will find it on CTAN in the directory \textsf{#1}.}
\let \founditems=\defaulttext
\let \missingitems=\defaulttext
\newcommand\AddToText[2]{
  \ifx#1\defaulttext
    \xdef#1{#2}
  \else
    \xdef#1{#1 #2}
  \fi}
\newcommand{\WriteLineAux}[2]{\immediate\write#1{#2}\egroup}
\newcommand{\WriteLine}{\bgroup
\catcode 10 = 12% ^^J is a normal character
\endlinechar = 10% ^^J at the end of every input line
\newlinechar = 10% ^^J breaks line in \write
\catcode 32 = 12 % space is a normal character
\WriteLineAux}
\newcommand{\AddLayout}[1]{\WriteLine{\layouts}{#1 #1.layout}}
\newcommand{\StdDocClass}[2]{
  \IfFileExists{layouts/#1.layout}
    {\AddLayout{#1}
     \AddToText{\founditems}{\layout{Itemize}#2}}{}}
\newcommand{\TestDocClass}[3]{
  \IfFileExists{layouts/#1.layout}
    {\message{\prefix checking for document class #1...}
     \IfFileExists{#1.cls}
       {\message{yes^^J}
        \AddLayout{#1}
        \AddToText{\founditems}{\layout{Itemize}#2}}
       {\message{no^^J}
        \AddToText{\missingitems}{\layout{Itemize}#2 ^^J#3}}}{}}

\newcommand{\TestPackage}[4][*]{{
  \ifx*#1
    \newcommand{\pname}{#2} \newcommand{\pfile}{#2.sty}
  \else
    \newcommand{\pname}{#2} \newcommand{\pfile}{#1}
  \fi
  \message{\prefix checking for package \pname...}
  \IfFileExists{\pfile}
    {\message{yes^^J}
     \AddToText{\founditems}{\layout{Itemize}#3}}
    {\message{no^^J}
     \AddToText{\missingitems}{\layout{Itemize}#3 ^^J#4}}}}

%%% Initializes the files
\typeout{\prefix Inspecting your LaTeX configuration.}
\newwrite{\layouts}
\newwrite{\config}
\immediate \openout \layouts = layouts/textclass.def
\immediate \openout \config = doc/LaTeXConfig.lyx
\WriteLine{\config}{%
&#This file was created by \jobname.tex. DO NOT EDIT.
&#LyX 0.10 (C) 1995 1996 Matthias Ettrich and the LyX Team 
&\lyxformat 2.10
&\textclass article
&\language default
&\fontscheme default
&\epsfig dvips
&\papersize a4paper
&\paperfontsize 10
&\baselinestretch 1.00
&\secnumdepth 3
&\tocdepth 3
&\paragraph_separation indent
&\quotes_language english
&\quotes_times 2
&\paperorientation portrait
&\papercolumns 1
&\papersides 1
&\paperpagestyle plain
}%

\WriteLine{\layouts}{%
&# This file declares layouts and their associated definition files
&# (include directory relative to the place where this file is).
&# It has been automatically generated by \jobname.ltx
&# Re-run `latex \jobname.ltx' if you need to update it after a
&#    configuration change.}%

\nofiles %no auxiliary output files.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Clean up and end
\AtEndDocument{%% close files
\immediate\closeout\layouts
\immediate\closeout\config
\typeout{\prefix Inspection done.}
\typeout{\prefix Read the file doc/LaTeXConfig.lyx for more information.}}

