/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** storeRefNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ storeRefNodeList
storeRefNodeList_new ()
{
  storeRefNodeList s = (storeRefNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspace = storeRefNodeListBASESIZE;
  s->elements = (storeRefNode *) 
    dmalloc (sizeof (*s->elements) * storeRefNodeListBASESIZE);

  return (s);
}

static void
storeRefNodeList_grow (storeRefNodeList s)
{
  int i;
  storeRefNode *newelements; 

  s->nspace = storeRefNodeListBASESIZE + s->nspace;

  newelements = (storeRefNode *) dmalloc (sizeof (*newelements)
					  * (s->nelements + storeRefNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i]; 
    }

  sfree (s->elements); 
  s->elements = newelements;
}

storeRefNodeList
storeRefNodeList_add (storeRefNodeList s, storeRefNode el)
{
  if (s->nspace <= 0)
    storeRefNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ storeRefNodeList 
storeRefNodeList_copy (storeRefNodeList s)
{
  storeRefNodeList r = storeRefNodeList_new ();

  storeRefNodeList_elements (s, x)
    {
      r = storeRefNodeList_add (r, storeRefNode_copy (x));
    } end_storeRefNodeList_elements;

  return r;
}

/*@only@*/ cstring
storeRefNodeList_unparse (storeRefNodeList s)
{
  bool first = TRUE;
  cstring st = cstring_undefined;

  storeRefNodeList_elements (s, current)
  {
    if (first)
      {
	first = FALSE;
      }
    else
      {
	st = message ("%q, ", st);
      }

    switch (current->kind)
      {
      case SRN_OBJ:
	st = message ("%qobj", st);
	/*@switchbreak@*/ break;
      case SRN_TERM:
	st = message ("%q%q", st, termNode_unparse (current->content.term));
	/*@switchbreak@*/ break;
      case SRN_TYPE:
	st = message ("%q%q", st, lclTypeSpecNode_unparse (current->content.type));
	/*@switchbreak@*/ break;
      case SRN_SPECIAL:
	st = message ("%q%q", st, sRef_unparse (current->content.ref));
	/*@switchbreak@*/ break;
      }
  } end_storeRefNodeList_elements;

  return st;
}

void
storeRefNodeList_free (storeRefNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      storeRefNode_free (s->elements[i]);
    }

  sfree (s->elements);
  sfree (s);
}
