/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef UENTRY_H
# define UENTRY_H
# define CENTRY_H

/*
** universal symbol table entry
** (combines old llentry, centry, and ttentry)
*/

/*
** vkind --- need to fix value for consistency in dump files
*/

typedef struct _ucinfo
{
  /*@only@*/ multiVal val;
	     typeIdSet access;
} *ucinfo;

typedef enum 
{ 
  VKSPEC = 0, VKNORMAL, 
  VKPARAM, VKYIELDPARAM, VKREFYIELDPARAM,
  VKRETPARAM, VKREFPARAM, 
  VKSEFPARAM, VKREFSEFPARAM,
  VKSEFRETPARAM, VKREFSEFRETPARAM,
  VKEXPMACRO
} vkind;

/*@constant vkind VKFIRST;@*/
# define VKFIRST VKSPEC

/*@constant vkind VKLAST;@*/
# define VKLAST  VKEXPMACRO

typedef enum
{
  CH_UNKNOWN,
  CH_UNCHECKED,
  CH_CHECKED,
  CH_CHECKMOD,
  CH_CHECKEDSTRICT
} chkind;

typedef struct _uvinfo
{
  vkind   kind;      /* kind (parameter, specified) */
  chkind  checked;   /* how is it checked */
  sstate  defstate;
  nstate  nullstate;
} *uvinfo ;

typedef struct _udinfo
{
  ynm   abs;
  ynm   mut;
  ctype type;
} *udinfo ;

/* information for specified functions */

typedef enum
{
  SPC_NONE,
  SPC_PRINTFLIKE,
  SPC_SCANFLIKE,
  SPC_MESSAGELIKE,
  SPC_LAST
} specCode;

typedef struct _ufinfo
{
  qual nullPred;
  specCode specialCode;
  exitkind exitCode;
  typeIdSet access;     /* access types */

  /*@owned@*/ globSet globs;      /* globals list */
  /*@owned@*/ sRefSet mods;       /* modifies */

  specialClauses specclauses;

  /*@dependent@*/ uentryList defparams; 
  bool hasGlobs BOOLBITS;
  bool hasMods  BOOLBITS;
} *ufinfo ;

typedef struct _uiinfo
{
                  typeIdSet  access;
  /*@owned@*/     globSet     globs;      /* globals list */
  /*@owned@*/     sRefSet     mods;       /* modifies */
} *uiinfo ;

typedef struct _ueinfo
{
  typeIdSet   access;
} *ueinfo ;

typedef union _uinfo
{
  ucinfo uconst;
  uvinfo var;
  udinfo datatype;
  ufinfo fcn;
  uiinfo iter;
  ueinfo enditer;
} *uinfo ;

struct _uentry 
{
  ekind ukind;
  cstring uname;
  ctype utype;

  fileloc whereSpecified;
  fileloc whereDefined;
  fileloc whereDeclared;

  /* meaning of sref is different for:
  **        variables  current state
  **        functions  state of return value
  **        types      state of datatype
  */
  /*@exposed@*/ /*@null@*/ sRef sref;  

  /* Location list is complete only if showalluses is set. */
  filelocList uses; 

  bool                  used BOOLBITS;       
  bool                  lset BOOLBITS;      /* set in local table */
  bool                  isPrivate BOOLBITS; /* specification only */
  bool                  hasNameError BOOLBITS;

  storageClassCode      storageclass;
  /*@relnull@*/ uinfo   info; /* null for KELIPSMARKER, KINVALID */
} ;

extern int uentry_compareStrict (uentry v1, uentry v2);

/*@constant int PARAMUNKNOWN; @*/
# define PARAMUNKNOWN -1

extern bool uentry_isMaybeAbstract (uentry ue) /*@*/ ;
extern void uentry_setAbstract (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setConcrete (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setHasNameError (uentry ue) /*@modifies ue@*/ ;

extern /*@falsenull@*/ bool uentry_isLset (/*@sef@*/ uentry e);
# define uentry_isLset(e) \
  (uentry_isValid(e) && (e)->lset)

extern /*@falsenull@*/ bool uentry_isUsed (/*@sef@*/ uentry e);
# define uentry_isUsed(e)         (uentry_isValid(e) && (e)->used)

extern /*@unused@*/ /*@falsenull@*/ bool 
  uentry_isAbstractType (uentry e) /*@*/ ;
# define uentry_isAbstractType(e) (uentry_isAbstractDatatype(e))

extern /*@falsenull@*/ bool uentry_isConstant (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isConstant(e) \
  (uentry_isValid(e) && ekind_isConst ((e)->ukind))

extern /*@falsenull@*/ bool uentry_isEitherConstant (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isEitherConstant(e) \
  (uentry_isValid(e) && (ekind_isConst ((e)->ukind) || ekind_isEnumConst ((e)->ukind)))

extern /*@falsenull@*/ bool uentry_isEnumConstant (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isEnumConstant(e) \
  (uentry_isValid(e) && ekind_isEnumConst ((e)->ukind))

extern /*@falsenull@*/ bool uentry_isExternal (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isExternal(c) \
  (uentry_isValid(c) && fileloc_isExternal (uentry_whereDefined (c)))

extern /*@falsenull@*/ bool uentry_isExtern (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isExtern(c) \
  (uentry_isValid(c) && (c)->storageclass == SCEXTERN)

extern bool uentry_isForward (uentry e) /*@*/ ;

extern /*@falsenull@*/ bool uentry_isFunction (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isFunction(e) \
  (uentry_isValid(e) && ekind_isFunction ((e)->ukind))

extern /*@falsenull@*/ bool uentry_isPriv (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isPriv(e) \
  (uentry_isValid(e) && (e)->isPrivate)

extern /*@falsenull@*/ bool uentry_isFileStatic (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isExported (uentry ue) /*@*/ ;

extern /*@falsenull@*/ bool uentry_isStatic (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_isStatic(c) \
  (uentry_isValid(c) && (c)->storageclass == SCSTATIC)

extern void uentry_setLset (/*@sef@*/ uentry e);
# define uentry_setLset(e) \
  (uentry_isValid(e) ? (e)->lset = TRUE : TRUE)

extern bool uentry_isSpecialFunction (uentry ue) /*@*/ ;
extern bool uentry_isMessageLike (uentry ue) /*@*/ ;
extern bool uentry_isScanfLike (uentry ue) /*@*/ ;
extern bool uentry_isPrintfLike (uentry ue) /*@*/ ;

extern void uentry_setMessageLike (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setScanfLike (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setPrintfLike (uentry ue) /*@modifies ue@*/ ;

extern void uentry_checkName (uentry e) /*@modifies stderr, e@*/ ;

/*
** There is no uentry_isDefined to avoid confusion with
** uentry_isCodeDefined (which was previously called 
** uentry_isDefined.
*/

extern /*@truenull@*/ bool uentry_isUndefined (/*@special@*/ uentry e) 
   /*@*/ ;
extern /*@truenull@*/ bool uentry_isInvalid (/*@special@*/ uentry e) 
   /*@*/ ;
extern /*@falsenull@*/ bool uentry_isValid (/*@special@*/ uentry e) 
   /*@*/ ;

/*@constant null uentry uentry_undefined; @*/
# define uentry_undefined ((uentry) NULL)

# define uentry_isUndefined(e) ((e) == uentry_undefined)
# define uentry_isValid(e)     ((e) != uentry_undefined)
# define uentry_isInvalid(e)   ((e) == uentry_undefined)

extern bool uentry_sameObject (uentry e1, uentry e2);
# define uentry_sameObject(e1,e2) ((e1) == (e2))

extern void uentry_addAccessType (uentry ue, typeId tid) /*@modifies ue@*/ ;

extern void uentry_showWhereAny (uentry spec)
     /*@modifies stderr@*/ ;

extern void uentry_checkExternParams (uentry ue);
extern void uentry_mergeUses (uentry res, uentry other);
extern void uentry_setExtern (uentry c);
extern void uentry_setUsed (uentry e, fileloc loc);
extern void uentry_setDefState (uentry ue, sstate defstate);

extern void uentry_setNotUsed (/*@sef@*/ uentry e);
# define uentry_setNotUsed(e) \
  (uentry_isValid (e) ? (e)->used = FALSE : FALSE)

extern bool uentry_wasUsed (/*@sef@*/ uentry e);
# define uentry_wasUsed(e) \
  (uentry_isValid (e) ? (e)->used : TRUE)

extern void uentry_mergeConstantValue (uentry ue, /*@only@*/ multiVal m);

extern /*@observer@*/ fileloc uentry_whereEarliest (uentry e) /*@*/ ;
extern /*@observer@*/ cstring uentry_rawName (uentry e) /*@*/ ;
extern /*@observer@*/ fileloc uentry_whereDeclared (uentry e) /*@*/ ;
extern bool uentry_equiv (uentry p1, uentry p2) /*@*/ ;
extern /*@falsenull@*/ bool uentry_hasName (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_hasRealName (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isAbstractDatatype (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isAnyTag (/*@special@*/ uentry ue)
   /*@uses ue->ukind@*/
   /*@*/ ;
extern /*@falsenull@*/ bool uentry_isDatatype (uentry e) /*@*/ ;

extern /*@falsenull@*/ bool uentry_isCodeDefined (uentry e) /*@*/ ;

extern /*@falsenull@*/ bool uentry_isDeclared (/*@special@*/ uentry e) 
   /*@uses e->whereDeclared@*/ /*@*/ ;

extern /*@observer@*/ cstring uentry_ekindName (uentry ue) /*@*/ ;
extern void uentry_showWhereDefined (uentry spec);
extern /*@falsenull@*/ bool uentry_isEndIter (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isEnumTag (/*@special@*/ uentry e)
   /*@uses e->ukind@*/ /*@*/ ;
extern /*@falsenull@*/ bool uentry_isFakeTag (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isIter (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isMutableDatatype (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isParam (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isExpandedMacro (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isSefParam (uentry u) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isAnyParam (/*@special@*/ uentry u) 
   /*@uses u->ukind, u->info@*/ 
   /*@*/ ;

extern /*@falsenull@*/ bool uentry_isRealFunction (uentry e) /*@*/ ;
extern /*@falsenull@*/ bool uentry_isSpecified (uentry e) /*@*/ ;

extern /*@falsenull@*/ bool uentry_isStructTag (/*@special@*/ uentry e) 
   /*@uses e->ukind@*/ /*@*/ ;
extern /*@falsenull@*/ bool uentry_isUnionTag (/*@special@*/ uentry e)
   /*@uses e->ukind@*/ /*@*/ ;

extern /*@falsenull@*/ bool uentry_isVar (/*@special@*/ uentry e) 
   /*@uses e->ukind@*/
   /*@*/ ;

extern /*@falsenull@*/ bool uentry_isVariable (/*@special@*/ uentry e) 
   /*@uses e->ukind@*/
   /*@*/ ;

extern cstring uentry_dump (uentry v) ; 
extern cstring uentry_dumpParam (uentry v);
extern cstring uentry_getName (/*@special@*/ uentry e) 
   /*@uses e->ukind, e->info, e->uname@*/
   /*@*/ ;

extern cstring uentry_unparse (uentry v) /*@*/ ;
extern cstring uentry_unparseAbbrev (uentry v) /*@*/ ;
extern cstring uentry_unparseFull (uentry v) /*@*/ ;
extern void uentry_setMutable (uentry e) /*@modifies e@*/ ;
extern ctype uentry_getAbstractType (uentry e) /*@*/ ;
extern ctype uentry_getRealType (uentry e) /*@globals internalState@*/ ;
extern ctype uentry_getType (uentry e) /*@*/ ;
extern ekind uentry_getKind (uentry e) /*@*/ ;
extern /*@observer@*/ fileloc uentry_whereDefined (uentry e) /*@*/ ;
extern /*@observer@*/ fileloc uentry_whereSpecified (uentry e) /*@*/ ;
extern int  uentry_compare (uentry u1, uentry u2);
extern int  uentry_xcompare (uentry *p1, uentry *p2);
extern /*@exposed@*/ sRef uentry_getSref (/*@temp@*/ uentry u) /*@*/ ;
extern /*@observer@*/ sRefSet uentry_getMods (uentry l) /*@*/ ;
extern typeIdSet uentry_accessType (uentry e) /*@*/ ;
extern /*@observer@*/ fileloc uentry_whereEither (uentry e) /*@*/ ;
extern /*@notnull@*/ uentry uentry_makeExpandedMacro (cstring s, 
						      /*@temp@*/ fileloc f)
  /*@*/ ;

extern /*@observer@*/ specialClauses uentry_getSpecialClauses (uentry e) /*@*/ ;

extern void uentry_showWhereLastExtra (uentry spec, /*@only@*/ cstring extra) 
   /*@modifies stderr@*/ ;

extern /*@notnull@*/ uentry
  uentry_makeSpecEnumConstant (cstring n, ctype t, /*@keep@*/ fileloc loc) /*@*/ ;

extern /*@notnull@*/ uentry
  uentry_makeEnumConstant (cstring n, ctype t) /*@*/ ;

extern /*@notnull@*/ /*@only@*/ uentry 
  uentry_makeConstant (/*@temp@*/ cstring n, ctype t, /*@keep@*/ fileloc f) 
  /*@*/ ;
extern /*@notnull@*/ /*@only@*/ uentry 
  uentry_makeConstantAux (/*@temp@*/ cstring n, ctype t,
			  /*@keep@*/ fileloc f, bool priv,
			  /*@only@*/ multiVal m) /*@*/ ;
extern /*@notnull@*/ /*@only@*/ uentry 
  uentry_makeDatatype (/*@temp@*/ cstring n, ctype t, ynm mut, ynm abs, 
		       /*@only@*/ fileloc f) /*@*/ ;
extern /*@notnull@*/ /*@only@*/ uentry 
  uentry_makeDatatypeAux (/*@temp@*/ cstring n, ctype t, ynm mut, 
			  ynm abs, /*@keep@*/ fileloc f, bool priv) /*@*/ ;
extern /*@notnull@*/ uentry uentry_makeElipsisMarker (void) /*@*/ ;

extern void uentry_makeVarFunction (/*@temp@*/ uentry ue) /*@modifies ue@*/ ;

extern bool uentry_isElipsisMarker (/*@sef@*/ uentry u) /*@*/ ;
# define uentry_isElipsisMarker(u) \
  (uentry_isValid(u) && ekind_isElipsis ((u)->ukind))

extern /*@notnull@*/ uentry 
  uentry_makeEndIter (cstring n, /*@only@*/ fileloc f) /*@*/ ;
extern /*@notnull@*/ uentry 
  uentry_makeEnumTag (cstring n, ctype t, /*@only@*/ fileloc loc) /*@*/ ;
extern /*@notnull@*/ uentry 
  uentry_makeEnumTagLoc (cstring ename, ctype cet) /*@*/ ;
extern /*@notnull@*/ uentry 
  uentry_makeForwardFunction (cstring e, typeId n, /*@temp@*/ fileloc f) /*@*/ ;
extern /*@notnull@*/ uentry 
  uentry_makeTypeListFunction (cstring e, typeIdSet n, /*@only@*/ fileloc f) 
  /*@*/ ;
extern /*@notnull@*/ uentry 
  uentry_makeFunction (cstring n, ctype t, 
		       typeId access, 
		       /*@only@*/ globSet globs, /*@only@*/ sRefSet mods, 
		       /*@only@*/ fileloc f);
extern /*@notnull@*/ uentry 
  uentry_makeSpecFunction (cstring n, ctype t,
			   typeIdSet access, /*@only@*/ globSet globs, 
			   /*@only@*/ sRefSet mods, /*@keep@*/ fileloc f);
extern /*@notnull@*/ uentry
  uentry_makeIter (cstring n, ctype ct, /*@only@*/ fileloc f) /*@*/ ;
extern /*@notnull@*/ uentry 
  uentry_makeParam (idDecl t, int i) /*@*/ ;

extern /*@notnull@*/ uentry
  uentry_makePrivFunction2 (cstring n, ctype t, 
			    typeIdSet access, 
			    /*@only@*/ globSet globs, 
			    /*@only@*/ sRefSet mods, /*@keep@*/ fileloc f);

extern /*@notnull@*/ uentry 
  uentry_makeStructTag (cstring n, ctype t, /*@only@*/ fileloc loc);
extern /*@notnull@*/ uentry 
  uentry_makeStructTagLoc (cstring id, ctype ct);
extern /*@notnull@*/ uentry 
  uentry_makeUnionTag (cstring n, ctype t, /*@only@*/ fileloc loc);
extern /*@notnull@*/ uentry 
  uentry_makeUnionTagLoc (cstring id, ctype ct);
extern /*@notnull@*/ uentry 
  uentry_makeUnspecFunction (cstring n, ctype t, typeIdSet access, 
			     /*@keep@*/ fileloc f);
extern /*@notnull@*/ uentry 
  uentry_makeVariable (cstring n, ctype t, /*@keep@*/ fileloc f, bool isPriv);
extern /*@notnull@*/ /*@only@*/ uentry 
  uentry_makeVariableLoc (cstring n, ctype t);
extern /*@notnull@*/ /*@only@*/ 
  uentry uentry_makeVariableParam (cstring n, ctype t);
extern /*@notnull@*/ /*@only@*/ 
  uentry uentry_makeVariableSrefParam (cstring n, ctype t, 
				       sRef s);
extern /*@notnull@*/ /*@only@*/ 
  uentry uentry_makeIdFunction (idDecl id);
extern /*@notnull@*/ /*@only@*/ 
  uentry uentry_makeIdDatatype (idDecl id);
extern /*@notnull@*/ /*@only@*/ 
  uentry uentry_makeBoolDatatype (ynm abs);
extern void uentry_mergeDefinition (uentry old, /*@only@*/ uentry new);
extern void uentry_mergeEntries (uentry spec, /*@only@*/ uentry def);
extern uentry uentry_nameCopy (/*@only@*/ cstring name, uentry e);
extern uentry uentry_undump (ekind kind, fileloc loc, char **s);
extern /*@observer@*/ uentryList uentry_getParams (uentry l) /*@*/ ;
extern void uentry_resetParams (uentry e, /*@only@*/ uentryList pn)
               /*@modifies e@*/ ;
extern /*@observer@*/ globSet uentry_getGlobs (uentry l) /*@*/ ;
extern qual uentry_nullPred (uentry u);
extern void uentry_free (/*@only@*/ /*@only@*/ uentry e);
extern void uentry_setDatatype (uentry e, usymId uid);

extern void uentry_setDefined (/*@special@*/ uentry e, fileloc f)
   /*@uses e->whereDefined, e->ukind, e->uname, e->info@*/
   /*@modifies e@*/ ;

extern void uentry_checkDecl (void);
extern void uentry_clearDecl (void);
extern void uentry_setDeclared (uentry e, fileloc f);
extern void uentry_setDeclaredOnly (uentry e, /*@only@*/ fileloc f);
extern void uentry_setDeclaredForceOnly (uentry e, /*@only@*/ fileloc f);
extern void uentry_setFunctionDefined (uentry e, fileloc loc);
extern void uentry_setName (uentry e, /*@only@*/ cstring s);
extern void uentry_setParam (uentry e);
extern void uentry_setSref (uentry e, /*@exposed@*/ sRef s);
extern void uentry_setStatic (uentry e);

extern void uentry_setModifies (uentry e, /*@owned@*/ sRefSet mods)
   /*@modifies e, mods@*/; 

extern void uentry_setSpecialClauses (uentry e, /*@only@*/ specialClauses clauses)
   /*@modifies e@*/ ;

extern void uentry_setType (uentry e, ctype ct);

extern /*@unused@*/ /*@observer@*/ cstring uentry_checkedName (uentry ue);
extern void uentry_showWhereLastPlain (uentry spec) /*@modifies stderr@*/ ;

extern void 
  uentry_showWhereSpecifiedExtra (uentry spec, /*@only@*/ cstring s)
  /*@modifies stderr@*/ ;

extern void uentry_showWhereSpecified (uentry spec) /*@modifies stderr@*/ ; 
extern void uentry_showWhereLast (uentry spec) /*@modifies stderr@*/ ;
extern void uentry_showWhereDeclared (uentry spec) /*@modifies stderr@*/ ;

extern /*@notnull@*/ /*@only@*/ uentry uentry_makeIdVariable (idDecl t) /*@*/ ;
extern uentry uentry_copy (uentry u) /*@*/ ;
extern void uentry_freeComplete (/*@only@*/ uentry e) ;
extern void uentry_clearDefined (uentry e) /*@modifies e@*/;
extern /*@observer@*/ cstring uentry_specDeclName (uentry u) /*@*/ ;

extern void 
  uentry_mergeState (uentry res, uentry other, fileloc loc,
		     bool mustReturn, bool flip, bool opt, 
		     clause cl) /*@modifies res, other@*/ ;

extern void uentry_setState (uentry res, uentry other)
   /*@modifies res, other@*/ ;

extern void uentry_setRefParam (uentry e) /*@modifies e@*/ ;

extern void uentry_setDeclaredForce (uentry e, fileloc f) /*@modifies e@*/;
extern bool uentry_isNonLocal (uentry ue) /*@*/ ;
extern bool uentry_isRefParam (uentry u) /*@*/ ;
extern bool uentry_hasGlobs (uentry ue) /*@*/ ;
extern bool uentry_hasMods (uentry ue) /*@*/ ;

extern bool uentry_hasSpecialClauses (uentry ue) /*@*/ ;
extern exitkind uentry_getExitCode (uentry ue) /*@*/ ;

extern void uentry_checkYieldParam (uentry old, uentry new);
extern bool uentry_isOnly (uentry ue) /*@*/ ;
extern bool uentry_isUnique (uentry ue) /*@*/ ;
extern /*@notnull@*/ /*@only@*/ uentry uentry_makeUnnamedVariable (ctype t);
extern void uentry_reflectQualifiers (uentry ue, qualList q) /*@modifies ue@*/;
extern bool uentry_isOut (uentry u) /*@*/ ;
extern bool uentry_isPartial (uentry u) /*@*/ ;
extern bool uentry_isStateSpecial (uentry u) /*@*/ ;
extern bool uentry_possiblyNull (uentry u) /*@*/ ;
extern ctype uentry_getForceRealType (uentry e) /*@globals internalState@*/ ;
extern alkind uentry_getAliasKind (uentry u) /*@*/ ;
extern exkind uentry_getExpKind (uentry u) /*@*/ ;
extern /*@observer@*/ multiVal uentry_getConstantValue (uentry e) /*@*/ ;
extern void uentry_fixupSref (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setGlobals (uentry ue, /*@owned@*/ globSet globs) /*@modifies ue@*/ ;
extern bool uentry_isYield (uentry ue) /*@*/ ;
extern /*@notnull@*/ uentry uentry_makeIdConstant (idDecl t) /*@*/ ;
extern /*@observer@*/ cstring uentry_getRealName (uentry e) /*@*/ ;
extern int uentry_xcompareuses (uentry *p1, uentry *p2) /*@*/ ;
extern /*@observer@*/ cstring uentry_specOrDefName (uentry u) /*@*/ ;
extern void uentry_copyState (uentry res, uentry other);
extern bool uentry_sameKind (uentry u1, uentry u2);
extern /*@exposed@*/ sRef uentry_returnedRef (uentry u, exprNodeList args);
extern bool uentry_isReturned (uentry u);
extern bool uentry_isRefCountedDatatype (uentry e);
extern void uentry_setRefCounted (uentry e);
extern sstate uentry_getDefState (uentry u);
extern /*@unused@*/ void uentry_markFree (/*@owned@*/ uentry u);
extern /*@dependent@*/ sRef uentry_getOrigSref (uentry e);
extern void uentry_destroyMod (void) /*@modifies internalState@*/;
extern void uentry_showDefSpecInfo (uentry ue, fileloc fwhere);
extern void uentry_markOwned (/*@owned@*/ uentry u);

extern /*@observer@*/ fileloc uentry_whereLast (uentry e) /*@*/ ;
extern void uentry_setParamNo (uentry ue, int pno) /*@modifies ue@*/;

extern /*@observer@*/ filelocList uentry_getUses (/*@sef@*/ uentry e) /*@*/ ;
# define uentry_getUses(u) (uentry_isValid (u) ? (u)->uses : filelocList_undefined)

extern bool uentry_isCheckedUnknown (uentry ue) /*@*/ ;
extern bool uentry_isCheckedModify (uentry ue) /*@*/ ;
extern bool uentry_isUnchecked (uentry ue) /*@*/ ;
extern bool uentry_isChecked (uentry ue) /*@*/ ;
extern bool uentry_isCheckMod (uentry ue) /*@*/ ;
extern bool uentry_isCheckedStrict (uentry ue) /*@*/ ;
extern void uentry_setUnchecked (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setChecked (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setCheckMod (uentry ue) /*@modifies ue@*/ ;
extern void uentry_setCheckedStrict (uentry ue) /*@modifies ue@*/ ;

extern bool uentry_hasAccessType (uentry e);

# ifdef DOANNOTS
typedef enum { AN_UNKNOWN, AN_FCNRETURN, AN_FCNPARAM, AN_SUFIELD, AN_TDEFN, AN_GSVAR,
		 AN_CONST, AN_LAST
	       } ancontext;

extern void initAnnots ();
extern void printAnnots (void);
extern void uentry_tallyAnnots (uentry u, ancontext kind);
# endif /* DOANNOTS */

# else
# error "Multiple include"
# endif



