/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** sRefSet.h
**
** based on set_template.h
*/

# ifndef sRefSET_H
# define sRefSET_H

struct _sRefSet
{
  int entries;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ sRef *elements;
} ;

/* in forwardTypes: typedef _sRefSet *sRefSet; */

/*
** realElements --- only non-objects 
*/

/*@iter sRefSet_realElements (sef sRefSet s, yield exposed sRef el)@*/
# define sRefSet_realElements(x, m_el) \
   { int m_ind; if (sRefSet_isDefined (x)) \
     { for (m_ind = 0 ; m_ind < (x)->entries; m_ind++) \
       { sRef m_el = (x)->elements[m_ind]; if (!(sRef_isExternal(m_el))) {
# define end_sRefSet_realElements }}}}

/*@iter sRefSet_elements (sef sRefSet s, yield exposed sRef el)@*/
# define sRefSet_elements(s,m_el) sRefSet_allElements (s, m_el)
# define end_sRefSet_elements   end_sRefSet_allElements

/*@iter sRefSet_allElements (sef sRefSet s, yield exposed sRef el)@*/
# define sRefSet_allElements(x, m_el) \
   { int m_ind; if (sRefSet_isDefined (x)) { \
     for (m_ind = 0 ; m_ind < (x)->entries; m_ind++) \
       { sRef m_el = (x)->elements[m_ind];  

# define end_sRefSet_allElements }}}

/*@constant int sRefSetBASESIZE;@*/
# define sRefSetBASESIZE SMALLBASESIZE

/*@constant null sRefSet sRefSet_undefined;@*/
# define sRefSet_undefined ((sRefSet) 0)

extern /*@truenull@*/ bool sRefSet_isUndefined (sRefSet s) /*@*/ ;
extern /*@truenull@*/ bool sRefSet_isEmpty (/*@sef@*/ sRefSet s) /*@*/ ;
extern /*@falsenull@*/ bool sRefSet_isDefined (sRefSet s) /*@*/ ;

# define sRefSet_isUndefined(s) ((s) == sRefSet_undefined)
# define sRefSet_isDefined(s)   ((s) != sRefSet_undefined)

# define sRefSet_isEmpty(s) \
  ((s) == sRefSet_undefined || ((s)->entries == 0))

extern bool sRefSet_equal (sRefSet s1, sRefSet s2) /*@*/ ;
extern bool sRefSet_hasRealElement (sRefSet s) /*@*/ ;
extern bool sRefSet_hasUnconstrained (sRefSet s) /*@*/ ;
extern cstring sRefSet_unparsePlain (sRefSet s) /*@*/ ;
extern cstring sRefSet_unparseUnconstrained (sRefSet s) /*@*/ ;
extern cstring sRefSet_unparseUnconstrainedPlain (sRefSet s) /*@*/ ;
extern void sRefSet_fixSrefs (sRefSet s);
extern bool sRefSet_delete (sRefSet s, sRef el);
extern /*@exposed@*/ sRef sRefSet_lookupMember (sRefSet s, sRef el);
extern bool sRefSet_isSameMember (sRefSet s, sRef el) /*@*/ ;
extern bool sRefSet_isSameNameMember (sRefSet s, sRef el) /*@*/ ;
extern /*@only@*/ sRefSet sRefSet_newCopy (/*@exposed@*/ /*@temp@*/ sRefSet s);
extern /*@only@*/ sRefSet sRefSet_newDeepCopy (sRefSet s);
extern int sRefSet_size(sRefSet s) /*@*/ ;
extern sRefSet sRefSet_union (/*@returned@*/ sRefSet s1, /*@exposed@*/ sRefSet s2);
extern sRefSet sRefSet_unionFree (/*@returned@*/ sRefSet s1, /*@only@*/ sRefSet s2);
extern /*@only@*/ sRefSet sRefSet_new (void) /*@*/ ;
extern /*@only@*/ sRefSet sRefSet_single (/*@exposed@*/ sRef s);
extern sRefSet sRefSet_insert (/*@returned@*/ sRefSet s, /*@exposed@*/ sRef el);
extern bool sRefSet_member (sRefSet s, sRef el) /*@*/ ;
extern /*@only@*/ cstring sRefSet_unparse (sRefSet s) /*@*/ ;
extern void sRefSet_free (/*@only@*/ sRefSet s) /*@modifies s@*/;
extern void sRefSet_clear (sRefSet s) /*@modifies s@*/;
extern /*@only@*/ sRefSet sRefSet_addIndirection (sRefSet s) /*@*/ ;
extern /*@only@*/ sRefSet sRefSet_removeIndirection (sRefSet s) /*@*/ ;
extern sRefSet 
  sRefSet_copy (/*@returned@*/ sRefSet s1, /*@exposed@*/ sRefSet s2) 
  /*@modifies s1@*/ ;
extern void sRefSet_levelPrune (sRefSet s, int lexlevel)
  /*@modifies s@*/ ;
extern void sRefSet_clearStatics (sRefSet s)
  /*@modifies s@*/ ;
extern sRefSet sRefSet_levelUnion (/*@returned@*/ sRefSet sr, sRefSet s, int lexlevel);
extern /*@only@*/ sRefSet sRefSet_intersect (sRefSet s1, sRefSet s2);
extern /*@only@*/ sRefSet sRefSet_fetchKnown (sRefSet s, int i);
extern /*@only@*/ sRefSet sRefSet_fetchUnknown (sRefSet s);
extern /*@only@*/ sRefSet sRefSet_accessField (sRefSet s, /*@observer@*/ cstring f);
extern /*@only@*/ sRefSet sRefSet_realNewUnion (sRefSet s1, sRefSet s2);
extern /*@only@*/ cstring sRefSet_unparseDebug (sRefSet s) /*@*/ ;
extern /*@unused@*/ cstring sRefSet_unparseFull (sRefSet s) /*@*/ ;
# define sRefSet_unparseFull(s) sRefSet_unparseDebug(s)
extern int sRefSet_compare (sRefSet s1, sRefSet s2) /*@*/ ;
extern bool sRefSet_modifyMember (sRefSet s, sRef m) /*@modifies m@*/ ;
extern /*@only@*/ sRefSet sRefSet_undump (char **s) /*@modifies *s@*/ ;
extern /*@only@*/ cstring sRefSet_dump (sRefSet sl) /*@*/ ;
extern bool sRefSet_deleteBase (sRefSet s, sRef base) /*@modifies s@*/ ;
extern /*@exposed@*/ sRef sRefSet_choose (sRefSet s) /*@*/ ;
extern sRef sRefSet_mergeIntoOne (sRefSet s) /*@*/ ;
extern /*@only@*/ sRefSet 
  sRefSet_levelCopy (/*@exposed@*/ sRefSet s, int lexlevel) /*@*/ ;
extern sRefSet 
  sRefSet_unionExcept (/*@returned@*/ sRefSet s1, sRefSet s2, sRef ex)
     /*@modifies s1@*/ ;

extern bool sRefSet_hasStatic (sRefSet s) /*@*/ ;

# else
# error "Multiple include"
# endif



