/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef LLMAIN_H
# define LLMAIN_H

extern int main (int argc, char *argv[])
  /*@globals killed undef currentloc,
             killed       localIncludePath,
             killed       includePath, 
	     killed       localSpecPath,  
	     killed undef currentSpec,
	     killed undef currentSpecName,
	     killed undef currentloc,
	     killed undef yyin,
	     yydebug;
   @*/
  /*@modifies currentloc, localIncludePath, includePath,
              localSpecPath, currentSpec, currentSpecName,
	      yyin, yydebug, internalState, fileSystem; 
  @*/ ;

extern /*@exits@*/ void llexit (int status);      
extern void showHerald (void);

/*@-redecl@*/
extern int yyparse (void);
extern int ylparse (void);
extern void yyrestart (FILE *f);
extern int lslparse (void);
/*@=redecl@*/

# ifndef unlink
extern /*@external@*/ int unlink (char *s) /*@modifies fileSystem@*/ ;
# endif

/*@-incondefs@*/ /*@-redecl@*/
extern /*@dependent@*/ FILE *yyin;
/*@=incondefs@*/ /*@=redecl@*/

/* from <unistd.h> (cannot include because <stddef.h> is broken on many machines */
extern /*@external@*/ int getpid (void);

# ifndef system
extern /*@external@*/ int system (const char *) /*@modifies fileSystem@*/ ;
# endif

# endif


