/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** indxMap.h
*/

# ifndef INDXMAP_H
# define INDXMAP_H

/*@constant int INDXMAP_BASESIZE; @*/
# define INDXMAP_BASESIZE 32

typedef struct _indxMap
{
  int entries;
  int *map;
} *indxMap ;

extern /*@unused@*/ /*@only@*/ cstring indxMap_unparse (indxMap map);
extern int indxMap_map (indxMap map, int i);
extern void indxMap_addpair (indxMap map, int from, int to) /*@modifies map@*/;
extern /*@only@*/ indxMap indxMap_create (void) /*@*/ ;
extern int indxMap_mapSafe (indxMap map, int i) /*@*/ ;
extern void indxMap_free (/*@only@*/ indxMap map);

# else
# error "Multiple include"
# endif
