/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** idDecl.h
*/

# ifndef idDecl_H
# define idDecl_H

struct _idDecl
{
  cstring id;
  qtype   typ;
} ; 

/*@constant null idDecl idDecl_undefined; @*/
# define idDecl_undefined ((idDecl) NULL)

extern /*@falsenull@*/ bool idDecl_isDefined (idDecl t) /*@*/ ;
# define idDecl_isDefined(t) ((t) != idDecl_undefined)

extern void idDecl_free (/*@only@*/ idDecl t);
extern /*@only@*/ idDecl 
  idDecl_create (/*@only@*/ cstring s, /*@only@*/ qtype t);
extern /*@only@*/ cstring idDecl_unparse (idDecl v);
extern /*@exposed@*/ qtype idDecl_getTyp (idDecl v);
extern void idDecl_setTyp (idDecl v, /*@only@*/ qtype c);
extern idDecl idDecl_expectFunction (/*@returned@*/ idDecl id);
extern idDecl idDecl_replaceCtype (/*@returned@*/ idDecl d, ctype c);
extern idDecl idDecl_fixBase (/*@returned@*/ idDecl t, qtype b);
extern idDecl idDecl_fixParamBase (/*@returned@*/ idDecl t, qtype b);
extern ctype idDecl_getCtype (idDecl d) /*@*/ ;
extern /*@exposed@*/ qualList idDecl_getQuals (idDecl d) /*@*/ ; 

extern /*@dependent@*/ /*@observer@*/ cstring idDecl_getName (idDecl t) /*@*/ ;
extern /*@observer@*/ cstring idDecl_observeId (idDecl d) /*@*/ ;
extern void idDecl_addQual (idDecl d, qual q);

# define idDecl_getName(t) idDecl_observeId(t)

# else
# error "Multiple include"
# endif


