/*
** LCLint Standard C Library
** Unix version.
*/

/*@-nextlinemacros@*/
/*@+allimponly@*/
/*@+globsimpmodifiesnothing@*/

/*
** errno.h
*/

/*@constant int EDOM;@*/
/*@constant int ERANGE;@*/

/*@unchecked@*/ int errno;

/* Only in unix lib: */
/*@unchecked@*/ int signgam;

/*
** types 
*/

/*
** These types should really be different.  Not sure how to
** describe them, though.
**
** Don't want to make them abstract, since implementations
** can rely on them being integral, but shouldn't rely on the
** particular size.
*/

typedef long int ptrdiff_t;    
typedef unsigned long size_t;
typedef signed long ssize_t;
typedef unsigned int wchar_t;

/*@constant null anytype NULL = 0;@*/

/*
** assert.h
*/

/*@constant bool NDEBUG;@*/
extern /*@falseexit@*/ void assert (/*@sef@*/ bool /*@alt int@*/ e) 
  /*@*/ ;

/*
** ctype.h
*/

extern bool /*@alt int@*/ isalnum (char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ isalpha (char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ iscntrl (char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ isdigit(char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ isgraph(char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ islower(char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ isprint(char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ ispunct(char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ isspace(char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ isupper(char /*@alt int@*/ c) /*@*/ ;
extern bool /*@alt int@*/ isxdigit(char /*@alt int@*/ c) /*@*/ ;
extern char /*@alt int@*/ tolower(char /*@alt int@*/ c) /*@*/ ;
extern char /*@alt int@*/ toupper(char /*@alt int@*/ c) /*@*/ ;

/*
** locale.h
*/

struct lconv
{
  char *decimal_point;
  char *thousands_sep;
  char *grouping;
  char *int_curr_symbol;
  char *currency_symbol;
  char *mon_decimal_point;
  char *mon_thousands_sep;
  char *mon_grouping;
  char *positive_sign;
  char *negative_sign;
  char int_frac_digits;
  char frac_digits;
  char p_cs_precedes;
  char p_sep_by_space;
  char n_cs_precedes;
  char n_sep_by_space;
  char p_sign_posn;
  char n_sign_posn;
} ;

/*@constant int LC_ALL;@*/
/*@constant int LC_COLLATE;@*/
/*@constant int LC_CTYPE;@*/
/*@constant int LC_MONETARY;@*/
/*@constant int LC_NUMERIC;@*/
/*@constant int LC_TIME;@*/

extern /*@observer@*/ /*@null@*/ char *
  setlocale (int category, /*@null@*/ char *locale) 
  /*@modifies internalState, errno@*/ ;

extern struct lconv *localeconv (void) /*@*/ ;

/*
** float.h
*/

/*@constant int FLT_RADIX; @*/
/*@constant int FLT_ROUNDS; @*/
/*@constant int FLT_DIG; @*/
/*@constant float FLT_EPSILON; @*/
/*@constant int FLT_MANT_DIG; @*/
/*@constant float FLT_MAX; @*/
/*@constant int FLT_MAX_EXP; @*/
/*@constant float FLT_MIN; @*/
/*@constant int FLT_MIN_EXP; @*/

/*@constant int DBL_DIG; @*/
/*@constant double DBL_EPSILON; @*/
/*@constant int DBL_MANT_DIG; @*/
/*@constant double DBL_MAX; @*/
/*@constant int DBL_MAX_EXP; @*/
/*@constant double DBL_MIN; @*/
/*@constant int DBL_MIN_EXP; @*/

/*
** limits.h
*/

/*@constant int CHAR_BIT; @*/
/*@constant char CHAR_MAX; @*/
/*@constant char CHAR_MIN; @*/
/*@constant int INT_MAX; @*/
/*@constant int INT_MIN; @*/
/*@constant long int LONG_MAX; @*/
/*@constant long int LONG_MIN; @*/
/*@constant signed char SCHAR_MAX; @*/
/*@constant signed char SCHAR_MIN; @*/
/*@constant short SHRT_MAX; @*/
/*@constant short SHRT_MIN; @*/
/*@constant unsigned char UCHAR_MAX; @*/
/*@constant unsigned char UCHAR_MIN; @*/
/*@constant unsigned int UINT_MAX; @*/
/*@constant unsigned long ULONG_MAX; @*/
/*@constant unsigned short USHRT_MAX; @*/

/*
** math.h
*/

/*@constant double HUGE_VAL; @*/

/*
** math functions that may have a range error modify errno 
*/

extern double sin (double x) /*@*/ ;
extern double cos (double x) /*@*/ ;
extern double tan (double x) /*@*/ ;
extern double asin (double x) /*@modifies errno@*/ ;
extern double acos (double x) /*@modifies errno@*/ ;
extern double atan (double x) /*@*/ ;
extern double atan2 (double y, double x) /*@*/ ;
extern double sinh (double x) /*@*/ ;
extern double cosh (double x) /*@modifies errno@*/ ;
extern double tanh (double x) /*@*/ ;

extern double exp (double x) /*@modifies errno@*/ ;
extern double ldexp (double x, int n) /*@*/ ;
extern double frexp (double x, /*@out@*/ int *xp) /*@modifies *xp;@*/ ;

extern double log (double x) /*@modifies errno@*/ ;
extern double log10 (double x) /*@modifies errno@*/ ;

extern double pow (double x, double y) /*@modifies errno@*/ ;
extern double sqrt (double x) /*@modifies errno@*/ ;

extern double ceil (double x) /*@*/ ;
extern double floor (double x) /*@*/ ;
extern double fabs (double x) /*@*/ ;

double modf (double x, /*@out@*/ double *ip) /*@modifies *ip;@*/ ;
double fmod (double x, double y) /*@*/ ;

/*
** setjmp.h
*/

typedef /*@abstract@*/ /*@mutable@*/ void *jmp_buf;

extern int setjmp (/*@out@*/ jmp_buf env) /*@modifies env;@*/ ;
extern /*@mayexit@*/ void longjmp (jmp_buf env, int val) /*@*/ ;

/*
** signal.h
*/

/*@constant int SIGABRT; @*/
/*@constant int SIGFPE; @*/
/*@constant int SIGILL; @*/
/*@constant int SIGINT; @*/
/*@constant int SIGSEGV; @*/
/*@constant int SIGTERM; @*/

typedef int sig_atomic_t;

/*@constant void (*SIG_DFL)(int); @*/
/*@constant void (*SIG_ERR)(int); @*/
/*@constant void (*SIG_IGN)(int); @*/

extern /*@mayexit@*/ void (*signal) (int sig, /*@null@*/ void (*func)(int)) 
   /*@modifies internalState, errno;@*/ ;

extern /*@exits@*/ int raise (int sig) ;

/*
** stdarg.h
*/

typedef /*@abstract@*/ /*@mutable@*/ void *va_list;

extern void va_start(/*@out@*/ va_list ap, ...) /*@modifies ap;@*/ ;
extern void va_end (va_list va) /*@modifies va;@*/ ;

/*
** va_arg is builtin
*/

/*
** stdio.h
*/

typedef /*@abstract@*/ /*@mutable@*/ void *FILE;
typedef /*@abstract@*/ /*@mutable@*/ void *fpos_t;

/*@constant int _IOFBF; @*/
/*@constant int _IOLBF; @*/
/*@constant int _IONBF; @*/

/*@constant int BUFSIZ; @*/
/*@constant int EOF; @*/

/*@constant int FOPEN_MAX; @*/
/*@constant int FILENAME_MAX; @*/

/*@constant int L_tmpnam; @*/

/*@constant int SEEK_CUR; @*/
/*@constant int SEEK_END; @*/
/*@constant int SEEK_SET; @*/

/*@constant int TMP_MAX; @*/

/*@unchecked@*/ FILE *stderr;
/*@unchecked@*/ FILE *stdin;
/*@unchecked@*/ FILE *stdout;

extern int remove (char *filename) /*@modifies fileSystem@*/ ;
extern int rename (char *old, char *new) /*@modifies fileSystem@*/ ;

extern /*@null@*/ FILE *tmpfile (void) /*@modifies fileSystem@*/ ;
extern /*@observer@*/ char *
  tmpnam (/*@out@*/ /*@null@*/ /*@returned@*/ char *s) 
  /*@modifies *s, internalState@*/ ;

extern int fclose (FILE *stream) /*@modifies *stream, errno, fileSystem;@*/ ;
extern int fflush (FILE *stream) /*@modifies *stream, errno, fileSystem;@*/ ;

extern /*@null@*/ /*@dependent@*/ FILE *fopen (char *filename, char *mode) 
   /*@modifies fileSystem@*/ ;         

extern /*@null@*/ FILE *freopen (char *filename, char *mode, FILE *stream) 
  /*@modifies *stream, fileSystem, errno@*/ ;

extern void setbuf (FILE *stream, /*@null@*/ /*@exposed@*/ char *buf) 
   /*@modifies *stream, *buf@*/ ;

extern int setvbuf (FILE *stream, /*@null@*/ /*@exposed@*/ char *buf, 
		    int mode, size_t size)
   /*@modifies *stream, *buf@*/ ;

/*@printflike@*/ 
extern int /*@alt void@*/ fprintf (FILE *stream, char *format, ...)
   /*@modifies *stream@*/ ;

/*@scanflike@*/ 
extern int fscanf (FILE *stream, char *format, ...)
   /*@modifies *stream@*/ ;

/*@printflike@*/ 
extern int /*@alt void@*/ printf (char *format, ...) 
   /*@globals stdout@*/
   /*@modifies *stdout@*/ ;

/*@scanflike@*/
extern int scanf(char *format, ...)
   /*@globals stdin@*/
   /*@modifies *stdin@*/ ;

/*@printflike@*/ 
extern int /*@alt void@*/ sprintf (/*@out@*/ char *s, char *format, ...) 
   /*@modifies *s@*/ ;

/*@scanflike@*/ 
int sscanf (/*@out@*/ char *s, char *format, ...) /*@*/ ;
   /* modifies extra arguments */

extern int vfprintf (FILE *stream, char *format, va_list arg)
   /*@modifies *stream, arg, errno@*/ ;

extern int vprintf (char *format, va_list arg)
   /*@globals stdout@*/
   /*@modifies arg, *stdout@*/ ;

extern int vsprintf (/*@out@*/ char *s, char *format, va_list arg)
   /*@modifies *s, arg@*/ ;

extern int fgetc (FILE *stream) /*@modifies *stream, errno@*/ ;
extern /*@null@*/ char *
  fgets (/*@returned@*/ /*@out@*/ char *s, int n, FILE *stream)
  /*@modifies *s, *stream, errno@*/ ;

extern int fputc (int /*@alt char@*/ c, FILE *stream)
  /*@modifies *stream, errno@*/ ;

extern int fputs (char *s, FILE *stream)
  /*@modifies *stream@*/ ;

/* note use of sef --- stream may be evaluated more than once */
extern int getc (/*@sef@*/ FILE *stream)
  /*@modifies *stream@*/ ;

extern int getchar (void) /*@globals stdin@*/ /*@modifies *stdin@*/ ;

extern /*@null@*/ char *gets (/*@out@*/ char *s) 
   /*@globals stdin@*/ /*@modifies *s, *stdin, errno@*/ ;

extern int putc (int /*@alt char@*/ c, FILE *stream)
  /*@modifies *stream;@*/ ;

extern int putchar (int /*@alt char@*/ c)
   /*@globals stdout@*/ /*@modifies *stdout@*/ ; 

extern int puts (const char *s)
   /*@globals stdout@*/ /*@modifies *stdout@*/ ; 

extern int ungetc (int /*@alt char@*/ c, FILE *stream)
  /*@modifies *stream, errno@*/ ;

extern size_t 
  fread (/*@out@*/ void *ptr, size_t size, size_t nobj, FILE *stream)
  /*@modifies *ptr, *stream, errno@*/ ;

extern size_t fwrite (void *ptr, size_t size, size_t nobj, FILE *stream)
  /*@modifies *stream, errno@*/ ;

extern int fgetpos (FILE *stream, /*@out@*/ fpos_t *pos)
  /*@modifies *pos, errno@*/ ;

extern int fseek (FILE *stream, long int offset, int whence)
  /*@modifies *stream, errno@*/ ;

extern int fsetpos (FILE *stream, fpos_t *pos)
   /*@modifies *stream, errno@*/ ;

extern long int ftell(FILE *stream) /*@modifies errno@*/ ;

extern void rewind (FILE *stream) /*@modifies *stream@*/ ;

extern void clearerr (FILE *stream) /*@modifies *stream@*/ ;
extern int feof (FILE *stream) /*@modifies errno@*/ ;
extern int ferror (FILE *stream) /*@modifies errno@*/ ;

extern void perror (/*@null@*/ char *s) 
   /*@globals errno, stdout@*/ /*@modifies *stdout@*/ ; 

/*
** stdlib.h
*/

extern double atof (char *s) /*@*/ ;
extern int atoi (char *s) /*@*/ ;
extern long int atol (char *s) /*@*/ ;

extern double strtod (char *s, /*@null@*/ /*@out@*/ char **endp)
  /*@modifies *endp, errno@*/ ;

extern long strtol (char *s, /*@null@*/ /*@out@*/ char **endp, int base)
  /*@modifies *endp, errno@*/ ;

extern unsigned long 
  strtoul (char *s, /*@null@*/ /*@out@*/ char **endp, int base)
  /*@modifies *endp, errno@*/ ;

/*@constant int RAND_MAX; @*/
extern int rand (void) /*@modifies internalState@*/ ;
extern void srand (unsigned int seed) /*@modifies internalState@*/ ;

extern /*@null@*/ /*@only@*/ void *calloc (size_t nobj, size_t size) /*@*/ ;
extern /*@null@*/ /*@out@*/ /*@only@*/ void *malloc (size_t size) /*@*/ ;
extern /*@null@*/ /*@out@*/ /*@only@*/ void *
   realloc (/*@null@*/ /*@out@*/ /*@only@*/ /*@returned@*/ void *p, 
	    size_t size) /*@modifies *p@*/ ;

/* Not null in Unix version.  Too many Unix variants can't handle it! */
extern void free (/*@out@*/ /*@only@*/ void *p) /*@modifies *p@*/ ;

/*@constant int EXIT_FAILURE; @*/ 
/*@constant int EXIT_SUCCESS; @*/ 

extern /*@exits@*/ void abort (void) /*@*/ ;
extern /*@exits@*/ void exit (int status) /*@*/ ;
extern int atexit (void (*func)(void)) /*@modifies internalState@*/ ;

extern /*@observer@*/ /*@null@*/ char *getenv (char *name) /*@*/ ;

extern int system (/*@null@*/ char *s) /*@modifies fileSystem@*/ ;

extern /*@null@*/ void *
  bsearch (void *key, void *base, 
	   size_t n, size_t size, 
	   int (*compar)(void *, void *)) /*@*/ ;

extern void qsort (void *base, size_t n, size_t size, 
		   int (*compar)(void *, void *))
   /*@modifies *base, errno@*/ ;

extern int abs (int n) /*@*/ ;

typedef /*@concrete@*/ struct 
{
  int quot;
  int rem;
} div_t ;

extern div_t div (int num, int denom) /*@*/ ;

extern long int labs (long int n) /*@*/ ; 

typedef /*@concrete@*/ struct 
{
  long int quot;
  long int rem;
} ldiv_t ;

extern ldiv_t ldiv (long num, long denom) /*@*/ ;

/*@constant size_t MB_CUR_MAX; @*/

extern int mblen (char *s, size_t n) /*@*/ ;
extern int mbtowc (/*@null@*/ wchar_t *pwc, /*@null@*/ char *s, size_t n) 
   /*@modifies *pwc@*/ ;
extern int wctomb (/*@out@*/ /*@null@*/ char *s, wchar_t wchar) 
   /*@modifies *s@*/ ;
extern size_t mbstowcs (/*@out@*/ wchar_t *pwcs, char *s, size_t n)
  /*@modifies *pwcs@*/ ;
extern size_t wcstombs (/*@out@*/ char *s, wchar_t *pwcs, size_t n)
  /*@modifies *s@*/ ;

/*
** string.h
*/
     
extern void /*@alt void * @*/
  memcpy (/*@unique@*/ /*@returned@*/ /*@out@*/ void *s1, void *s2, size_t n) 
  /*@modifies *s1@*/ ;

extern void /*@alt void * @*/
  memmove (/*@returned@*/ /*@out@*/ void *s1, void *s2, size_t n)
  /*@modifies *s1@*/ ;

extern void /*@alt char * @*/
  strcpy (/*@unique@*/ /*@out@*/ /*@returned@*/ char *s1, char *s2) 
  /*@modifies *s1@*/ ;

extern void /*@alt char * @*/
  strncpy (/*@unique@*/ /*@out@*/ /*@returned@*/ char *s1, char *s2, size_t n) 
  /*@modifies *s1@*/ ;

extern void /*@alt char * @*/
  strcat (/*@unique@*/ /*@returned@*/ /*@out@*/ char *s1, char *s2) 
  /*@modifies *s1@*/ ;

extern void /*@alt char * @*/
  strncat (/*@unique@*/ /*@returned@*/ /*@out@*/ char *s1, char *s2, int n)
  /*@modifies *s1@*/ ;

extern int memcmp (void *s1, void *s2, size_t n) /*@*/ ;
extern int strcmp (char *s1, char *s2) /*@*/ ;
extern int strcoll (char *s1, char *s2) /*@*/ ;
extern int strncmp (char *s1, char *s2, size_t n) /*@*/ ;
extern size_t strxfrm (/*@out@*/ /*@null@*/ char *s1, char *s2, size_t n) 
  /*@modifies *s1@*/ ;  /* s1 may be null only if n == 0 */ 

extern /*@null@*/ void *memchr (void *s, int c, size_t n) /*@*/ ;
extern /*@exposed@*/ /*@null@*/ char *
  strchr (/*@returned@*/ char *s, int /*@alt char@*/ c) /*@*/ ;
extern size_t strcspn (char *s1, char *s2) /*@*/ ;
extern /*@null@*/ /*@exposed@*/ char *
  strpbrk (/*@returned@*/ char *s, char *t) /*@*/ ;
extern /*@null@*/ /*@exposed@*/ char *
  strrchr (/*@returned@*/ char *s, int /*@alt char@*/ c) /*@*/ ;
extern size_t strspn (char *s, char *t) /*@*/ ;
extern /*@null@*/ /*@exposed@*/  char *
  strstr (/*@returned@*/ /*@unique@*/ char *s, char *t) /*@*/ ; 
extern /*@null@*/ /*@exposed@*/ char *
  strtok (/*@returned@*/ /*@null@*/ char *s, char *t)
  /*@modifies *s, internalState, errno@*/ ;

extern void *memset (/*@out@*/ /*@returned@*/ void *s, int c, size_t n)
   /*@modifies *s@*/ ;

extern /*@observer@*/ char *strerror (int errnum) /*@*/ ;

extern size_t strlen (char *s) /*@*/ ; 

/*
** time.h
*/

/*@constant int CLOCKS_PER_SEC;@*/

/*
** Actual types should be any arithmatic type.
*/

typedef /*@concrete@*/ unsigned long int clock_t;
typedef /*@concrete@*/ unsigned long int time_t;

struct tm
  {
    int tm_sec;
    int tm_min;
    int tm_hour;
    int tm_mday;
    int tm_mon;
    int tm_year;
    int tm_wday;
    int tm_yday;
    int tm_isdst;
  } ;

extern clock_t clock (void) /*@modifies internalState@*/ ;
extern double difftime (time_t time1, time_t time0) /*@*/ ;
extern time_t mktime (struct tm *timeptr) /*@*/ ;

extern time_t time (/*@null@*/ /*@out@*/ time_t *tp)
  /*@modifies *tp@*/ ;

extern /*@observer@*/ char *asctime (struct tm *timeptr) 
  /*@modifies errno*/ ;

extern /*@observer@*/ char *ctime (time_t *tp) /*@*/ ;

extern /*@null@*/ /*@only@*/ struct tm *gmtime (time_t *tp) /*@*/ ;

extern /*@null@*/ /*@only@*/ struct tm *localtime (time_t *tp) 
  /*@modifies errno@*/ ;

extern size_t strftime (/*@out@*/ char *s, size_t smax,
			char *fmt, struct tm *timeptr)
  /*@modifies *s@*/ ;

/*
** Extra Unix functions
*/

extern void bcopy (char *b1, /*@out@*/ char *b2, int length) 
   /*@modifies *b2@*/ ;  /* Yes, the second parameter is the out param! */

extern int /*@alt bool@*/ bcmp (char *b1, char *b2, int length) /*@*/ ;
   /* Return value is NOT like strcmp! */

extern void bzero (/*@out@*/ char *b1, int length) /*@modifies *b1@*/ ;
extern int ffs (int i) /*@*/ ;

extern int close (int fd) /*@modifies errno@*/ ;
extern int unlink (char *path) /*@modifies fileSystem, errno@*/ ;
extern int link (char *name1, char *name2) /*@modifies fileSystem@*/ ;
extern int symlink (char *name1, char *name2) /*@modifies fileSystem@*/ ;

extern /*@unchecked@*/ char **environ;

extern /*@mayexit@*/ int 
  execl (char *path, char *arg, ...) /*@modifies fileSystem, errno@*/ ;
extern /*@mayexit@*/ int 
  execv (char *path, char *argv[]) /*@modifies fileSystem, errno@*/ ;
extern /*@mayexit@*/ int 
  execle (char *path, char *arg, ...) /*@modifies fileSystem, errno@*/ ;
extern /*@mayexit@*/ int 
  execve (char *path, char *argv[], char *envp[]) 
  /*@modifies fileSystem, errno@*/ ;
extern /*@mayexit@*/ int 
  execlp (char *file, char *arg, ...) /*@modifies fileSystem, errno@*/ ;
extern /*@mayexit@*/ int 
  execvp (char *file, char *argv[]) /*@modifies fileSystem, errno@*/ ;

extern int 
  setvbuf_unlocked (FILE *stream, /*@null@*/ /*@exposed@*/ char *buf, 
		    int mode, size_t size)
  /*@modifies internalState@*/ ;

extern void 
  setbuffer (FILE *stream, /*@null@*/ /*@exposed@*/ char *buf, int size)
  /*@modifies internalState@*/ ;

extern void setlinebuf (FILE *stream) /*@modifies internalState@*/ ;

extern int strerror_r (int errnum, /*@out@*/ char *strerrbuf, int buflen)
  /*@modifies strerrbuf@*/ ;

extern size_t 
  fread_unlocked (/*@out@*/ void *ptr, size_t size, size_t nitems, 
		  FILE *stream) 
  /*@modifies *stream, *ptr;@*/ ;

extern size_t 
  fwrite_unlocked (void *pointer, size_t size, size_t num_items, FILE *stream)
  /*@modifies *stream;@*/ ;

extern void funlockfile (FILE *file) /*@modifies *file;@*/ ;
extern void flockfile (FILE *file) /*@modifies *file@*/ ;

extern void /*@alt void * @*/ 
  memccpy (/*@returned@*/ /*@out@*/ void *s1, 
	   /*@unique@*/ void *s2, int c, size_t n) 
  /*@modifies *s1@*/ ;

extern int strcasecmp (char *s1, char *s2) /*@*/ ;
extern int strncasecmp (char *s1, char *s2, int n) /*@*/ ;

extern char *tempnam (char *dir, char *pfx) /*@modifies internalState@*/ ;

extern /*@null@*/ /*@dependent@*/ char *
  index (/*@returned@*/ char *s, char c) /*@*/ ;

extern /*@null@*/ /*@dependent@*/ char *
  rindex (/*@returned@*/ char *s, char c) /*@*/ ;

extern int fileno (FILE *stream) /*@modifies errno@*/ ;
extern /*@dependent@*/ /*@null@*/ FILE *fdopen (int filedes, char *ttype) 
   /*@modifies fileSystem, errno@*/ ;
extern /*@dependent@*/ /*@null@*/ FILE *popen (char *command, char *ttype)
   /*@modifies fileSystem, errno@*/ ;
extern int pclose (FILE *stream) /*@modifies *stream, errno@*/ ;

extern double cbrt (double x) /*@modifies errno@*/ ;
extern double rint (double x) /*@*/ ;
extern double trunc (double x) /*@*/ ; 

/*
** Extra errno's
*/

/*@constant int EPERM@*/
/*@constant int ENOENT@*/
/*@constant int ESRCH@*/
/*@constant int EINTR@*/
/*@constant int EIO@*/
/*@constant int ENXIO@*/
/*@constant int E2BIG@*/
/*@constant int ENOEXEC@*/
/*@constant int EBADF@*/
/*@constant int ECHILD@*/
/*@constant int EAGAIN@*/
/*@constant int ENOMEM@*/
/*@constant int EACCES@*/
/*@constant int EFAULT@*/
/*@constant int ENOTBLK@*/
/*@constant int EBUSY@*/
/*@constant int EEXIST@*/
/*@constant int EXDEV@*/
/*@constant int ENODEV@*/
/*@constant int ENOTDIR@*/
/*@constant int EISDIR@*/
/*@constant int EINVAL@*/
/*@constant int ENFILE@*/
/*@constant int EMFILE@*/
/*@constant int ENOTTY@*/
/*@constant int ETXTBSY@*/
/*@constant int EFBIG@*/
/*@constant int ENOSPC@*/
/*@constant int ESPIPE@*/
/*@constant int EROFS@*/
/*@constant int EMLINK@*/
/*@constant int EPIPE@*/
/*@constant int EWOULDBLOCK@*/
/*@constant int EINPROGRESS@*/
/*@constant int EALREADY@*/
/*@constant int ENOTSOCK@*/
/*@constant int EDESTADDRREQ@*/
/*@constant int EMSGSIZE@*/
/*@constant int EPROTOTYPE@*/
/*@constant int ENOPROTOOPT@*/
/*@constant int EPROTONOSUPPORT@*/
/*@constant int ESOCKTNOSUPPORT@*/
/*@constant int EOPNOTSUPP@*/
/*@constant int EPFNOSUPPORT@*/
/*@constant int EAFNOSUPPORT@*/
/*@constant int EADDRINUSE@*/
/*@constant int EADDRNOTAVAIL@*/
/*@constant int ENETDOWN@*/
/*@constant int ENETUNREACH@*/
/*@constant int ENETRESET@*/
/*@constant int ECONNABORTED@*/
/*@constant int ECONNRESET@*/
/*@constant int ENOBUFS@*/
/*@constant int EISCONN@*/
/*@constant int ENOTCONN@*/
/*@constant int ESHUTDOWN@*/
/*@constant int ETOOMANYREFS@*/
/*@constant int ETIMEDOUT@*/
/*@constant int ECONNREFUSED@*/
/*@constant int ENAMETOOLONG@*/
/*@constant int EHOSTDOWN@*/
/*@constant int EHOSTUNREACH@*/
/*@constant int ENOTEMPTY@*/
/*@constant int EPROCLIM@*/
/*@constant int EUSERS@*/
/*@constant int EDQUOT@*/
/*@constant int ESTALE@*/
/*@constant int EREMOTE@*/
/*@constant int ENOMSG@*/
/*@constant int EIDRM@*/
/*@constant int EALIGN@*/
/*@constant int EDEADLK@*/
/*@constant int ENOLCK@*/
/*@constant int ENOSYS@*/
/*@constant int EACTIVE@*/
/*@constant int ENOACTIVE@*/
/*@constant int ENORESOURCES@*/
/*@constant int ENOSYSTEM@*/
/*@constant int ENODUST@*/
/*@constant int EDUPNOCONN@*/
/*@constant int EDUPNODISCONN@*/
/*@constant int EDUPNOTCNTD@*/
/*@constant int EDUPNOTIDLE@*/
/*@constant int EDUPNOTWAIT@*/
/*@constant int EDUPNOTRUN@*/
/*@constant int EDUPBADOPCODE@*/
/*@constant int EDUPINTRANSIT@*/
/*@constant int EDUPTOOMANYCPUS@*/
/*@constant int ELOOP@*/

/*
** Other constants
*/

/*@constant int ARG_MAX@*/
/*@constant int CHILD_MAX@*/
/*@constant int LOCK_MAX@*/
/*@constant int LINK_MAX@*/
/*@constant int FCHR_MAX@*/
/*@constant int USI_MAX@*/
/*@constant int WORD_BIT@*/
/*@constant int LONG_BIT@*/
/*@constant int NAME_MAX@*/
/*@constant int NGROUPS_MAX@*/
/*@constant int MAX_INPUT@*/
/*@constant int MAX_CANON@*/
/*@constant int MAX_CHAR@*/
/*@constant int OPEN_MAX@*/
/*@constant int PASS_MAX@*/
/*@constant int PATH_MAX@*/
/*@constant int PID_MAX@*/
/*@constant int SYSPID_MAX@*/
/*@constant int PIPE_BUF@*/
/*@constant int PIPE_MAX@*/
/*@constant int PROC_MAX@*/
/*@constant int STD_BLK@*/
/*@constant int SYS_NMLN@*/
/*@constant int SYS_OPEN@*/
/*@constant int NZERO@*/
/*@constant int UID_MAX@*/
/*@constant int MB_LEN_MAX@*/
/*@constant int NL_ARGMAX@*/
/*@constant int NL_MSGMAX@*/
/*@constant int NL_NMAX@*/
/*@constant int NL_SETMAX@*/
/*@constant int NL_TEXTMAX@*/
/*@constant int NL_LBLMAX@*/
/*@constant int NL_LANGMAX @*/

/* Math constants: */

/*@constant double M_E@*/
/*@constant double M_LOG2E@*/
/*@constant double M_LOG10E@*/
/*@constant double M_LN2@*/
/*@constant double M_LN10@*/
/*@constant double M_PI@*/
/*@constant double M_PI_2@*/
/*@constant double M_PI_4@*/
/*@constant double M_1_PI@*/
/*@constant double M_2_PI@*/
/*@constant double M_2_SQRTPI@*/
/*@constant double M_SQRT2@*/
/*@constant double M_SQRT1_2@*/ 

/*@constant double MAXFLOAT@*/
/*@constant double HUGE@*/
 
/*@constant int DOMAIN@*/
/*@constant int SING@*/
/*@constant int OVERFLOW@*/
/*@constant int UNDERFLOW@*/
/*@constant int TLOSS@*/
/*@constant int PLOSS@*/

/*
** setjmp 
*/

typedef /*@abstract@*/ /*@mutable@*/ void *sigjmp_buf;

extern int sigsetjmp (/*@out@*/ sigjmp_buf env, int savemask)
  /*@modifies env@*/ ;
extern /*@mayexit@*/ void siglongjmp (sigjmp_buf env, int val) /*@*/ ;

/*
** time
*/

extern /*@unchecked@*/ int daylight;
extern /*@unchecked@*/ long timezone;
extern /*@unchecked@*/ char *tzname[];

extern void tzset(void) /*@modifies daylight, timezone, tzname@*/ ;

/*
** types
**
** added 20 March 1996
**
** These definitions do not exist on all systems!
*/

typedef	unsigned char uchar_t;
typedef	unsigned short ushort_t;
typedef	unsigned int uint_t;
typedef unsigned long ulong_t;
typedef	volatile unsigned char vuchar_t;
typedef	volatile unsigned short	vushort_t;
typedef	volatile unsigned int vuint_t;
typedef volatile unsigned long vulong_t;
typedef long label_t;
typedef int level_t;
typedef	int daddr_t;
typedef	char *caddr_t;	
typedef long *qaddr_t; 
typedef char *addr_t;
typedef long physadr_t;
typedef	uint_t ino_t;
typedef short cnt_t;
typedef int dev_t;
typedef	int chan_t;	
typedef ulong_t  off_t;	
typedef unsigned long rlim_t;
typedef	int paddr_t;
typedef	ushort_t nlink_t;
typedef int key_t;
typedef	uint_t mode_t;
typedef uint_t uid_t;
typedef uint_t gid_t;	
typedef	void *mid_t;
typedef	int pid_t;
typedef char slab_t[12];	
typedef ulong_t	shmatt_t;	
typedef ulong_t	msgqnum_t;	
typedef ulong_t	msglen_t;
typedef unsigned int wint_t;   
typedef unsigned long sigset_t;
typedef long timer_t;
typedef	uchar_t uchar;
typedef	ushort_t ushort;
typedef	uint_t uint;
typedef ulong_t	ulong;
typedef	uchar_t	u_char;
typedef	ushort_t u_short;
typedef	uint_t u_int;
typedef	ulong_t	u_long;
typedef	vuchar_t vu_char;
typedef	vushort_t vu_short;
typedef	vuint_t	vu_int;
typedef	vulong_t vu_long;
typedef	long swblk_t;
typedef u_long fixpt_t;

/*
** stat (added 20 March 1996)
*/

struct stat 
{
  dev_t   st_dev;   
  ino_t   st_ino;   
  short   st_mode;  
  short   st_nlink; 
  short   st_uid;   
  short   st_gid;   
  dev_t   st_rdev;  
  off_t   st_size;  
  time_t  st_atime; 
  time_t  st_mtime; 
  time_t  st_ctime; 
  long    st_blksize; 
  long    st_blocks;  
  /* on some platforms: u_long  st_gennum or st_gens; */
} ;

extern int stat (char *path, /*@out@*/ struct stat *buffer) /*@modifies buffer@*/ ;
extern int lstat (char *path, /*@out@*/ struct stat *buffer) /*@modifies buffer@*/ ;
extern int fstat (int filedes, /*@out@*/ struct stat *buffer) /*@modifies buffer@*/ ;

/*
** libc
*/

/*@observer@*/ char *ttyname (int fd) /*@*/ ;
bool /*@alt int@*/ isatty (int fd) /*@*/ ;
int ttyname_r (int fg, /*@out@*/ char *buffer, int len) /*@modifies buffer@*/ ;

int ioctl (int d, int request, /*@out@*/ void *arg) 
   /*@modifies *arg, errno@*/ ;  /* depends on request! */

off_t lseek (int file, off_t offset, int whence) ;

ssize_t read (int filedes, /*@out@*/ void *buffer, size_t nbytes) ;

int dup (int filedes) /*@modifies fileSystem@*/;
int dup2 (int old, int new) /*@modifies fileSystem@*/;
