/*
 * display.h : Definitions of device-independent interface functions
 *
 * This header file is used for both the X and Curses display routines.
 * Not all functions are needed for both types of display.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#ifndef DISPLAY_H
#define DISPLAY_H

#ifdef __STDC__
/* Text output routines */
extern void setTitleText(char *str), setStatusText(char *str);
extern void setSearchText(char *str), setHostText(char *str);
extern void setLocationText(char *str), setFileText(char *str);
extern void setSizeText(char *str), setModesText(char *str);
extern void setDateText(char *str);

/* Button sensitivity routines */
extern void setQuerySensitive(int state), setAbortSensitive(int state);
extern void setUpSensitive(int state), setDownSensitive(int state);

/* Browser routines */
extern void initBrowser(void),clearBrowser(void),redrawBrowser(void);
extern void clearBrowserPane(int pane), redrawBrowserPane(int pane);
extern void unhighlightBrowserPane(int pane);
extern void clearBrowserItem(int pane, int item);
extern void redrawBrowserItem(int pane, int item);
extern void unhighlightBrowserItem(int pane, int item);
extern void highlightBrowserItem(int pane, int item);
extern void setBrowserItem(int pane, int item, char *str);
/* Browser action routines */
extern void nextBrowserPane(void),prevBrowserPane(void);
extern void nextBrowserItem(void),prevBrowserItem(void);
extern void toggleCurrentBrowserItem(void),selectCurrentBrowserItem(void);

/* Misc. display routines */
extern void beep(void);

#else /*!__STDC__*/

/* Text output routines */
extern void setTitleText(), setStatusText();
extern void setSearchText(), setHostText(), setLocationText(), setFileText();
extern void setSizeText(), setModesText(), setDateText();

/* Button sensitivity routines */
extern void setQuerySensitive(), setAbortSensitive();
extern void setUpSensitive(), setDownSensitive();

/* Browser routines */
extern void initBrowser(),clearBrowser(),redrawBrowser();
extern void clearBrowserPane(), redrawBrowserPane(), unhighlightBrowserPane();
extern void clearBrowserItem(), redrawBrowserItem(), unhighlightBrowserItem();
extern void highlightBrowserItem(), setBrowserItem();

/* Browser action routines */
extern void nextBrowserPane(),prevBrowserPane();
extern void nextBrowserItem(),prevBrowserItem();
extern void toggleCurrentBrowserItem(),selectCurrentBrowserItem();

/* Misc. display routines */
extern void beep();

#endif /*!__STDC__*/
#endif /* DISPLAY_H */
