#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

int tree_selected_node(n)
treenode n;
{
	return(ndta(n)->selected);
}

tree_select_node(n)
treenode n;
{
	ndta(n)->selected=1;
	canvas_add_node(n);
}

tree_unselect_node(n)
treenode n;
{
	ndta(n)->selected=0;
	ndta(n)->full=0;
	canvas_add_node(n);
}

int tree_selected_branch(b)
treebranch b;
{
	return(bdta(b)->selected);
}

tree_select_branch_point(b, p)
treebranch b;
double p;
{
	bdta(b)->selected=1;
	bdta(b)->percentage=p;
	canvas_add_branch(b);
}

tree_select_branch(b)
treebranch b;
{
	bdta(b)->selected=1;
	bdta(b)->percentage=-1.0;
	canvas_add_branch(b);
}

tree_unselect_branch(b)
treebranch b;
{
	bdta(b)->selected=0;
	canvas_add_branch(b);
}

int tree_selected_subtree(s)
treenode s;
{
	return(ndta(s)->selected & ndta(s)->full);
}

tree_select_subtree(s)
treenode s;
{
	treebranch b;

	ndta(s)->selected=1;
	ndta(s)->full=1;
	canvas_add_node(s);
	startlist(s->branches);
	while((b=listnext(s->branches))!=NULL)
	{
		if(b->up==s)
		{
			/*tree_select_branch(b);*/
			tree_select_subtree(b->down);
		}
	}
}

tree_unselect_subtree(s)
treenode s;
{
	treebranch b;

	ndta(s)->selected=0;
	ndta(s)->full=0;
	canvas_add_node(s);
	startlist(s->branches);
	while((b=listnext(s->branches))!=NULL)
	{
		if(b->up==s)
		{
			/*tree_unselect_branch(b);*/
			tree_unselect_subtree(b->down);
		}
	}
}
