#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"

typedef struct {
	ltgenericd g;
	Panel_item t;	/* xview panel item */
	int (*do_events)();
	} ltpmsgd, *ltpmsg;

int tpmsg_right_side(t)
ltpmsg t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	return(xv_get(t->t, XV_X)+xv_get(t->t, XV_WIDTH));
}

int tpmsg_bottom_side(t)
ltpmsg t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	return(xv_get(t->t, XV_Y)+xv_get(t->t, XV_HEIGHT));
}

tpmsg tpmsg_new(parent, x,y,w,h,right,below, name)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
{
	ltpmsg tmp;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)!=lt_panel)
		return(NULL);
	
	if(name==NULL)
		name="Message Item";
	
	tmp=(ltpmsg)titem_new(parent, lt_pmsg, sizeof(ltpmsgd));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=(Panel_item)xv_create(tpanel_xview(parent), PANEL_MESSAGE,
		PANEL_LABEL_STRING, name,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		XV_WIDTH, w,
		XV_HEIGHT, h,
		NULL);
	
	if(right!=NULL)
		x=tp_right_side(right);
	if(below!=NULL)
		y=tp_bottom_side(below);

	xv_set(tmp->t,
		XV_X, x,
		XV_Y, y,
		PANEL_CLIENT_DATA, tmp,
		NULL);

	tmp->do_events=NULL;

	return(tmp);
}

int tpmsg_free(t)
ltpmsg t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	xv_destroy_safe(t->t);
	return(titem_free(t));
}

int tpmsg_enable(t)
ltpmsg t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, FALSE, NULL);
	return(1);
}

int tpmsg_disable(t)
ltpmsg t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, TRUE, NULL);
	return(1);
}

int tpmsg_change_message(t, s)
ltpmsg t;
char *s;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	xv_set(t->t, PANEL_LABEL_STRING, s, NULL);
	return(1);
}

int tpmsg_set_bold(t)
ltpmsg t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	xv_set(t->t, PANEL_LABEL_BOLD, TRUE, NULL);
	return(1);
}

int tpmsg_set_nobold(t)
ltpmsg t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pmsg)
		return(0);
	
	xv_set(t->t, PANEL_LABEL_BOLD, FALSE, NULL);
	return(1);
}
