#include "cscore.h"                                  /* CSCORE_TEST.C */

cscore()                  /* callable from Csound or standalone cscore */
{
	EVENT *e, **p;
	EVLIST *a, *b, *c;
        int  n;

	e = createv(5); 	/* alloc p0-5 and init pcnt */
	e->op = 'f';
	e->p[1] = 1;            /* construct an event */
	e->p[2] = 0;
	e->p[3] = 256;
	e->p[4] = 10;
	e->p[5] = 1;
	putev(e);		/*   and write it out */
	relev(e);
	putstr("s");
	a = lget();		/* read sect from score */
	lput(a);		/* write it out as is */
	putstr("s");
	lsort(a);
	lput(a);		/* write out a sorted version */
	putstr("s");
	c = lseptwf(a);		/* separate t,w & f's from notes */
	b = lcopyev(a); 	/* duplicate the notes */
	n = b->nevents;
	p = &b->e[1];		/* point at first one */
	while (n--)
	   (*p++)->p[2] += 2.0; /* delay each by two beats */
	c = lcat(c,a);
	c = lcat(c,b);		/* combine and sort all three sets */
	lsort(c);
	lput(c);		/*	and write out */
	lrelev(c);		/* release all of these notes */
	putstr("s");
	e = defev("f 2 0 256 10 5 6 ");
	a = lcreat(0);
        a = lappev(a,e);
	lput(a);
	lrelev(a);
	putstr("e");
}


