/******************************************/
/*  Bowed String model ala Smith          */
/* after McIntyre, Schumacher, Woodhouse  */
/*  by Perry Cook, 1995-96                */
/*  Recoded for Csound by John ffitch     */
/*  November 1997                         */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/******************************************/

#if !defined(__Bowed_h)
#define __Bowed_h

#include "physutil.h"

/***********************************************/ 
/*  Simple Bow Table Object, after Smith       */
/*    by Perry R. Cook, 1995-96                */
/***********************************************/

typedef struct BowTabl {
    float	offSet;
    float	slope;
    float	lastOutput;
} BowTabl;

float BowTabl_lookup(BowTabl*, float sample);

typedef struct BOWED {
    OPDS	h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*bowPress, *betaRatio, *vibFreq;
    float	*vibAmt, *ifn, *lowestFreq; 

    FUNC	*vibr;
    float	v_rate;         /* Parameters for vibrato */
    float	v_time;
    float	v_phaseOffset;
    float	v_lastOutput;
    DLineL	neckDelay;
    DLineL	bridgeDelay;
    BowTabl	bowTabl;
    OnePole	reflFilt;
    BiQuad	bodyFilt;
    ADSR	adsr;
    float	maxVelocity;
    float	baseDelay;
    float	vibrGain;
    float	lastpress;
    float	lastfreq;
    float	lastbeta;
    float	lastamp;
    int		kloop;
} BOWED;


#endif
