							/* biquad.h */


				/* Structure for biquadratic filter */
typedef struct {
    OPDS h;
    float   *out, *in, *b0, *b1, *b2, *a0, *a1, *a2, *reinit;
    float   xnm1, xnm2, ynm1, ynm2;
} BIQUAD;

				/* Structure for moogvcf filter */
typedef struct {
    OPDS h;
    float   *out, *in, *fco, *res, *max;
    float   xnm1, y1nm1, y2nm1, y3nm1, y1n, y2n, y3n, y4n;
    short   fcocod, rezcod;
} MOOGVCF;

				/* Structure for rezzy filter */
typedef struct {
    OPDS h;
    float *out, *in, *fco, *rez, *mode;
    float   xnm1, xnm2, ynm1, ynm2;
    short   fcocod, rezcod;
} REZZY;

                                /* Structure for distortion */
typedef struct {
    OPDS    h;
    float   *out, *in, *pregain, *postgain, *shape1, *shape2;
} DISTORT;

                                /* Structure for vco, analog modeling opcode */
typedef struct {
    OPDS    h;
    float   *ar, *xamp, *xcps, *wave, *pw, *sine, *maxd;
    float   ynm1, ynm2, leaky;
    short   ampcod, cpscod;
    int     iphs;
    long    lphs;
    FUNC    *ftp;
 /* Insert VDelay here */
    AUXCH   aux;
 /* AUXCH   auxd; */
    long    left;
 /* End VDelay insert  */
} VCO;

typedef struct {
    OPDS    h;
    float   *outx, *outy, *outz, *mass1, *mass2, *sep, *xval, *yval, *zval;
    float   *vxval, *vyval, *vzval, *delta, *fric;
    float   s1z, s2z, friction;
    float   x, y, z, vx, vy, vz, ax, ay, az, hstep;
} PLANET;

typedef struct {
    OPDS h;
    float *out, *in, *fc, *v, *q, *mode;
    float xnm1, xnm2, ynm1, ynm2, imode;
} PAREQ;

typedef struct {
    OPDS    h;
    float   *out, *in, *mode, *maxdel, *del1, *gain1, *del2, *gain2;
    float   *del3, *gain3, *istor;
    float   *curp, out1, out2, out3;
    float   *beg1p, *beg2p, *beg3p, *end1p, *end2p, *end3p;
    float   *del1p, *del2p, *del3p;
    long    npts;
    AUXCH   auxch;
} NESTEDAP;

typedef struct {
    OPDS    h;
    float   *outx, *outy, *outz, *s, *r, *b, *hstep, *inx, *iny, *inz, *skip;
    float   valx, valy, valz;
} LORENZ;

