/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifndef lint
static char z80_ops_c[] = "$Id: z80_ops.c,v 4.13 1999/01/14 16:59:54 erik Rel $";
#endif
#define ADD_HL(reg) \
{																		\
uns32 temp32 = HL + (reg);											\
uns8 idx = ((HL & 0x0800) >> 9) |									\
(((reg) & 0x0800) >> 10) |								\
((temp32 & 0x0800) >> 11);								\
HL = (uns16)temp32;													\
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) |								\
(H & (B5_FLAG | B3_FLAG)) |										\
halfCarryTbl[idx] |												\
(temp32 & 0x10000 ? C_FLAG : 0);								\
}
#define JR() \
{																		\
PC += (sgn8)Z80_RDMEM(PC) + 1;										\
}
#define JP() \
{																		\
uns16 t16 = PC;														\
LPC = Z80_RDMEM(t16++);												\
HPC = Z80_RDMEM(t16);												\
}
#define CALL() \
{																		\
uns8 t8l = Z80_RDMEM(PC++);											\
uns8 t8h = Z80_RDMEM(PC++);											\
PUSH(HPC, LPC);														\
LPC = t8l;															\
HPC = t8h;															\
}
#define RST(addr) \
{																		\
PUSH(HPC, LPC);														\
PC = (addr);														\
}
case 0x00:
TSTATES += 4;
break;
case 0x01:
TSTATES += 10;
C = Z80_RDMEM(PC++);
B = Z80_RDMEM(PC++);
break;
case 0x02:
TSTATES += 7;
Z80_WRMEM(BC, A);
break;
case 0x03:
TSTATES += 6;
BC++;
break;
case 0x04:
TSTATES += 4;
INC(B);
break;
case 0x05:
TSTATES += 4;
DEC(B);
break;
case 0x06:
TSTATES += 7;
B = Z80_RDMEM(PC++);
break;
case 0x07:
TSTATES += 4;
A = (A << 1) | (A >> 7);
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG | C_FLAG));
break;
case 0x08:
TSTATES += 4;
{
uns16 t16 = AF; AF = AF1; AF1 = t16;
}
break;
case 0x09:
TSTATES += 11;
ADD_HL(BC);
break;
case 0x0A:
TSTATES += 7;
A = Z80_RDMEM(BC);
break;
case 0x0B:
TSTATES += 6;
BC--;
break;
case 0x0C:
TSTATES += 4;
INC(C);
break;
case 0x0D:
TSTATES += 4;
DEC(C);
break;
case 0x0E:
TSTATES += 7;
C = Z80_RDMEM(PC++);
break;
case 0x0F:
TSTATES += 4;
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & C_FLAG);
A = (A >> 1) | (A << 7);
F |= A & (B5_FLAG | B3_FLAG);
break;
case 0x10:
if (--B)
{
TSTATES += 13;
JR();
}
else
{
TSTATES += 8;
PC++;
}
break;
case 0x11:
TSTATES += 10;
E = Z80_RDMEM(PC++);
D = Z80_RDMEM(PC++);
break;
case 0x12:
TSTATES += 7;
Z80_WRMEM(DE, A);
break;
case 0x13:
TSTATES += 6;
DE++;
break;
case 0x14:
TSTATES += 4;
INC(D);
break;
case 0x15:
TSTATES += 4;
DEC(D);
break;
case 0x16:
TSTATES += 7;
D = Z80_RDMEM(PC++);
break;
case 0x17:
TSTATES += 4;
{
uns8 t8 = A >> 7;
A = (A << 1) | (F & C_FLAG);
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG)) | t8;
}
break;
case 0x18:
TSTATES += 12;
JR();
break;
case 0x19:
TSTATES += 11;
ADD_HL(DE);
break;
case 0x1A:
TSTATES += 7;
A = Z80_RDMEM(DE);
break;
case 0x1B:
TSTATES += 6;
DE--;
break;
case 0x1C:
TSTATES += 4;
INC(E);
break;
case 0x1D:
TSTATES += 4;
DEC(E);
break;
case 0x1E:
TSTATES += 7;
E = Z80_RDMEM(PC++);
break;
case 0x1F:
TSTATES += 4;
{
uns8 t8 = A & C_FLAG;
A = (A >> 1) | (F << 7);
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) | (A & (B5_FLAG | B3_FLAG)) | t8;
}
break;
case 0x20:
if (!(F & Z_FLAG))
{
TSTATES += 12;
JR();
}
else
{
TSTATES += 7;
PC++;
}
break;
case 0x21:
TSTATES += 10;
L = Z80_RDMEM(PC++);
H = Z80_RDMEM(PC++);
break;
case 0x22:
TSTATES += 16;
{
uns16 t16 = Z80_RDMEM(PC++);
t16 |= Z80_RDMEM(PC++) << 8;
Z80_WRMEM(t16++, L);
Z80_WRMEM(t16, H);
}
break;
case 0x23:
TSTATES += 6;
HL++;
break;
case 0x24:
TSTATES += 4;
INC(H);
break;
case 0x25:
TSTATES += 4;
DEC(H);
break;
case 0x26:
TSTATES += 7;
H = Z80_RDMEM(PC++);
break;
case 0x27:
TSTATES += 4;
{
uns8 add = 0, carry = F & C_FLAG;
if ((F & H_FLAG) || ((A & 0x0f) > 9))
{
add |= 0x06;
}
if (carry || (A > 0x9f))
{
add |= 0x60;
}
if (A > 0x99)
{
carry = 1;
}
if (F & N_FLAG)
{
SUB(add);
}
else
{
if ((A > 0x8f) && ((A & 0x0f) > 9))
{
add |= 0x60;
}
ADD(add);
}
F = (F & ~ (P_FLAG | C_FLAG)) | PARITY(A) | carry;
}
break;
case 0x28:
if (F & Z_FLAG)
{
TSTATES += 12;
JR();
}
else
{
TSTATES += 7;
PC++;
}
break;
case 0x29:
TSTATES += 11;
ADD_HL(HL);
break;
case 0x2A:
TSTATES += 16;
{
uns16 t16 = Z80_RDMEM(PC++);
t16 |= Z80_RDMEM(PC++) << 8;
L = Z80_RDMEM(t16++);
H = Z80_RDMEM(t16);
}
break;
case 0x2B:
TSTATES += 6;
HL--;
break;
case 0x2C:
TSTATES += 4;
INC(L);
break;
case 0x2D:
TSTATES += 4;
DEC(L);
break;
case 0x2E:
TSTATES += 7;
L = Z80_RDMEM(PC++);
break;
case 0x2F:
TSTATES += 4;
A ^= 0xff;
F = (F & (S_FLAG | Z_FLAG | V_FLAG | C_FLAG)) | (A & (B5_FLAG | B3_FLAG)) |
(H_FLAG | N_FLAG);
break;
case 0x30:
if(!(F & C_FLAG))
{
TSTATES += 12;
JR();
}
else
{
TSTATES += 7;
PC++;
}
break;
case 0x31:
TSTATES += 10;
LSP = Z80_RDMEM(PC++);
HSP = Z80_RDMEM(PC++);
break;
case 0x32:
TSTATES += 13;
{
uns16 t16 = Z80_RDMEM(PC++);
t16 |= Z80_RDMEM(PC++) << 8;
Z80_WRMEM(t16, A);
}
break;
case 0x33:
TSTATES += 6;
SP++;
break;
case 0x34:
TSTATES += 11;
{
uns8 t8 = Z80_RDMEM(HL);
INC(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x35:
TSTATES += 11;
{
uns8 t8 = Z80_RDMEM(HL);
DEC(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x36:
TSTATES += 10;
Z80_WRMEM(HL, Z80_RDMEM(PC++));
break;
case 0x37:
TSTATES += 4;
SCF();
break;
case 0x38:
if (F & C_FLAG)
{
TSTATES += 12;
JR();
}
else
{
TSTATES += 7;
PC++;
}
break;
case 0x39:
TSTATES += 11;
ADD_HL(SP);
break;
case 0x3A:
TSTATES += 13;
{
uns16 t16 = Z80_RDMEM(PC++);
t16 |= Z80_RDMEM(PC++) << 8;
A = Z80_RDMEM(t16);
}
break;
case 0x3B:
TSTATES += 6;
SP--;
break;
case 0x3C:
TSTATES += 4;
INC(A);
break;
case 0x3D:
TSTATES += 4;
DEC(A);
break;
case 0x3E:
TSTATES += 7;
A = Z80_RDMEM(PC++);
break;
case 0x3F:
TSTATES += 4;
CCF();
break;
case 0x40:
TSTATES += 4;
break;
case 0x41:
TSTATES += 4;
B = C;
break;
case 0x42:
TSTATES += 4;
B = D;
break;
case 0x43:
TSTATES += 4;
B = E;
break;
case 0x44:
TSTATES += 4;
B = H;
break;
case 0x45:
TSTATES += 4;
B = L;
break;
case 0x46:
TSTATES += 7;
B = Z80_RDMEM(HL);
break;
case 0x47:
TSTATES += 4;
B = A;
break;
case 0x48:
TSTATES += 4;
C = B;
break;
case 0x49:
TSTATES += 4;
break;
case 0x4A:
TSTATES += 4;
C = D;
break;
case 0x4B:
TSTATES += 4;
C = E;
break;
case 0x4C:
TSTATES += 4;
C = H;
break;
case 0x4D:
TSTATES += 4;
C = L;
break;
case 0x4E:
TSTATES += 7;
C = Z80_RDMEM(HL);
break;
case 0x4F:
TSTATES += 4;
C = A;
break;
case 0x50:
TSTATES += 4;
D = B;
break;
case 0x51:
TSTATES += 4;
D = C;
break;
case 0x52:
TSTATES += 4;
break;
case 0x53:
TSTATES += 4;
D = E;
break;
case 0x54:
TSTATES += 4;
D = H;
break;
case 0x55:
TSTATES += 4;
D = L;
break;
case 0x56:
TSTATES += 7;
D = Z80_RDMEM(HL);
break;
case 0x57:
TSTATES += 4;
D = A;
break;
case 0x58:
TSTATES += 4;
E = B;
break;
case 0x59:
TSTATES += 4;
E = C;
break;
case 0x5A:
TSTATES += 4;
E = D;
break;
case 0x5B:
TSTATES += 4;
break;
case 0x5C:
TSTATES += 4;
E = H;
break;
case 0x5D:
TSTATES += 4;
E = L;
break;
case 0x5E:
TSTATES += 7;
E = Z80_RDMEM(HL);
break;
case 0x5F:
TSTATES += 4;
E = A;
break;
case 0x60:
TSTATES += 4;
H = B;
break;
case 0x61:
TSTATES += 4;
H = C;
break;
case 0x62:
TSTATES += 4;
H = D;
break;
case 0x63:
TSTATES += 4;
H = E;
break;
case 0x64:
TSTATES += 4;
break;
case 0x65:
TSTATES += 4;
H = L;
break;
case 0x66:
TSTATES += 7;
H = Z80_RDMEM(HL);
break;
case 0x67:
TSTATES += 4;
H = A;
break;
case 0x68:
TSTATES += 4;
L = B;
break;
case 0x69:
TSTATES += 4;
L = C;
break;
case 0x6A:
TSTATES += 4;
L = D;
break;
case 0x6B:
TSTATES += 4;
L = E;
break;
case 0x6C:
TSTATES += 4;
L = H;
break;
case 0x6D:
TSTATES += 4;
break;
case 0x6E:
TSTATES += 7;
L = Z80_RDMEM(HL);
break;
case 0x6F:
TSTATES += 4;
L = A;
break;
case 0x70:
TSTATES += 7;
Z80_WRMEM(HL, B);
break;
case 0x71:
TSTATES += 7;
Z80_WRMEM(HL, C);
break;
case 0x72:
TSTATES += 7;
Z80_WRMEM(HL, D);
break;
case 0x73:
TSTATES += 7;
Z80_WRMEM(HL, E);
break;
case 0x74:
TSTATES += 7;
Z80_WRMEM(HL, H);
break;
case 0x75:
TSTATES += 7;
Z80_WRMEM(HL, L);
break;
case 0x76:
{
unsigned int inc = ((cycles - TSTATES - 1) >> 2) + 1;
TSTATES += inc << 2;
R += inc - 1;
HALT = 1;
#ifdef DELAY_EI
if (Cpu.eiDelayed)
{
IFF1 = 1;
IFF2 = 1;
Cpu.eiDelayed = 0;
}
#endif
#ifdef DEBUG_HALT
if (!IFF1)
{
Msg(M_WARN, "entering HALT mode with interrupts disabled");
}
#endif
}
break;
case 0x77:
TSTATES += 7;
Z80_WRMEM(HL, A);
break;
case 0x78:
TSTATES += 4;
A = B;
break;
case 0x79:
TSTATES += 4;
A = C;
break;
case 0x7A:
TSTATES += 4;
A = D;
break;
case 0x7B:
TSTATES += 4;
A = E;
break;
case 0x7C:
TSTATES += 4;
A = H;
break;
case 0x7D:
TSTATES += 4;
A = L;
break;
case 0x7E:
TSTATES += 7;
A = Z80_RDMEM(HL);
break;
case 0x7F:
TSTATES += 4;
break;
case 0x80:
TSTATES += 4;
ADD(B);
break;
case 0x81:
TSTATES += 4;
ADD(C);
break;
case 0x82:
TSTATES += 4;
ADD(D);
break;
case 0x83:
TSTATES += 4;
ADD(E);
break;
case 0x84:
TSTATES += 4;
ADD(H);
break;
case 0x85:
TSTATES += 4;
ADD(L);
break;
case 0x86:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
ADD(t8);
}
break;
case 0x87:
TSTATES += 4;
ADD(A);
break;
case 0x88:
TSTATES += 4;
ADC(B);
break;
case 0x89:
TSTATES += 4;
ADC(C);
break;
case 0x8A:
TSTATES += 4;
ADC(D);
break;
case 0x8B:
TSTATES += 4;
ADC(E);
break;
case 0x8C:
TSTATES += 4;
ADC(H);
break;
case 0x8D:
TSTATES += 4;
ADC(L);
break;
case 0x8E:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
ADC(t8);
}
break;
case 0x8F:
TSTATES += 4;
ADC(A);
break;
case 0x90:
TSTATES += 4;
SUB(B);
break;
case 0x91:
TSTATES += 4;
SUB(C);
break;
case 0x92:
TSTATES += 4;
SUB(D);
break;
case 0x93:
TSTATES += 4;
SUB(E);
break;
case 0x94:
TSTATES += 4;
SUB(H);
break;
case 0x95:
TSTATES += 4;
SUB(L);
break;
case 0x96:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
SUB(t8);
}
break;
case 0x97:
TSTATES += 7;
SUB(A);
break;
case 0x98:
TSTATES += 4;
SBC(B);
break;
case 0x99:
TSTATES += 4;
SBC(C);
break;
case 0x9A:
TSTATES += 4;
SBC(D);
break;
case 0x9B:
TSTATES += 4;
SBC(E);
break;
case 0x9C:
TSTATES += 4;
SBC(H);
break;
case 0x9D:
TSTATES += 4;
SBC(L);
break;
case 0x9E:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
SBC(t8);
}
break;
case 0x9F:
TSTATES += 4;
SBC(A);
break;
case 0xA0:
TSTATES += 4;
AND(B);
break;
case 0xA1:
TSTATES += 4;
AND(C);
break;
case 0xA2:
TSTATES += 4;
AND(D);
break;
case 0xA3:
TSTATES += 4;
AND(E);
break;
case 0xA4:
TSTATES += 4;
AND(H);
break;
case 0xA5:
TSTATES += 4;
AND(L);
break;
case 0xA6:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
AND(t8);
}
break;
case 0xA7:
TSTATES += 4;
AND(A);
break;
case 0xA8:
TSTATES += 4;
XOR(B);
break;
case 0xA9:
TSTATES += 4;
XOR(C);
break;
case 0xAA:
TSTATES += 4;
XOR(D);
break;
case 0xAB:
TSTATES += 4;
XOR(E);
break;
case 0xAC:
TSTATES += 4;
XOR(H);
break;
case 0xAD:
TSTATES += 4;
XOR(L);
break;
case 0xAE:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
XOR(t8);
}
break;
case 0xAF:
TSTATES += 4;
XOR(A);
break;
case 0xB0:
TSTATES += 4;
OR(B);
break;
case 0xB1:
TSTATES += 4;
OR(C);
break;
case 0xB2:
TSTATES += 4;
OR(D);
break;
case 0xB3:
TSTATES += 4;
OR(E);
break;
case 0xB4:
TSTATES += 4;
OR(H);
break;
case 0xB5:
TSTATES += 4;
OR(L);
break;
case 0xB6:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
OR(t8);
}
break;
case 0xB7:
TSTATES += 4;
OR(A);
break;
case 0xB8:
TSTATES += 4;
CMP(B);
break;
case 0xB9:
TSTATES += 4;
CMP(C);
break;
case 0xBA:
TSTATES += 4;
CMP(D);
break;
case 0xBB:
TSTATES += 4;
CMP(E);
break;
case 0xBC:
TSTATES += 4;
CMP(H);
break;
case 0xBD:
TSTATES += 4;
CMP(L);
break;
case 0xBE:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(HL);
CMP(t8);
}
break;
case 0xBF:
TSTATES += 4;
CMP(A);
break;
case 0xC0:
TSTATES += 5;
if (!(F & Z_FLAG))
{
TSTATES += 6;
RET();
}
break;
case 0xC1:
TSTATES += 10;
POP(B, C);
break;
case 0xC2:
TSTATES += 10;
if (!(F & Z_FLAG))
{
JP();
}
else
{
PC += 2;
}
break;
case 0xC3:
TSTATES += 10;
JP();
break;
case 0xC4:
if (!(F & Z_FLAG))
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xC5:
TSTATES += 11;
PUSH(B, C);
break;
case 0xC6:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(PC++);
ADD(t8);
}
break;
case 0xC7:
if (!READ_ONLY(PC - 1))
{
Debugger(DBG_BREAKPOINT);
}
else
{
TSTATES += 11;
RST(0x0000);
}
break;
case 0xC8:
TSTATES += 5;
if (F & Z_FLAG)
{
TSTATES += 6;
RET();
}
break;
case 0xC9:
TSTATES += 10;
RET();
break;
case 0xCA:
TSTATES += 10;
if (F & Z_FLAG)
{
JP();
}
else
{
PC += 2;
}
break;
case 0xCB:
#ifndef HAVE_ENOUGH_SWAP
z80_DecodeCB();
#else
op = Z80_RDOP2(PC++);
R++;
switch (op)
{
#		include "z80_cbops.c"
}
#endif
break;
case 0xCC:
if (F & Z_FLAG)
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xCD:
TSTATES += 17;
CALL();
break;
case 0xCE:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(PC++);
ADC(t8);
}
break;
case 0xCF:
TSTATES += 11;
RST(0x0008);
break;
case 0xD0:
TSTATES += 5;
if (!(F & C_FLAG))
{
TSTATES += 6;
RET();
}
break;
case 0xD1:
TSTATES += 10;
POP(D, E);
break;
case 0xD2:
TSTATES += 10;
if (!(F & C_FLAG))
{
JP();
}
else
{
PC += 2;
}
break;
case 0xD3:
TSTATES += 11;
Z80_OUT((A << 8) | Z80_RDMEM(PC++), A);
break;
case 0xD4:
if (!(F & C_FLAG))
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xD5:
TSTATES += 11;
PUSH(D, E);
break;
case 0xD6:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(PC++);
SUB(t8);
}
break;
case 0xD7:
TSTATES += 11;
RST(0x0010);
break;
case 0xD8:
TSTATES += 5;
if (F & C_FLAG)
{
TSTATES += 6;
RET();
}
break;
case 0xD9:
TSTATES += 4;
{
uns16 t16 = BC; BC = BC1; BC1 = t16;
t16 = DE; DE = DE1; DE1 = t16;
t16 = HL; HL = HL1; HL1 = t16;
}
break;
case 0xDA:
TSTATES += 10;
if (F & C_FLAG)
{
JP();
}
else
{
PC += 2;
}
break;
case 0xDB:
TSTATES += 11;
A = Z80_IN((A << 8) | Z80_RDMEM(PC++));
break;
case 0xDC:
if (F & C_FLAG)
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xDD:
#ifndef HAVE_ENOUGH_SWAP
z80_DecodeDD();
#else
op = Z80_RDOP2(PC++);
R++;
switch (op)
{
#		define XX  IX
#		define LXX LIX
#		define HXX HIX
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
}
#endif
break;
case 0xDE:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(PC++);
SBC(t8);
}
break;
case 0xDF:
TSTATES += 11;
RST(0x0018);
break;
case 0xE0:
TSTATES += 5;
if (!(F & P_FLAG))
{
TSTATES += 6;
RET();
}
break;
case 0xE1:
TSTATES += 10;
POP(H, L);
break;
case 0xE2:
TSTATES += 10;
if (!(F & P_FLAG))
{
JP();
}
else
{
PC += 2;
}
break;
case 0xE3:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(SP); Z80_WRMEM(SP, L); L = t8;
t8 = Z80_RDMEM(SP + 1); Z80_WRMEM(SP + 1, H); H = t8;
}
break;
case 0xE4:
if (!(F & P_FLAG))
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xE5:
TSTATES += 11;
PUSH(H, L);
break;
case 0xE6:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(PC++);
AND(t8);
}
break;
case 0xE7:
TSTATES += 11;
RST(0x0020);
break;
case 0xE8:
TSTATES += 5;
if (F & P_FLAG)
{
TSTATES += 6;
RET();
}
break;
case 0xE9:
TSTATES += 4;
PC = HL;
break;
case 0xEA:
TSTATES += 10;
if (F & P_FLAG)
{
JP();
}
else
{
PC += 2;
}
break;
case 0xEB:
TSTATES += 4;
{
uns16 t16 = DE; DE = HL; HL = t16;
}
break;
case 0xEC:
if (F & P_FLAG)
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xED:
#ifndef HAVE_ENOUGH_SWAP
z80_DecodeED();
#else
op = Z80_RDOP2(PC++);
R++;
switch (op)
{
#		include "z80_edops.c"
}
#endif
break;
case 0xEE:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(PC++);
XOR(t8);
}
break;
case 0xEF:
TSTATES += 11;
RST(0x0028);
break;
case 0xF0:
TSTATES += 5;
if (!(F & S_FLAG))
{
TSTATES += 6;
RET();
}
break;
case 0xF1:
TSTATES += 10;
POP(A, F);
break;
case 0xF2:
TSTATES += 10;
if (!(F & S_FLAG))
{
JP();
}
else
{
PC += 2;
}
break;
case 0xF3:
TSTATES += 4;
IFF1 = 0;
IFF2 = 0;
break;
case 0xF4:
if (!(F & S_FLAG))
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xF5:
TSTATES += 11;
PUSH(A, F);
break;
case 0xF6:
TSTATES += 7;
{
uns8 t8 = Z80_RDMEM(PC++);
OR(t8);
}
break;
case 0xF7:
TSTATES += 11;
RST(0x0030);
break;
case 0xF8:
TSTATES += 5;
if (F & S_FLAG)
{
TSTATES += 6;
RET();
}
break;
case 0xF9:
TSTATES += 6;
SP = HL;
break;
case 0xFA:
TSTATES += 10;
if (F & S_FLAG)
{
JP();
}
else
{
PC += 2;
}
break;
case 0xFB:
TSTATES += 4;
#ifdef DELAY_EI
Cpu.eiDelayed = 1;
#else
IFF1 = 1;
IFF2 = 1;
#endif
break;
case 0xFC:
if (F & S_FLAG)
{
TSTATES += 17;
CALL();
}
else
{
TSTATES += 10;
PC += 2;
}
break;
case 0xFD:
#ifndef HAVE_ENOUGH_SWAP
z80_DecodeFD();
#else
op = Z80_RDOP2(PC++);
R++;
switch (op)
{
#		define NO_RCSID
#		define XX  IY
#		define LXX LIY
#		define HXX HIY
#		include "z80_xxops.c"
#		undef XX
#		undef LXX
#		undef HXX
#		undef NO_RCSID
}
#endif
break;
case 0xFE:
TSTATES += 7;
{
uns8 t8  = Z80_RDMEM(PC++);
CMP(t8);
}
break;
case 0xFF:
TSTATES += 11;
RST(0x0038);
break;
#undef ADD_HL
#undef JR
#undef JP
#undef CALL
#undef RST
