/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifndef lint
static char z80_cbops_c[] = "$Id: z80_cbops.c,v 4.5 1998/07/30 19:16:37 erik Rel $";
#endif
case 0x00:
TSTATES += 8;
RLC(B);
break;
case 0x01:
TSTATES += 8;
RLC(C);
break;
case 0x02:
TSTATES += 8;
RLC(D);
break;
case 0x03:
TSTATES += 8;
RLC(E);
break;
case 0x04:
TSTATES += 8;
RLC(H);
break;
case 0x05:
TSTATES += 8;
RLC(L);
break;
case 0x06:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
RLC(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x07:
TSTATES += 8;
RLC(A);
break;
case 0x08:
TSTATES += 8;
RRC(B);
break;
case 0x09:
TSTATES += 8;
RRC(C);
break;
case 0x0A:
TSTATES += 8;
RRC(D);
break;
case 0x0B:
TSTATES += 8;
RRC(E);
break;
case 0x0C:
TSTATES += 8;
RRC(H);
break;
case 0x0D:
TSTATES += 8;
RRC(L);
break;
case 0x0E:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
RRC(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x0F:
TSTATES += 8;
RRC(A);
break;
case 0x10:
TSTATES += 8;
RL(B);
break;
case 0x11:
TSTATES += 8;
RL(C);
break;
case 0x12:
TSTATES += 8;
RL(D);
break;
case 0x13:
TSTATES += 8;
RL(E);
break;
case 0x14:
TSTATES += 8;
RL(H);
break;
case 0x15:
TSTATES += 8;
RL(L);
break;
case 0x16:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
RL(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x17:
TSTATES += 8;
RL(A);
break;
case 0x18:
TSTATES += 8;
RR(B);
break;
case 0x19:
TSTATES += 8;
RR(C);
break;
case 0x1A:
TSTATES += 8;
RR(D);
break;
case 0x1B:
TSTATES += 8;
RR(E);
break;
case 0x1C:
TSTATES += 8;
RR(H);
break;
case 0x1D:
TSTATES += 8;
RR(L);
break;
case 0x1E:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
RR(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x1F:
TSTATES += 8;
RR(A);
break;
case 0x20:
TSTATES += 8;
SLA(B);
break;
case 0x21:
TSTATES += 8;
SLA(C);
break;
case 0x22:
TSTATES += 8;
SLA(D);
break;
case 0x23:
TSTATES += 8;
SLA(E);
break;
case 0x24:
TSTATES += 8;
SLA(H);
break;
case 0x25:
TSTATES += 8;
SLA(L);
break;
case 0x26:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
SLA(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x27:
TSTATES += 8;
SLA(A);
break;
case 0x28:
TSTATES += 8;
SRA(B);
break;
case 0x29:
TSTATES += 8;
SRA(C);
break;
case 0x2A:
TSTATES += 8;
SRA(D);
break;
case 0x2B:
TSTATES += 8;
SRA(E);
break;
case 0x2C:
TSTATES += 8;
SRA(H);
break;
case 0x2D:
TSTATES += 8;
SRA(L);
break;
case 0x2E:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
SRA(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x2F:
TSTATES += 8;
SRA(A);
break;
case 0x30:
TSTATES += 8;
SLI(B);
break;
case 0x31:
TSTATES += 8;
SLI(C);
break;
case 0x32:
TSTATES += 8;
SLI(D);
break;
case 0x33:
TSTATES += 8;
SLI(E);
break;
case 0x34:
TSTATES += 8;
SLI(H);
break;
case 0x35:
TSTATES += 8;
SLI(L);
break;
case 0x36:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
SLI(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x37:
TSTATES += 8;
SLI(A);
break;
case 0x38:
TSTATES += 8;
SRL(B);
break;
case 0x39:
TSTATES += 8;
SRL(C);
break;
case 0x3A:
TSTATES += 8;
SRL(D);
break;
case 0x3B:
TSTATES += 8;
SRL(E);
break;
case 0x3C:
TSTATES += 8;
SRL(H);
break;
case 0x3D:
TSTATES += 8;
SRL(L);
break;
case 0x3E:
TSTATES += 15;
{
uns8 t8 = Z80_RDMEM(HL);
SRL(t8);
Z80_WRMEM(HL, t8);
}
break;
case 0x3F:
TSTATES += 8;
SRL(A);
break;
case 0x40:
TSTATES += 8;
BIT(0, B);
break;
case 0x41:
TSTATES += 8;
BIT(0, C);
break;
case 0x42:
TSTATES += 8;
BIT(0, D);
break;
case 0x43:
TSTATES += 8;
BIT(0, E);
break;
case 0x44:
TSTATES += 8;
BIT(0, H);
break;
case 0x45:
TSTATES += 8;
BIT(0, L);
break;
case 0x46:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(0, t8);
}
break;
case 0x47:
TSTATES += 8;
BIT(0, A);
break;
case 0x48:
TSTATES += 8;
BIT(1, B);
break;
case 0x49:
TSTATES += 8;
BIT(1, C);
break;
case 0x4A:
TSTATES += 8;
BIT(1, D);
break;
case 0x4B:
TSTATES += 8;
BIT(1, E);
break;
case 0x4C:
TSTATES += 8;
BIT(1, H);
break;
case 0x4D:
TSTATES += 8;
BIT(1, L);
break;
case 0x4E:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(1, t8);
}
break;
case 0x4F:
TSTATES += 8;
BIT(1, A);
break;
case 0x50:
TSTATES += 8;
BIT(2, B);
break;
case 0x51:
TSTATES += 8;
BIT(2, C);
break;
case 0x52:
TSTATES += 8;
BIT(2, D);
break;
case 0x53:
TSTATES += 8;
BIT(2, E);
break;
case 0x54:
TSTATES += 8;
BIT(2, H);
break;
case 0x55:
TSTATES += 8;
BIT(2, L);
break;
case 0x56:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(2, t8);
}
break;
case 0x57:
TSTATES += 8;
BIT(2, A);
break;
case 0x58:
TSTATES += 8;
BIT(3, B);
break;
case 0x59:
TSTATES += 8;
BIT(3, C);
break;
case 0x5A:
TSTATES += 8;
BIT(3, D);
break;
case 0x5B:
TSTATES += 8;
BIT(3, E);
break;
case 0x5C:
TSTATES += 8;
BIT(3, H);
break;
case 0x5D:
TSTATES += 8;
BIT(3, L);
break;
case 0x5E:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(3, t8);
}
break;
case 0x5F:
TSTATES += 8;
BIT(3, A);
break;
case 0x60:
TSTATES += 8;
BIT(4, B);
break;
case 0x61:
TSTATES += 8;
BIT(4, C);
break;
case 0x62:
TSTATES += 8;
BIT(4, D);
break;
case 0x63:
TSTATES += 8;
BIT(4, E);
break;
case 0x64:
TSTATES += 8;
BIT(4, H);
break;
case 0x65:
TSTATES += 8;
BIT(4, L);
break;
case 0x66:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(4, t8);
}
break;
case 0x67:
TSTATES += 8;
BIT(4, A);
break;
case 0x68:
TSTATES += 8;
BIT(5, B);
break;
case 0x69:
TSTATES += 8;
BIT(5, C);
break;
case 0x6A:
TSTATES += 8;
BIT(5, D);
break;
case 0x6B:
TSTATES += 8;
BIT(5, E);
break;
case 0x6C:
TSTATES += 8;
BIT(5, H);
break;
case 0x6D:
TSTATES += 8;
BIT(5, L);
break;
case 0x6E:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(5, t8);
}
break;
case 0x6F:
TSTATES += 8;
BIT(5, A);
break;
case 0x70:
TSTATES += 8;
BIT(6, B);
break;
case 0x71:
TSTATES += 8;
BIT(6, C);
break;
case 0x72:
TSTATES += 8;
BIT(6, D);
break;
case 0x73:
TSTATES += 8;
BIT(6, E);
break;
case 0x74:
TSTATES += 8;
BIT(6, H);
break;
case 0x75:
TSTATES += 8;
BIT(6, L);
break;
case 0x76:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(6, t8);
}
break;
case 0x77:
TSTATES += 8;
BIT(6, A);
break;
case 0x78:
TSTATES += 8;
BIT(7, B);
break;
case 0x79:
TSTATES += 8;
BIT(7, C);
break;
case 0x7A:
TSTATES += 8;
BIT(7, D);
break;
case 0x7B:
TSTATES += 8;
BIT(7, E);
break;
case 0x7C:
TSTATES += 8;
BIT(7, H);
break;
case 0x7D:
TSTATES += 8;
BIT(7, L);
break;
case 0x7E:
TSTATES += 12;
{
uns8 t8 = Z80_RDMEM(HL);
BIT(7, t8);
}
break;
case 0x7F:
TSTATES += 8;
BIT(7, A);
break;
case 0x80:
TSTATES += 8;
B &= 0xfe;
break;
case 0x81:
TSTATES += 8;
C &= 0xfe;
break;
case 0x82:
TSTATES += 8;
D &= 0xfe;
break;
case 0x83:
TSTATES += 8;
E &= 0xfe;
break;
case 0x84:
TSTATES += 8;
H &= 0xfe;
break;
case 0x85:
TSTATES += 8;
L &= 0xfe;
break;
case 0x86:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0xfe);
break;
case 0x87:
TSTATES += 8;
A &= 0xfe;
break;
case 0x88:
TSTATES += 8;
B &= 0xfd;
break;
case 0x89:
TSTATES += 8;
C &= 0xfd;
break;
case 0x8A:
TSTATES += 8;
D &= 0xfd;
break;
case 0x8B:
TSTATES += 8;
E &= 0xfd;
break;
case 0x8C:
TSTATES += 8;
H &= 0xfd;
break;
case 0x8D:
TSTATES += 8;
L &= 0xfd;
break;
case 0x8E:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0xfd);
break;
case 0x8F:
TSTATES += 8;
A &= 0xfd;
break;
case 0x90:
TSTATES += 8;
B &= 0xfb;
break;
case 0x91:
TSTATES += 8;
C &= 0xfb;
break;
case 0x92:
TSTATES += 8;
D &= 0xfb;
break;
case 0x93:
TSTATES += 8;
E &= 0xfb;
break;
case 0x94:
TSTATES += 8;
H &= 0xfb;
break;
case 0x95:
TSTATES += 8;
L &= 0xfb;
break;
case 0x96:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0xfb);
break;
case 0x97:
TSTATES += 8;
A &= 0xfb;
break;
case 0x98:
TSTATES += 8;
B &= 0xf7;
break;
case 0x99:
TSTATES += 8;
C &= 0xf7;
break;
case 0x9A:
TSTATES += 8;
D &= 0xf7;
break;
case 0x9B:
TSTATES += 8;
E &= 0xf7;
break;
case 0x9C:
TSTATES += 8;
H &= 0xf7;
break;
case 0x9D:
TSTATES += 8;
L &= 0xf7;
break;
case 0x9E:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0xf7);
break;
case 0x9F:
TSTATES += 8;
A &= 0xf7;
break;
case 0xA0:
TSTATES += 8;
B &= 0xef;
break;
case 0xA1:
TSTATES += 8;
C &= 0xef;
break;
case 0xA2:
TSTATES += 8;
D &= 0xef;
break;
case 0xA3:
TSTATES += 8;
E &= 0xef;
break;
case 0xA4:
TSTATES += 8;
H &= 0xef;
break;
case 0xA5:
TSTATES += 8;
L &= 0xef;
break;
case 0xA6:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0xef);
break;
case 0xA7:
TSTATES += 8;
A &= 0xef;
break;
case 0xA8:
TSTATES += 8;
B &= 0xdf;
break;
case 0xA9:
TSTATES += 8;
C &= 0xdf;
break;
case 0xAA:
TSTATES += 8;
D &= 0xdf;
break;
case 0xAB:
TSTATES += 8;
E &= 0xdf;
break;
case 0xAC:
TSTATES += 8;
H &= 0xdf;
break;
case 0xAD:
TSTATES += 8;
L &= 0xdf;
break;
case 0xAE:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0xdf);
break;
case 0xAF:
TSTATES += 8;
A &= 0xdf;
break;
case 0xB0:
TSTATES += 8;
B &= 0xbf;
break;
case 0xB1:
TSTATES += 8;
C &= 0xbf;
break;
case 0xB2:
TSTATES += 8;
D &= 0xbf;
break;
case 0xB3:
TSTATES += 8;
E &= 0xbf;
break;
case 0xB4:
TSTATES += 8;
H &= 0xbf;
break;
case 0xB5:
TSTATES += 8;
L &= 0xbf;
break;
case 0xB6:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0xbf);
break;
case 0xB7:
TSTATES += 8;
A &= 0xbf;
break;
case 0xB8:
TSTATES += 8;
B &= 0x7f;
break;
case 0xB9:
TSTATES += 8;
C &= 0x7f;
break;
case 0xBA:
TSTATES += 8;
D &= 0x7f;
break;
case 0xBB:
TSTATES += 8;
E &= 0x7f;
break;
case 0xBC:
TSTATES += 8;
H &= 0x7f;
break;
case 0xBD:
TSTATES += 8;
L &= 0x7f;
break;
case 0xBE:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) & 0x7f);
break;
case 0xBF:
TSTATES += 8;
A &= 0x7f;
break;
case 0xC0:
TSTATES += 8;
B |= 0x1;
break;
case 0xC1:
TSTATES += 8;
C |= 0x1;
break;
case 0xC2:
TSTATES += 8;
D |= 0x1;
break;
case 0xC3:
TSTATES += 8;
E |= 0x1;
break;
case 0xC4:
TSTATES += 8;
H |= 0x1;
break;
case 0xC5:
TSTATES += 8;
L |= 0x1;
break;
case 0xC6:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x1);
break;
case 0xC7:
TSTATES += 8;
A |= 0x1;
break;
case 0xC8:
TSTATES += 8;
B |= 0x2;
break;
case 0xC9:
TSTATES += 8;
C |= 0x2;
break;
case 0xCA:
TSTATES += 8;
D |= 0x2;
break;
case 0xCB:
TSTATES += 8;
E |= 0x2;
break;
case 0xCC:
TSTATES += 8;
H |= 0x2;
break;
case 0xCD:
TSTATES += 8;
L |= 0x2;
break;
case 0xCE:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x2);
break;
case 0xCF:
TSTATES += 8;
A |= 0x2;
break;
case 0xD0:
TSTATES += 8;
B |= 0x4;
break;
case 0xD1:
TSTATES += 8;
C |= 0x4;
break;
case 0xD2:
TSTATES += 8;
D |= 0x4;
break;
case 0xD3:
TSTATES += 8;
E |= 0x4;
break;
case 0xD4:
TSTATES += 8;
H |= 0x4;
break;
case 0xD5:
TSTATES += 8;
L |= 0x4;
break;
case 0xD6:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x4);
break;
case 0xD7:
TSTATES += 8;
A |= 0x4;
break;
case 0xD8:
TSTATES += 8;
B |= 0x8;
break;
case 0xD9:
TSTATES += 8;
C |= 0x8;
break;
case 0xDA:
TSTATES += 8;
D |= 0x8;
break;
case 0xDB:
TSTATES += 8;
E |= 0x8;
break;
case 0xDC:
TSTATES += 8;
H |= 0x8;
break;
case 0xDD:
TSTATES += 8;
L |= 0x8;
break;
case 0xDE:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x8);
break;
case 0xDF:
TSTATES += 8;
A |= 0x8;
break;
case 0xE0:
TSTATES += 8;
B |= 0x10;
break;
case 0xE1:
TSTATES += 8;
C |= 0x10;
break;
case 0xE2:
TSTATES += 8;
D |= 0x10;
break;
case 0xE3:
TSTATES += 8;
E |= 0x10;
break;
case 0xE4:
TSTATES += 8;
H |= 0x10;
break;
case 0xE5:
TSTATES += 8;
L |= 0x10;
break;
case 0xE6:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x10);
break;
case 0xE7:
TSTATES += 8;
A |= 0x10;
break;
case 0xE8:
TSTATES += 8;
B |= 0x20;
break;
case 0xE9:
TSTATES += 8;
C |= 0x20;
break;
case 0xEA:
TSTATES += 8;
D |= 0x20;
break;
case 0xEB:
TSTATES += 8;
E |= 0x20;
break;
case 0xEC:
TSTATES += 8;
H |= 0x20;
break;
case 0xED:
TSTATES += 8;
L |= 0x20;
break;
case 0xEE:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x20);
break;
case 0xEF:
TSTATES += 8;
A |= 0x20;
break;
case 0xF0:
TSTATES += 8;
B |= 0x40;
break;
case 0xF1:
TSTATES += 8;
C |= 0x40;
break;
case 0xF2:
TSTATES += 8;
D |= 0x40;
break;
case 0xF3:
TSTATES += 8;
E |= 0x40;
break;
case 0xF4:
TSTATES += 8;
H |= 0x40;
break;
case 0xF5:
TSTATES += 8;
L |= 0x40;
break;
case 0xF6:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x40);
break;
case 0xF7:
TSTATES += 8;
A |= 0x40;
break;
case 0xF8:
TSTATES += 8;
B |= 0x80;
break;
case 0xF9:
TSTATES += 8;
C |= 0x80;
break;
case 0xFA:
TSTATES += 8;
D |= 0x80;
break;
case 0xFB:
TSTATES += 8;
E |= 0x80;
break;
case 0xFC:
TSTATES += 8;
H |= 0x80;
break;
case 0xFD:
TSTATES += 8;
L |= 0x80;
break;
case 0xFE:
TSTATES += 15;
Z80_WRMEM(HL, Z80_RDMEM(HL) | 0x80);
break;
case 0xFF:
TSTATES += 8;
A |= 0x80;
break;
