/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Ian Collier, Des Herriott
*          Erik Kunze
*
* $Id: resource.h,v 4.25 1999/01/12 17:11:50 erik Rel $
*******************************************************************************/
#ifndef _XZX_RESOURCE_H
#define _XZX_RESOURCE_H
#include <X11/Xlib.h>
typedef struct _config {
char *libDir;
int quiet;
char *geometry;
int mono;
int private;
#ifdef HAVE_MITSHM
int mitshm;
#endif
int xsync;
#ifdef DEBUG
unsigned int debug;
#endif
union {
int n;
char *s;
} _machine;
int speed;
int fast;
int scale;
int refresh;
int cache;
#ifdef SPEAKER_AUDIO
int noise;
#endif
#ifdef JOY
int joyActive;
char *joyDevice;
int joyTolerance;
int joyAutofire;
int joyJuggle;
#endif
KeySym joyKeys[5];
#ifdef AUDIO
int audioActive;
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
char *audioDevice;
int audioSample;
#endif
#ifdef XBELL_AUDIO
int audioVolume;
#endif
#endif
char *sp48Rom;
int issue;
char *kbdlayout;
char *sp128Rom;
#ifdef XZX_PLUS3
char *plus3Rom;
char *disks[2];
#endif
#ifdef XZX_PENTAGON
char *pentRom;
#endif
#ifdef XZX_SCORPION
char *scorRom;
#endif
#ifdef XZX_IF1
int if1Active;
char *if1Rom;
int if1TranslateNl;
int if1StripNl;
char *if1Carts[IF1_DRIVES];
#endif
#ifdef XZX_MF
int mfActive;
char *mf128Rom;
#ifdef XZX_PLUS3
char *mf3Rom;
#endif
#endif
#ifdef XZX_KMOUSE
int kmouseActive;
int kmouseGrab;
#endif
} Config;
#define GETCFG(x)		Conf.x
#define SETCFG(x,y)		Conf.x = y
#define machine			_machine.n
#define joyUp			joyKeys[0]
#define joyDown			joyKeys[1]
#define joyLeft			joyKeys[2]
#define joyRight		joyKeys[3]
#define joyFire			joyKeys[4]
extern Display *GetResources(int *, char **);
extern Config Conf;
#endif
