
/*
 * DREADOVER group:article
 *
 *	Read the overview record related to an article in a specific group.
 *	This command is typically used for debugging purposes only.
 *
 * (c)Copyright 1998, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution
 *    for specific rights granted.
 */

#include <dreaderd/defs.h>

void DReadOver(char *data);

int ForceOpt = 0;

int
main(int ac, char **av)
{
    int i;

    LoadDiabloConfig(ac, av);

    for (i = 1; i < ac; ++i) {
	char *ptr = av[i];

	if (*ptr != '-') {
	    DReadOver(ptr);
	    continue;
	}
	ptr += 2;
	switch(ptr[-1]) {
	case 'f':
	    ForceOpt = 1;
	    break;
	default:
	    fprintf(stderr, "Illegal option: %s\n", ptr - 2);
	    exit(1);
	}
    }
    return(0);
}

void
DReadOver(char *data)
{
    const char *gfname;
    const char *slash;
    char *ptr, *p;
    int artNo = 0;
    int artNoStart = 0;
    int artNoEnd = 0;
    int fd1;
    int fd2;
    OverHead oh;
    struct stat st;
    int maxarts;
    char path[1024];

    if ((ptr = strrchr(data, ':')) != NULL) {
	*ptr++ = 0;
	artNo = strtol(ptr, NULL, 10);
	artNoStart = artNo;
	artNoEnd = artNoStart;
	if ((p = strrchr(ptr, '-')) != NULL) {
		artNoEnd = strtol(p + 1, NULL, 10);
	}
	printf("Search from %d to %d\n", artNoStart, artNoEnd);
    }
    gfname = GFName(data, "over", 0);
    slash = strchr(gfname, '/');

    snprintf(path, sizeof(path), "%s/%s", PatExpand(GroupHomePat), gfname);
    printf("%s:%d\t%s", data, artNo, gfname);

    if ((fd1 = open(path, O_RDONLY)) < 0) {
	printf("\t(array open fail)\n");
	return;
    }
    if (read(fd1, &oh, sizeof(oh)) != sizeof(oh)) {
	printf("\t(read header fail)\n");
	close(fd1);
	return;
    }
    if (oh.oh_Version != OH_VERSION ||
	oh.oh_ByteOrder != OH_BYTEORDER
    ) {
	printf("\t(wrong version or byte order)\n");
	close(fd1);
	return;
    }
    fstat(fd1, &st);
    maxarts = (st.st_size - oh.oh_HeadSize) / sizeof(OverArt);
    printf("\tmaxarts=%d", maxarts);

    for (artNo = artNoStart; artNo < artNoEnd; ++artNo) {
	gfname = GFName(data, "data", artNo & ~OD_HMASK);
	snprintf(path, sizeof(path), "%s/%s", PatExpand(GroupHomePat), gfname);
	printf(" %s", gfname);
	if ((fd2 = open(path, O_RDONLY)) < 0) {
	    printf("\t(data open fail)\n");
	    close(fd1);
	    return;
	}
	if (artNo) {
	    int pos = oh.oh_HeadSize + ((artNo & 0x7FFFFFFF) % maxarts) * sizeof(OverArt);
	    OverArt oa;
	    printf("\tpos=%d", pos);
	    lseek(fd1, pos, 0);
	    if (read(fd1, &oa, sizeof(oa)) != sizeof(oa)) {
		printf("\t(unable to read OverArt)");
	    } else {
		int showArt = 1;

		if (oa.oa_ArtNo != artNo) {
		    printf("\tartNoMismatch(%d)", oa.oa_ArtNo);
		    if (ForceOpt == 0)
			showArt = 0;
		}
		if (showArt) {
		    char buf[8192];
		    int n = oa.oa_Bytes;
		    int r;

		    printf("\tdataFilePos=%d size=%d:\n", oa.oa_SeekPos, oa.oa_Bytes);
		    lseek(fd2, oa.oa_SeekPos, 0);
		    while ((r = read(fd2, buf, (n > sizeof(buf)) ? sizeof(buf) : n)) > 0) {
			write(1, buf, r);
			n -= r;
		    }
		}
	    }
	    printf("\n");
	}
	close(fd2);
    }
    close(fd1);
}

