
/*
 * LIB/SUBS.C
 *
 * (c)Copyright 1998, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution
 *    for specific rights granted.
 *
 */

#include "defs.h"

Prototype void ArticleFileName(char *path, int pathSize, History *h, int absolute);
Prototype const char *PatExpand(const char *pat);
Prototype void diablo_strlcpy(char *d, const char *s, int ssize, int dsize);
Prototype void diablo_strlcpynl(char *d, const char *s, int ssize, int dsize);
Prototype const char *PatExpand(const char *pat);
Prototype const char *PatLibExpand(const char *pat);
Prototype const char *PatDbExpand(const char *pat);

/*
 * ArticleFileName()
 *
 *	absolute = -1	directory name only
 *		 = 0	relative path to file
 *		 = 1	absolute path to file
 *
 *
 */

void
ArticleFileName(char *path, int pathSize, History *h, int absolute)
{
    int l = 0;

    if (absolute > 0) {
	snprintf(path, pathSize, "%s/", PatExpand(SpoolHomePat));
	l = strlen(path);
    }

    if (absolute < 0) {
	snprintf(path + l, pathSize - l, "D.%08x",
	    h->gmt - h->gmt % 10
	);
    } else if (h->boffset || h->bsize) {
	snprintf(path + l, pathSize - l, "D.%08x/B.%04x",
	    h->gmt - h->gmt % 10,
	    (int)h->iter
	);
    } else {
	snprintf(path + l, pathSize - l, "D.%08x/%08x.%08x.%04x",
	    h->gmt - h->gmt % 10,
	    h->hv.h1,
	    h->hv.h2,
	    h->iter
	);
    }
}

void 
diablo_strlcpy(char *d, const char *s, int ssize, int dsize)
{
    while (ssize && dsize > 1 && *s) {
	*d = *s;
	--ssize;
	--dsize;
	++s;
	++d;
    }
    *d = 0;
}

void 
diablo_strlcpynl(char *d, const char *s, int ssize, int dsize)
{
    char *dold = d;

    while (ssize && *s == ' ') {
	++s;
	--ssize;
    }

    while (ssize && dsize > 1 && *s) {
	*d = *s;
	--ssize;
	--dsize;
	++s;
	++d;
    }
    *d = 0;

    /*
     * remove newlines and trailing tabs and spaces
     */
    if (d != dold && d[-1] == '\n') {
	--d;
	*d = 0;
    }
    while (d != dold && (d[-1] == '\t' || d[-1] == ' ')) {
	--d;
	*d = 0;
    }
}

#if USE_INTERNAL_VSYSLOG

void
vsyslog(int priority, const char *ctl, va_list va)
{
    char buf[1024];

    vsnprintf(buf, sizeof(buf), ctl, va);
    syslog(priority, "%s", buf);
}

#endif

static char PatPath1[128];
static char PatPath2[128];

const char *
PatExpand(const char *pat)
{
    snprintf(PatPath1, sizeof(PatPath1), pat, NewsHome);

    return(PatPath1);
}


const char *
PatLibExpand(const char *pat)
{
    snprintf(PatPath2, sizeof(PatPath2), pat, PatExpand(LibHomePat));
    return(PatPath2);
}


const char *
PatDbExpand(const char *pat)
{
    snprintf(PatPath2, sizeof(PatPath2), pat, PatExpand(DbHomePat));
    return(PatPath2);
}


