#include <signal.h>
#include "sig.h"
#include "substdio.h"
#include "strerr.h"
#include "readwrite.h"
#include "exit.h"

char outbuf[512];
substdio ssout;

char inbuf[512];
substdio ssin;

int myread(fd,buf,len) int fd; char *buf; int len;
{
  substdio_flush(&ssout);
  return read(fd,buf,len);
}

void main()
{
  int pid;
  int wstat;
  char ch;

  sig_pipeignore();

  pid = fork();
  if (pid == -1) strerr_die2sys(111,"mconnect-io: fatal: ","unable to fork: ");

  if (!pid) {
    substdio_fdbuf(&ssin,myread,0,inbuf,sizeof inbuf);
    substdio_fdbuf(&ssout,write,7,outbuf,sizeof outbuf);

    while (substdio_get(&ssin,&ch,1) == 1) {
      if (ch == '\n') substdio_put(&ssout,"\r",1);
      substdio_put(&ssout,&ch,1);
    }
    _exit(0);
  }

  substdio_fdbuf(&ssin,myread,6,inbuf,sizeof inbuf);
  substdio_fdbuf(&ssout,write,1,outbuf,sizeof outbuf);

  while (substdio_get(&ssin,&ch,1) == 1)
    substdio_put(&ssout,&ch,1);

  kill(pid,SIGTERM);
  wait_pid(&wstat,pid);

  _exit(0);
}
