/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPWebDebugModule.cpp

	Contains:	Implements web debug module

	$Log: RTSPWebDebugModule.cpp,v $
	Revision 1.2  1999/02/19 23:08:42  ds
	Created
	

*/

#include "RTSPWebDebugModule.h"
#include "OS.h"

StrPtrLen RTSPWebDebugModule::sRequestHeader("GET /debug HTTP", 15);
char* RTSPWebDebugModule::sResponseHeader = "HTTP/1.0 200 OK\r\nServer: TimeShare/1.0\r\nConnection: Close\r\nContent-Type: text/html\r\n\r\n";
char* RTSPWebDebugModule::sResponseEnd = "</BODY></HTML>";


void RTSPWebDebugModule::FilterRequest(RTSPRequestInterface* request)
{
	StrPtrLen* fullRequest = request->GetQTSSParameter(qtssFullRequestParam);
	//check to see if we should handle this request. Invokation is triggered
	//by an HTTP request for /debug
	if (fullRequest->Len < sRequestHeader.Len)
		return;
	if (memcmp(fullRequest->Ptr, sRequestHeader.Ptr, sRequestHeader.Len) != 0)
		return;
		
#if MEMORY_DEBUGGING	
	request->SetKeepAlive(false);//make sure to terminate this connection
	request->Write(sResponseHeader, ::strlen(sResponseHeader));
	
	//we must hold the tagQueue mutex for the duration of this exercise because
	//we don't want any of the values we are reporting to change
	OSMutexLocker locker(OS::GetTagQueueMutex());
	//write out header and total allocated memory
	char buffer[1024];
	sprintf(buffer, "<HTML><TITLE>TimeShare Debug Page</TITLE><BODY>Total dynamic memory allocated: %ld<P>List of objects:<BR>", OS::GetAllocatedMemory());
	request->Write(buffer, ::strlen(buffer));
	
	//now report the list of tags:
	for (OSQueueIter iter(OS::GetTagQueue()); !iter.IsDone(); iter.Next())
	{
		OS::TagElem* elem = (OS::TagElem*)iter.GetCurrent()->GetEnclosingObject();
		Assert(elem != NULL);
		if (elem->numObjects > 0)
		{
			sprintf(buffer, "Object name: %s, Number of currently allocated objects: %ld, Total size: %ld<BR>", elem->tag, elem->numObjects, elem->totMemory);
			request->Write(buffer, ::strlen(buffer));
		}
	}
	request->Write(sResponseEnd, ::strlen(sResponseEnd));
	request->Close();
#endif
}
