/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPTestModule.h

	Contains:	This module makes hard-coded responses to RTSP requests. This is
				VERY useful for testing the RTSP server in isolation, for you can
				throw a stress client on the RTSP server by itself to expose bugs.

	$Log: RTSPTestModule.h,v $
	Revision 1.2  1999/02/19 23:08:41  ds
	Created
	

*/

#ifndef __RTSPTESTMODULE_H__
#define __RTSPTESTMODULE_H__

#include "RTSPModule.h"


class RTSPTestModule : public RTSPModule
{
	public:
		RTSPTestModule() {}
		virtual ~RTSPTestModule() {}
		
		virtual RTSPProtocol::RTSPStatusCode ProcessRequest(RTSPRequestInterface *request);
	
	private:
	
		void DoDescribe(RTSPRequestInterface *request);
		void DoSetup(RTSPRequestInterface *request);
		void DoPlay(RTSPRequestInterface *request);
};
#endif // __RTSPTESTMODULE_H__

