/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPMessages.cpp

	Contains:	API for getting text messages displayed by the server, or
				sent over the network. This prevents any hard-coded text from
				getting in the server.
	
	$Log: RTSPMessages.cpp,v $
	Revision 1.2  1999/02/19 23:08:28  ds
	Created
	
	
*/

#include "RTSPMessages.h"

StrPtrLen RTSPMessages::sMessages[] =
{
/*0*/	StrPtrLen("No message."),
/*1*/	StrPtrLen("There was no URL contained in the following request: %s"),
/*2*/	StrPtrLen("The following RTSP method: %s, was not understood by the server."),
/*3*/	StrPtrLen("There is no RTSP version in the following request: %s"),
/*4*/	StrPtrLen("Server expected 'rtsp://' and instead received: %s"),
/*5*/	StrPtrLen("The following URL is too long to be processed by the server: %s"),
/*6*/	StrPtrLen("The following URL is not in proper URL format: %s"),
/*7*/	StrPtrLen("There was no colon after a header in the following request: %s"),
/*8*/	StrPtrLen("There was no EOL after a header in the following request: %s"),
/*9*/	StrPtrLen("No RTP module available to handle this request"),
/*10*/	StrPtrLen("No client port pair found in transport header"),
/*11*/	StrPtrLen("Reported client RTP port is not an even number"),
/*12*/	StrPtrLen("Reported client RTCP port is not one greater than RTP port"),
/*13*/	StrPtrLen("No active RTP session for that RTSP session ID"),
/*14*/	StrPtrLen("Expected a digit at the end of the following URL: %s"),
/*15*/	StrPtrLen("There is no cache file available for this track"),
/*16*/	StrPtrLen("There is no cache file header available for this track"),
/*17*/	StrPtrLen("No SDP file found for the following URL: %s"),
/*18*/	StrPtrLen("Streaming Server couldn't listen on its primary RTSP port. Quitting."),
/*19*/	StrPtrLen("Streaming Server is currently refusing new connections."),
/*20*/	StrPtrLen("Streaming Server is too busy to accept new connections."),	//too many clients
/*21*/	StrPtrLen("Streaming Server is too busy to accept new connections."),	//too much throughput
/*22*/	StrPtrLen("Streaming Server couldn't find any available UDP ports."),
/*23*/	StrPtrLen("Streaming Server couldn't bind to any UDP sockets."),
/*24*/	StrPtrLen("Streaming Server couldn't open one of its log files."),
/*25*/	StrPtrLen("Streaming Server couldn't bind one of the reflector sockets to the specified port."),
/*26*/	StrPtrLen("Streaming Server couldn't join specified multicast group."),
/*27*/	StrPtrLen("No reflector stream for that URL."),
/*28*/	StrPtrLen("Fatal error: Can't allocate Mach Ports."),
/*29*/	StrPtrLen("Fatal error: Can't register Mach Ports."),
/*30*/	StrPtrLen("Server control thread encountered a fatal error."),
/*31*/	StrPtrLen("A %s request requires a Session header."),
/*32*/	StrPtrLen("That request is too long to be processed by the server."),
/*33*/	StrPtrLen("This machine is currently not configured for IP."),
/*34*/	StrPtrLen("The specified RTSP listening IP address doesn't exist."),
/*35*/	StrPtrLen("The requested file is not a movie file."),
/*36*/	StrPtrLen("Specified trackID doesn't exist in the movie."),
/*37*/	StrPtrLen("Couldn't seek to specified time."),
/*38*/	StrPtrLen("Couldn't connect to remote status server."),
/*39*/	StrPtrLen("Fatal error: Streaming Server couldn't listen on one of the specified RTSP ports."),
/*40*/	StrPtrLen("Requested movie hasn't been hinted.")
};

StrPtrLen*		RTSPMessages::GetMessage(Message inMessage)
{
	if (inMessage < kIllegalMessage)
		return &sMessages[inMessage];
	else
		return &sMessages[kNoMessage];
}

