/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTPServer.h

	Contains:	RTPServer object is responsible for bringing up & down the RTP server.
				It allocates and destroys all server-wide resources. Its base class
				provides APIs for modules to manipulate the server. 
					
	Change History (most recent first):
	
	$Log: RTPServer.h,v $
	Revision 1.2  1999/02/19 23:08:25  ds
	Created
	

*/

#ifndef _RTPSERVER_H_
#define _RTPSERVER_H_


#include "RTPServerInterface.h"
#include "RTPModule.h"
#include "RTSPServer.h"

class RTPServer;

class RTPTotalByteUpdater : public Task
{
	private:
		//Sole purpose of this class is to run periodically and update the 64-bit
		//"real" bytecount using the 32-bit periodic byte count. It does this atomically
		//so that no byte count is lost
		RTPTotalByteUpdater(RTPServer* inServer) : Task(),
													fLastBandwidthTime(0), fLastBandwidthAvg(0),
													fLastBytesSent(0), fServer(inServer) {}
		virtual ~RTPTotalByteUpdater() {}
		
		//this function runs every so often
		virtual SInt64 Run();
		
		SInt64 fLastBandwidthTime;
		SInt64 fLastBandwidthAvg;
		SInt64 fLastBytesSent;
		RTPServer* fServer;
		
		friend class RTPServer;
};

class RTPServer : public RTPServerInterface, public RTPModuleInterface
{
	public:

		RTPServer() : fUpdater(this) {}
		virtual ~RTPServer();

		bool	Initialize(RTSPPrefs* inPrefs, UInt16 inPortOverride = 0);
		

	private:

		//Note: this is not a limit on number of sessions, just a size of the
		//hash table (577 is prime, right?)
		enum
		{
			kRTPSessionMapSize = 577	//UInt32
		};
	
		//The RTP server needs a stream control interface. This could really
		//be anything, so why not make it RTSP, and therefore re-use the RTSP code.
		//This does not preclude the option of building a standalone RTSP server,
		//because RTSP is not dependent on RTP at all.
		RTSPServer	fRTSPServer;
		RTPTotalByteUpdater fUpdater;
		IncomingRTCPDataTask fRTCPTask;
		
		//Utility functions
		bool	SetupUDPSockets();
		//requires caller to lock down the rtp session map
		RTPSession*	GetNewestSession();
		
		friend class RTPTotalByteUpdater;
};

#endif //_RTPSERVER_H_