/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTPAccessLogModule.h

	Contains:	
					
	$Log: RTPAccessLogModule.h,v $

	Created: Fri, Mar 5, 1999 @ 2:18 PM
*/

#ifndef _RTPACCESSLOGMODULE_H_
#define _RTPACCESSLOGMODULE_H_

#include "RTPModule.h"
#include "RTSPRollingLog.h"
#include "RTSPServerInterface.h"
#include "OSMutex.h"

class RTSPTransferLog;

class RTPAccessLogModule : public RTPModule
{
public:
	RTPAccessLogModule();
	virtual ~RTPAccessLogModule();
	
	virtual void	PostProcessRTSPRequest(RTSPRequestInterface* inRequest, RTPSession* inSession);
	virtual void	ProcessTimeout(RTPSession* inSession);
	void  CheckLogState(bool forceEnabled = false);

	void LogRequest(RTSPRequestInterface* inRTSPRequest, RTPSession* inRTPSession);

	static void  RollTransferLog();
	virtual bool  Initialize();
	virtual void  Shutdown();

private:

	static RTPAccessLogModule*	sLoggingModule;

	OSMutex						fLogMutex;//Log module isn't reentrant
	RTSPTransferLog*			fTransferLog;

	void GetRemoteAddr(char* outRemoteAddr, RTSPRequestInterface* inRTSPRequest, RTPSession* inRTPSession);
	Socket* GetLocalSocket(RTSPRequestInterface* inRTSPRequest, RTPSession* inRTPSession);
	void GetURL(char* outURL, UInt32 inURLLen, RTSPRequestInterface* inRTSPRequest, RTPSession* inRTPSession);
	void GetUserAgent(char* outUserAgent, UInt32 inUserAgentLen, RTSPRequestInterface* inRTSPRequest, RTPSession* inRTPSession);

};


class RTSPTransferLog : public RTSPRollingLog
{
	public:
		RTSPTransferLog() : RTSPRollingLog(true) {}
		virtual ~RTSPTransferLog() {}
	
		virtual char* GetLogName() { return RTSPServerInterface::GetRTSPPrefs()->GetTransferLogName();}
		
		virtual char* GetLogDir() 	{ return RTSPServerInterface::GetRTSPPrefs()->GetTransferLogDir();}
																				
		virtual UInt32 GetRollIntervalInDays() { return RTSPServerInterface::GetRTSPPrefs()->GetTransferRollIntervalInDays();}
											
		virtual UInt32 GetMaxLogBytes() { return RTSPServerInterface::GetRTSPPrefs()->GetMaxTransferLogBytes();}

		virtual time_t WriteLogHeader(FILE *inFile);

	
};

#endif //_RTPACCESSLOGMODULE_H_
