/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#ifndef __BOGUSDEFS_H_
#define __BOGUSDEFS_H_

#define __MW_

#ifdef __MW_

#include "unistd.h"
#include <stdio.h>
#include <time.h>
#include <cstdlib>
#define MAC

/*_________________________________________________________________________________________*/
#pragma mark __MISC__
#define	ENOBUFS	55
#define EAGAIN 35
#define SV_INTERRUPT 0x0002
#define	EINTR		4		/* Interrupted system call */
#define EBADF		9		/*bad fiel descriptor*/
#define INET_ADDRSTRLEN 16
typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;
typedef	unsigned short	ushort;		/* sys III compat */
typedef unsigned long long u_int64_t;
typedef long int32_t;
typedef u_long u_int32_t;
typedef u_char u_int8_t;
typedef signed char int8_t;
typedef u_short u_int16_t;
typedef short int16_t;
typedef long DIR;
typedef	short	dev_t;
typedef	short	gid_t;
typedef	short	uid_t;
#ifdef _NEXT_SOURCE
	typedef	u_long	ino_t;
#else
	typedef unsigned long ino_t;
#endif

#ifdef KERNEL 
	typedef	u_long	off_t;
#else
	typedef	long	off_t;
#endif /* KERNEL */
typedef int fsid_t;
typedef int	ssize_t;
typedef int	pid_t;
typedef unsigned short 	mode_t;
typedef short	nlink_t;
//typedef unsigned char Boolean;
//typedef	unsigned char	u_char;
//typedef	unsigned short	u_short;
//typedef	unsigned int	u_int;
//typedef	unsigned long	u_long;
#define IF_NAME_LEN		5
bool isspace(char);
/* major part of a device */
#define	major(x)	((int)(((unsigned)(x)>>8)&0377))
/* minor part of a device */
#define	minor(x)	((int)((x)&0377))
/* make a device number */
#define	makedev(x,y)	((dev_t)(((x)<<8) | (y)))
struct passwd	*getpwuid(uid_t);
struct passwd	*getpwnam(const char *);
struct group *getgrgid(gid_t);
struct group *getgrnam(const char *);
//int atoi(char*);

/*
 * Error codes
 */

#define	EPERM		1		/* Operation not permitted */
#define	ENOENT		2		/* No such file or directory */
#define	ESRCH		3		/* No such process */
#define	EINTR		4		/* Interrupted system call */
#define	EIO		5		/* Input/output error */
#define	ENXIO		6		/* Device not configured */
#define	E2BIG		7		/* Argument list too long */
#define	ENOEXEC		8		/* Exec format error */
#define	EBADF		9		/* Bad file descriptor */
#define	ECHILD		10		/* No child processes */
#define	EDEADLK		11		/* Resource deadlock avoided */
					/* 11 was EAGAIN */
#define	ENOMEM		12		/* Cannot allocate memory */
#define	EACCES		13		/* Permission denied */
#define	EFAULT		14		/* Bad address */
#ifndef _POSIX_SOURCE
#define	ENOTBLK		15		/* Block device required */
#endif
#define	EBUSY		16		/* Device busy */
#define	EEXIST		17		/* File exists */
#define	EXDEV		18		/* Cross-device link */
#define	ENODEV		19		/* Operation not supported by device */
#define	ENOTDIR		20		/* Not a directory */
#define	EISDIR		21		/* Is a directory */
#define	EINVAL		22		/* Invalid argument */
#define	ENFILE		23		/* Too many open files in system */
#define	EMFILE		24		/* Too many open files */
#define	ENOTTY		25		/* Inappropriate ioctl for device */
#ifndef _POSIX_SOURCE
#define	ETXTBSY		26		/* Text file busy */
#endif
#define	EFBIG		27		/* File too large */
#define	ENOSPC		28		/* No space left on device */
#define	ESPIPE		29		/* Illegal seek */
#define	EROFS		30		/* Read-only file system */
#define	EMLINK		31		/* Too many links */
#define	EPIPE		32		/* Broken pipe */

/* math software */
#define	EDOM		33		/* Numerical argument out of domain */
#define	ERANGE		34		/* Result too large */

/* non-blocking and interrupt i/o */
#define	EAGAIN		35		/* Resource temporarily unavailable */
#ifndef _POSIX_SOURCE
#define	EWOULDBLOCK	EAGAIN		/* Operation would block */
#define	EINPROGRESS	36		/* Operation now in progress */
#define	EALREADY	37		/* Operation already in progress */

/* ipc/network software -- argument errors */
#define	ENOTSOCK	38		/* Socket operation on non-socket */
#define	EDESTADDRREQ	39		/* Destination address required */
#define	EMSGSIZE	40		/* Message too long */
#define	EPROTOTYPE	41		/* Protocol wrong type for socket */
#define	ENOPROTOOPT	42		/* Protocol not available */
#define	EPROTONOSUPPORT	43		/* Protocol not supported */
#define	ESOCKTNOSUPPORT	44		/* Socket type not supported */
#define	EOPNOTSUPP	45		/* Operation not supported */
#define	EPFNOSUPPORT	46		/* Protocol family not supported */
#define	EAFNOSUPPORT	47		/* Address family not supported by protocol family */
#define	EADDRINUSE	48		/* Address already in use */
#define	EADDRNOTAVAIL	49		/* Can't assign requested address */

/* ipc/network software -- operational errors */
#define	ENETDOWN	50		/* Network is down */
#define	ENETUNREACH	51		/* Network is unreachable */
#define	ENETRESET	52		/* Network dropped connection on reset */
#define	ECONNABORTED	53		/* Software caused connection abort */
#define	ECONNRESET	54		/* Connection reset by peer */
#define	ENOBUFS		55		/* No buffer space available */
#define	EISCONN		56		/* Socket is already connected */
#define	ENOTCONN	57		/* Socket is not connected */
#define	ESHUTDOWN	58		/* Can't send after socket shutdown */
#define	ETOOMANYREFS	59		/* Too many references: can't splice */
#define	ETIMEDOUT	60		/* Operation timed out */
#define	ECONNREFUSED	61		/* Connection refused */

#define	ELOOP		62		/* Too many levels of symbolic links */
#endif /* _POSIX_SOURCE */
#define	ENAMETOOLONG	63		/* File name too long */

/* should be rearranged */
#ifndef _POSIX_SOURCE
#define	EHOSTDOWN	64		/* Host is down */
#define	EHOSTUNREACH	65		/* No route to host */
#endif /* _POSIX_SOURCE */
#define	ENOTEMPTY	66		/* Directory not empty */

/* quotas & mush */
#ifndef _POSIX_SOURCE
#define	EPROCLIM	67		/* Too many processes */
#define	EUSERS		68		/* Too many users */
#define	EDQUOT		69		/* Disc quota exceeded */

/* Network File System */
#define	ESTALE		70		/* Stale NFS file handle */
#define	EREMOTE		71		/* Too many levels of remote in path */
#define	EBADRPC		72		/* RPC struct is bad */
#define	ERPCMISMATCH	73		/* RPC version wrong */
#define	EPROGUNAVAIL	74		/* RPC prog. not avail */
#define	EPROGMISMATCH	75		/* Program version wrong */
#define	EPROCUNAVAIL	76		/* Bad procedure for program */
#endif /* _POSIX_SOURCE */

#define	ENOLCK		77		/* No locks available */
#define	ENOSYS		78		/* Function not implemented */


/*__________________________________________________________________________________*/
#pragma mark __IPC__
typedef int kern_return_t;
typedef char boolean_t;
typedef int port_t;
#define KERN_SUCCESS 0
#define KERN_FAILURE 5
#define MSG_OPTION_NONE 0
#define BOOTSTRAP_UNKNOWN_SERVICE 0
kern_return_t port_allocate(int, port_t*);
kern_return_t port_deallocate(int, port_t);
unsigned int task_self();
kern_return_t bootstrap_register(port_t, char*, port_t);
kern_return_t bootstrap_create_service(port_t, char*, port_t*);
kern_return_t bootstrap_check_in(port_t, char*, port_t*);
kern_return_t bootstrap_look_up(port_t, char*, port_t*);
extern port_t bootstrap_port;
typedef	struct {
		char msg_simple;
		int	msg_size;
		int	msg_type;
		port_t		msg_local_port;
		port_t		msg_remote_port;
		int	msg_id;
} msg_header_t;
kern_return_t msg_receive(msg_header_t*, int, int);
kern_return_t msg_send(msg_header_t*, int, int);
kern_return_t SCRPI_server(msg_header_t*, msg_header_t*);
kern_return_t QTSCRPI_server(msg_header_t*, msg_header_t*);


#define TRUE 1
#define MSG_TYPE_NORMAL		0
#define MSG_TYPE_EMERGENCY	1
#define PORT_NULL 0
#define SEND_TIMEOUT 0

/*_____________________________________________________________________*/
#pragma mark __TIME__
struct timespec {
	long ts_sec;
	long ts_nsec;
};
#if 0
#ifndef _TIME_T
	#define _TIME_T
	typedef	long	time_t;
#endif /* _TIME_T */

typedef unsigned long clock_t;
typedef struct tms
{
	clock_t tms_utime;
	clock_t tms_stime;
	clock_t tms_cutime;
	clock_t tms_sctime;
} tms;
#endif
clock_t time(clock_t*);
//char* ctime (time_t *);

struct timeval {
	int32_t	tv_sec;		/* seconds */
	int32_t	tv_usec;	/* and microseconds */
};
struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
	long	ru_maxrss;		/* max resident set size */
#define	ru_first	ru_ixrss
	long	ru_ixrss;		/* integral shared memory size */
	long	ru_idrss;		/* integral unshared data " */
	long	ru_isrss;		/* integral unshared stack " */
	long	ru_minflt;		/* page reclaims */
	long	ru_majflt;		/* page faults */
	long	ru_nswap;		/* swaps */
	long	ru_inblock;		/* block input operations */
	long	ru_oublock;		/* block output operations */
	long	ru_msgsnd;		/* messages sent */
	long	ru_msgrcv;		/* messages received */
	long	ru_nsignals;		/* signals received */
	long	ru_nvcsw;		/* voluntary context switches */
	long	ru_nivcsw;		/* involuntary " */
#define	ru_last		ru_nivcsw
};
#define	RUSAGE_SELF	0
#define	RUSAGE_CHILDREN	-1
int	getrusage (int, struct rusage *);
#define RCV_TIMEOUT 0

#define CPU_STATE_MAX 5
#define CPU_STATE_IDLE 0
#define CPU_STATE_USER 1
#define CPU_STATE_SYSTEM 2

typedef struct machine_slot
{
	int aslot;
	int is_cpu;
	long* cpu_ticks;
} machine_slot;

typedef struct machine_info
{
	int max_cpus;
	int major_version;
	int minor_version;
} machine_info;

int getloadavg(double*, int);

void* current_task();
kern_return_t xxx_slot_info(void *, int, struct machine_slot*);
kern_return_t xxx_host_info(void *, struct machine_info*);



/*__________________________________________________________________________________*/
#pragma mark __THREADS__
#define THREAD_BASIC_INFO_COUNT 1
#define THREAD_BASIC_INFO 1
typedef unsigned long any_t;
typedef void * cthread_fn_t;
typedef unsigned long cthread_t;
typedef unsigned long thread_t;
typedef unsigned long time_value_t;
typedef void* vm_address_t;
const any_t THREAD_NULL = 0;
const any_t SWITCH_OPTION_WAIT = 1;
const any_t SWITCH_OPTION_DEPRESS = 1;
typedef thread_t* thread_array_t;
typedef struct thread_basic_info
{
	time_value_t user_time;
	time_value_t system_time;
	int	cpu_usage;
	int base_priority;
	int cur_priority;
	int run_state;
	int flags;
	int suspend_count;
	long sleep_time;

}* thread_basic_info_t;
typedef struct cthread_queue
 {
	struct cthread_queue_item *head;
	struct cthread_queue_item *tail;
} *cthread_queue_t;
typedef struct cthread_queue_item 
{
	struct cthread_queue_item *next;
} *cthread_queue_item_t;
typedef thread_basic_info_t thread_info_t;
void cthread_set_data(cthread_t , any_t);
kern_return_t cthread_abort(cthread_t);
cthread_t cthread_self();
any_t cthread_fork(cthread_fn_t, any_t);
char* cthread_name(cthread_t);
cthread_t cthread_set_name(cthread_t, char *);
void cthread_detach(any_t);
any_t cthread_data(cthread_t);
void thread_switch(any_t, any_t, any_t);
any_t cthread_join(cthread_t);
void cthread_yield();
int cthread_errno();
kern_return_t thread_info(thread_t, int, thread_info_t, unsigned int*);
kern_return_t task_threads(unsigned int, thread_array_t*, unsigned int*);
kern_return_t vm_deallocate(unsigned int, unsigned int, unsigned int);
cthread_t cthread_thread(cthread_t);
void thread_suspend(cthread_t);
kern_return_t thread_resume(cthread_t);



/*__________________________________________________________________________________*/
#pragma mark __MUTEX__
typedef struct mutex {
	int lock;
	char *name;
} *mutex_t;
mutex_t mutex_alloc();
void mutex_free(mutex_t x);
void mutex_lock(mutex_t);
bool mutex_try_lock(mutex_t);
void mutex_unlock(mutex_t);


/*_______________________________________________________________________________________*/
#pragma mark __CONDITION__
typedef struct condition
{
	int lock;
	struct cthread_queue queue;
	char* name;
	
}* condition_t;
condition_t condition_alloc(void);
void condition_free(condition_t);
void condition_wait(condition_t,  mutex_t);
void condition_signal(condition_t);
void condition_broadcast(condition_t);


/*_______________________________________________________________________________________*/
#pragma mark __NET__
#define	AF_APPLETALK	16
#define	AF_INET		2	
#define	PF_APPLETALK	AF_APPLETALK
#define	PF_INET		AF_INET
#define	IPPROTO_IP	2
#define	IP_RECVDSTADDR	2
#define	IP_ADD_MEMBERSHIP	3
#define	IP_DROP_MEMBERSHIP	3
#define	IP_MULTICAST_TTL	3
#define	SOCK_DGRAM	2
#define SOCK_STREAM  1
#define SOL_SOCKET  0xffff
#define SO_KEEPALIVE  0xffd0
#define SO_REUSEADDR  0x0004
#define INADDR_ANY  (u_long)0x00000000
#define MAXHOSTNAMELEN	256
#define	O_NONBLOCK	0x0004
#define	FNDELAY		O_NONBLOCK
#define	F_SETFL		4	
struct iovec
{
	void* iov_base;
	unsigned long iov_len;
	int x;
};
struct cmsghdr {
	u_int	cmsg_len;		/* data byte count, including hdr */
	int	cmsg_level;		/* originating protocol */
	int	cmsg_type;		/* protocol-specific type */
/* followed by	u_char  cmsg_data[]; */
};
struct msghdr {
	void*	msg_name;		/* optional address */
	u_int	msg_namelen;		/* size of address */
	struct	iovec *msg_iov;		/* scatter/gather array */
	u_int	msg_iovlen;		/* # elements in msg_iov */
	void*	msg_control;		/* ancillary data, see below */
	u_int	msg_controllen;		/* ancillary data buffer len */
	int	msg_flags;		/* flags on received message */
};
int recvmsg(int sockfd, struct msghdr* msg, int flags);

struct cmsghdr* CMSG_FIRSTHDR(struct msghdr* blah);
struct cmsghdr* CMSG_NXTHDR(struct msghdr* blah, struct cmsghdr* blaze);
unsigned char* CMSG_DATA(struct cmsghdr*blah);
struct sockaddr
{
	unsigned short 	sa_family;
	char			sa_data[14];
	int				sa_len;
};

int daemon (int, int);
int wait(int*);
struct in_addr
{
	unsigned long s_addr;
};
struct sockaddr_in
{
	short 		sin_family;
	unsigned short 	sin_port;
	struct in_addr	sin_addr;
	char			sin_zero[8];
};
typedef struct	hostent {
	char	*h_name;	/* official name of host */
	char	**h_aliases;	/* alias list */
	int	h_addrtype;	/* host address type */
	int	h_length;	/* length of address */
	char	**h_addr_list;	/* list of addresses from name server */
#define	h_addr	h_addr_list[0]	/* address, for backward compatiblity */
}hostent;
struct	protoent {
	char	*p_name;
	char	**p_aliases;
	int	p_proto;
};

struct utsname {
	char sysname[10];
	char nodename[10];
};

int uname(struct utsname* name);


ssize_t	recv (int, void *, size_t, int);
ssize_t	send (int, const void *, size_t, int);
int socket(int, int, int);
int accept(int, struct sockaddr * , int*);
struct protoent	*getprotobyname (const char *);
int setsockopt(int, int, int, char *, int);
int	getpeername (int, struct sockaddr *, int *);
int bind(int, struct sockaddr *, int);
int inet_aton (const char *, struct in_addr *);
int connect(int ,  struct sockaddr *, int);
int listen(int, int);
int writev(int, const struct iovec[], int);
int readv(int, struct iovec[], int);
int ioctl(int, unsigned long, char*);
hostent* gethostbyname(char *);
int signal(int, void *);
int siginterrupt(int, int);
int	fcntl (int, int, ...);
//int ioctl(int, unsigned long, int*);
int getsockname(int, struct sockaddr*,  int*);
char * inet_ntoa(struct in_addr);
int close(int);
int gethostname(char*, int);
//long ntohl(long);
//long htonl(long);
//short ntohs(short);
//short htons(short);
void bzero (void *, size_t);
ssize_t	recvfrom (int, void *, size_t, int, struct sockaddr *, int *);
ssize_t	sendto (int, const void *, size_t, int, const struct sockaddr *, int);
int	 getopt (int, char * const [], const char *);
const char* inet_ntop(int family, const void* addrptr, char* strptr, size_t len);
struct hostent* gethostbyaddr(const char* addr, size_t len, int family);

extern int errno;




/*_________________________________________________________________________________________*/
#pragma mark __SIGNAL__
#define SIGIO 23
#define SIGWINCH 28
#define SIGPIPE 13
#define SIGABRT 6
#define	SIG_IGN		(void (*)())1
typedef unsigned int sigset_t;
typedef struct sigcontext{int x;}sigcontext;
struct	sigaction {
	void	(*sa_handler)();	/* signal handler */
	sigset_t sa_mask;		/* signal mask to apply */
	int	sa_flags;		/* see signal options below */
};
struct	sigvec {
	void	(*sv_handler)();	/* signal handler */
	int	sv_mask;		/* signal mask to apply */
	int	sv_flags;		/* see signal options below */
};
int sigvec(int, void *, void *);
int sigaction(int, sigaction *, sigaction *);
void sigusr2_handler(void);


/*_________________________________________________________________________________________*/
#pragma mark __SELECT__
#define	FD_SETSIZE	256
#define	NBBY	8		/* number of bits in a byte */
typedef unsigned long fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */
#ifndef howmany
#define	howmany(x, y)	(((x) + ((y) - 1)) / (y))
#endif
typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define	FD_COPY(f, t)	bcopy(f, t, sizeof(*(f)))
#define FD_ZERO(p) memset(p, 0, sizeof(*(p)))
#define F_SETFD 1
#define FD_CLOEXEC 1
#define F_GETFL 1
//int select(int a , fd_set* b , fd_set*  c , fd_set* d , timeval* e);



/*_________________________________________________________________________________________*/
#pragma mark __APPLETALK__
#define ASPERR_NoError         0
#define ASPERR_NoSuchDevice    -1058
#define ASPERR_BindErr         -1059
#define ASPERR_CmdReply        -1060
#define ASPERR_CmdRequest      -1061
#define ASPERR_SystemErr       -1062
#define ASPERR_ProtoErr        -1063
#define ASPERR_NoSuchEntity    -1064
#define ASPERR_RegisterErr     -1065
#define ASPERR_BadVersNum      -1066
#define ASPERR_BufTooSmall     -1067
#define ASPERR_NoMoreSessions  -1068
#define ASPERR_NoServers       -1069
#define ASPERR_ParamErr        -1070
#define ASPERR_ServerBusy      -1071
#define ASPERR_SessClosed      -1072
#define ASPERR_SizeErr         -1073
#define ASPERR_TooManyClients  -1074
#define ASPERR_NoAck           -1075
#define ASPFUNC_Write         6
#define	MSG_PEEK	0x2		/* peek at incoming message */
#define	MSG_EOR		0x8		/* data completes record */
#define NBP_NVE_STR_SIZE	32
#define NBP_TUPLE_SIZE	((3*NBP_NVE_STR_SIZE)+3) /* 3 for field lengths + 3*32 for three names */
#define NBP_TUPLE_MAX	15	/* Maximum number of tuples in one DDP packet */
#define	NBP_HDR_SIZE	2
typedef u_char ua_short[2];		/* Unaligned short */
typedef u_char ua_long[4];		/* Unaligned long */
typedef u_short at_net_al;		/* Aligned AppleTalk network number */
typedef ua_short at_net_unal;		/* Unaligned AppleTalk network number */
typedef at_net_unal at_net;		/* Default: Unaligned AppleTalk network number */
typedef u_char	at_node;		/* AppleTalk node number */
typedef u_char  at_socket;		/* AppleTalk socket number */
typedef struct at_inet {
    at_net	net;			/* Network Address */
    at_node	node;			/* Node number */
    at_socket	socket;			/* Socket number */
} at_inet_t;
typedef struct at_retry {
    short	interval;		/* Retry interval in seconds */
    short	retries;		/* Maximum number of retries */
    u_char      backoff;                /* Retry backoff, must be 1 through 4 */
} at_retry_t;

struct atalk_addr {
	u_char	atalk_unused;
	at_net	atalk_net;
	at_node	atalk_node;
};
typedef struct at_nvestr {
	u_char		len;
	u_char		str[NBP_NVE_STR_SIZE];
} at_nvestr_t;
typedef struct at_entity {
	at_nvestr_t	object;
	at_nvestr_t	type;
	at_nvestr_t	zone;
} at_entity_t;

typedef struct at_nbptuple {
	at_inet_t	enu_addr;
	union {
	  struct {
            u_char	enumerator;
	    at_entity_t entity;
	  } en_se;
	  struct {
            u_char	enumerator;
            u_char	name[NBP_TUPLE_SIZE];
	  } en_sn;
	} en_u;
} at_nbptuple_t;
typedef struct at_nbp {
        unsigned      	control : 4,
        	      	tuple_count : 4;
        u_char      	id;
	at_nbptuple_t	tuple[NBP_TUPLE_MAX];
} at_nbp_t;

//extern int SPInit(at_inet_t*, char*, int, int*, OSErr*);
//extern int SPRegister(at_entity_t*, at_retry_t*, at_inet_t*, OSErr*);
//extern int SPGetSession(int, int*, OSErr*);
//extern int SPLook(int, OSErr*);
//extern int nbp_make_entity(at_entity*, char*, char*, char*); 
//extern int SPGetReply(int , char* , int , int* , int*, OSErr*);
//extern int SPGetRequest(int , char* , int , unsigned short* , int*, int*, OSErr*);
//extern int SPGetRemEntity(int, void*, OSErr*);
//extern int SPLook(int, OSErr*);
//extern int SPGetProtoFamily(int, int*, OSErr*);
//extern int SPCloseSession(int, OSErr*);
//extern int SPCmdReply(int, int, int, char*, int, OSErr*);
//extern int SPAttention(int, int, OSErr*, int);
//extern int SPWrtContinue(int, int, char*, int, int*, OSErr*, int);
//extern int SPWrtReply(int, int, int, char*, int, OSErr*);
//extern int SPRemove(at_entity_t*, at_inet_t*, OSErr*);
//extern int SPGetParms(int*, int*, int);
//extern void SPConfigure(int, int, at_retry_t*);
//extern int XPGetRefNum(int SLSRefNum, int *RefNum, int *RefNumCnt, OSErr *SPError);
//extern int SPEnableSelect(int SessRefNum, OSErr *SPError);



/*_______________________________________________________________________________________*/
#pragma mark __FILE__

#define kHFSDataForkName "data"
#define kHFSResourceForkName "rsrc"
#define	O_RDONLY	0x0000		/* open for reading only */
#define	O_WRONLY	0x0001		/* open for writing only */
#define	O_RDWR		0x0002		/* open for reading and writing */
#define	O_ACCMODE	0x0003		/* mask for above modes */
#define	O_CREAT		0x0200		/* create if nonexistant */
#define	O_TRUNC		0x0400		/* truncate to zero length */
struct	stat
{
	dev_t	st_dev;		/* File device number */
	ino_t	st_ino;		/* File serial number */
	unsigned short st_mode;	
	short st_nlink;	
	uid_t	st_uid;		/* File owner's user ID */
	gid_t	st_gid;		/* File owner's group ID */
	dev_t	st_rdev;
	off_t	st_size;	/* File size in bytes */
				/* (for regular file only) */
	time_t	st_atime;	/* Time of last file access */
	int	st_spare1;
	time_t	st_mtime;	/* Time of last file */
				/* modification */
	int	st_spare2;
	time_t	st_ctime;	/* Time of last file status */
				/* change */
	int	st_spare3;
	long	st_blksize;
	long	st_blocks;
	long	st_spare4[2];
};
struct	dirent 
{
	long   d_off;			/* offset of next */
						/* disk directory */
						/* entry */
	unsigned long	d_fileno;	/* file number of */
						/* entry */
	unsigned short	d_reclen;	/* length of this */
						/* record */
	unsigned short	d_namlen;	/* length of string */
						/* in d_name */
	char	d_name[500];		/* name (up to */
	
	int d_ino;
};

#define S_IFMT 1
#define S_IFDIR 1

struct timezone
{
	int tz_minuteswest;
	int bar;
};

struct ip_mreq {
	struct	in_addr imr_multiaddr;	/* IP multicast address of group */
	struct	in_addr imr_interface;	/* local IP address of interface */
};


int gettimeofday(struct timeval* tv, struct timezone *tz);

int watchevent(struct eventreq* a, int b);
int waitevent(struct eventreq* a, int b);
int modwatch(struct eventreq* a, int b);
int startevents();
int removeevent(int fd);

void terminate();


struct eventreq {
  int      er_type;
#define EV_FD 1    // file descriptor
  int      er_handle;
  void    *er_data;
  int      er_rcnt;
  int      er_wcnt;
  int      er_ecnt;
  int      er_eventbits;
#define EV_RE  1
#define EV_WR  2
#define EV_EX  4
#define EV_RM  8
};

/*
struct stat {
	long st_ino;
	long st_size;
	long st_mode;
	long st_uid;
	long st_gid;
};
*/
enum {
	S_IRUSR = 1,
	S_IWUSR = 2,
	S_IXUSR = 4,

	S_IRGRP = 8,
	S_IWGRP = 16,
	S_IXGRP = 32,

	S_IROTH = 64,
	S_IWOTH = 128,
	S_IXOTH = 257
};
#define S_ISDIR(x) 1 

struct passwd {
	char	*pw_name;		/* user name */
	char	*pw_passwd;		/* encrypted password */
	int	pw_uid;			/* user uid */
	int	pw_gid;			/* user gid */
	time_t	pw_change;		/* password change time */
	char	*pw_class;		/* user access class */
	char	*pw_gecos;		/* Honeywell login info */
	char	*pw_dir;		/* home directory */
	char	*pw_shell;		/* default shell */
	time_t	pw_expire;		/* account expiration */
};

struct group {
	char	*gr_name;		/* group name */
	char	*gr_passwd;		/* group password */
	int	gr_gid;			/* group id */
	char	**gr_mem;		/* group members */
};
int stat(const char*, struct stat*);
int fstat(int, struct stat*);
//typedef long DIR;
DIR* opendir(char*);
int mkdir(char*, long);
//int rmdir(char*);
struct dirent* readdir(DIR*);
int closedir(DIR*);
//int unlink(char* path);
int truncate(char* path, int length);
FILE* fdopen(int, char*);
int ftruncate(int fd, int length);
int pipe(int*);
int dup(int);
int fork(void);
int setsid(void);
void umask(int);
unsigned long	 inet_addr (const char *);


#define IPPROTO_TCP 0
#define TCP_NODELAY 0

struct radvisory {
       off_t   ra_offset;
       int     ra_count;
};


#define S_IRWXU 0
#define RLIMIT_NOFILE 1
#define O_NO_MFS 0
#define F_RDAHEAD 0
#define F_RDADVISE 0

typedef struct rlimit {
	short rlim_cur;
	short rlim_max;
} rlimit;

void setrlimit(int, struct rlimit *);

int open(char*, int);

#define RCV_INVALID_PORT -202

//void	exit(int);

typedef u_int32_t script_encoding_t;

typedef u_int32_t fsobj_type_t;

typedef u_int32_t fsobj_tag_t;

typedef u_int32_t fsfile_type_t;

typedef u_int32_t fsvolid_t;

typedef struct fsobj_id {
	u_int32_t		fid_objno;
	u_int32_t		fid_generation;
} fsobj_id_t;

typedef u_int32_t attrgroup_t;

struct attrlist {
	u_short bitmapcount;			/* number of attr. bit sets in list (should be 5) */
	u_int16_t reserved;				/* (to maintain 4-byte alignment) */
	attrgroup_t commonattr;			/* common attribute group */
	attrgroup_t volattr;			/* Volume attribute group */
	attrgroup_t dirattr;			/* directory attribute group */
	attrgroup_t fileattr;			/* file attribute group */
	attrgroup_t forkattr;			/* fork attribute group */
};

typedef struct attrreference {
	long attr_dataoffset;
	size_t attr_length;
} attrreference_t;

/* XXX PPD This is derived from HFSVolumePriv.h and should perhaps be referenced from there? */

struct diskextent {
	u_int32_t					startblock;				/* first block allocated */
	u_int32_t					blockcount;				/* number of blocks allocated */
};

typedef struct diskextent extentrecord[8];

#define ATTR_BIT_MAP_COUNT 5

#define ATTR_CMN_NAME				0x00000001
#define ATTR_CMN_DEVID				0x00000002
#define ATTR_CMN_FSID				0x00000004
#define ATTR_CMN_OBJTYPE			0x00000008
#define ATTR_CMN_OBJTAG				0x00000010
#define ATTR_CMN_OBJID				0x00000020
#define ATTR_CMN_OBJPERMANENTID		0x00000040
#define ATTR_CMN_PAROBJID			0x00000080
#define ATTR_CMN_SCRIPT				0x00000100
#define ATTR_CMN_CRTIME				0x00000200
#define ATTR_CMN_MODTIME			0x00000400
#define ATTR_CMN_CHGTIME			0x00000800
#define ATTR_CMN_ACCTIME			0x00001000
#define ATTR_CMN_BKUPTIME			0x00002000
#define ATTR_CMN_FNDRINFO			0x00004000
#define ATTR_CMN_OWNERID			0x00008000
#define ATTR_CMN_GRPID				0x00010000
#define ATTR_CMN_ACCESSMASK			0x00020000
#define ATTR_CMN_FLAGS				0x00040000
#define ATTR_CMN_NAMEDATTRCOUNT		0x00080000
#define ATTR_CMN_NAMEDATTRLIST		0x00100000

#define ATTR_CMN_VALIDMASK			0x001FFFFF
#define ATTR_CMN_SETMASK			0x0003FF00
#define ATTR_CMN_VOLSETMASK                     0x00006700

#define ATTR_VOL_FSTYPE				0x00000001
#define ATTR_VOL_SIGNATURE			0x00000002
#define ATTR_VOL_SIZE				0x00000004
#define ATTR_VOL_SPACEFREE			0x00000008
#define ATTR_VOL_SPACEAVAIL			0x00000010
#define ATTR_VOL_MINALLOCATION		0x00000020
#define ATTR_VOL_ALLOCATIONCLUMP	0x00000040
#define ATTR_VOL_IOBLOCKSIZE		0x00000080
#define ATTR_VOL_OBJCOUNT			0x00000100
#define ATTR_VOL_FILECOUNT			0x00000200
#define ATTR_VOL_DIRCOUNT			0x00000400
#define ATTR_VOL_MAXOBJCOUNT		0x00000800
#define ATTR_VOL_MOUNTPOINT			0x00001000
#define ATTR_VOL_NAME				0x00002000
#define ATTR_VOL_INFO				0x80000000

#define ATTR_VOL_VALIDMASK			0x80003FFF
#define ATTR_VOL_SETMASK			0x80002000


/* File/directory attributes: */
#define ATTR_DIR_LINKCOUNT			0x00000001
#define ATTR_DIR_ENTRYCOUNT			0x00000002

#define ATTR_DIR_VALIDMASK			0x00000003
#define ATTR_DIR_SETMASK			0x00000000

#define ATTR_FILE_LINKCOUNT			0x00000001
#define ATTR_FILE_TOTALSIZE			0x00000002
#define ATTR_FILE_ALLOCSIZE			0x00000004
#define ATTR_FILE_IOBLOCKSIZE		0x00000008
#define ATTR_FILE_CLUMPSIZE			0x00000010
#define ATTR_FILE_DEVTYPE			0x00000020
#define ATTR_FILE_FILETYPE			0x00000040
#define ATTR_FILE_FORKCOUNT			0x00000080
#define ATTR_FILE_FORKLIST			0x00000100
#define ATTR_FILE_DATALENGTH		0x00000200
#define ATTR_FILE_DATAALLOCSIZE		0x00000400
#define ATTR_FILE_DATAEXTENTS		0x00000800
#define ATTR_FILE_RSRCLENGTH		0x00001000
#define ATTR_FILE_RSRCALLOCSIZE		0x00002000
#define ATTR_FILE_RSRCEXTENTS		0x00004000

#define ATTR_FILE_VALIDMASK			0x00007FFF
#define ATTR_FILE_SETMASK			0x00000020

#define ATTR_FORK_TOTALSIZE			0x00000001
#define ATTR_FORK_ALLOCSIZE			0x00000002

#define ATTR_FORK_VALIDMASK			0x00000003
#define ATTR_FORK_SETMASK			0x00000000

struct fullvolumeattrblock {
	u_int32_t			fstype;
	u_int32_t			signature;
	off_t				size;
	off_t				spacefree;
	off_t				spaceavail;
	off_t				minallocation;
	off_t				allocationclump;
	size_t				ioblocksize;
	u_int32_t			objcount;
	u_int32_t			filecount;
	u_int32_t			dircount;
	u_int32_t			maxobjcount;
	attrreference_t		mountpoint;
};

struct fulldirattrblock {
	u_int32_t			linkcount;
	u_int32_t			entrycount;
};

struct fullfileattrblock {
	u_int32_t			linkcount;
	off_t				totalsize;
	off_t				allocatedsize;
	size_t				ioblocksize;
	size_t				clumpsize;
	u_int32_t			devtype;
	u_int32_t			filetype;
	u_int32_t			forkcount;
	attrreference_t		forklist;
	off_t				dataforklength;
	off_t				dataforkallocated;
	extentrecord		dataextents;
	off_t				rsrcforklength;
	off_t				rsrforkallocated;
	extentrecord		rsrcextents;
	u_int32_t			entrycount;
	dev_t				devicetype;
};

struct fullforkattrblock {
	off_t				totalsize;
	off_t				allocatedsize;
};


#define SRCHFS_START 					0x00000001
#define SRCHFS_MATCHPARTIALNAMES 		0x00000002
#define SRCHFS_MATCHDIRS 				0x00000004
#define SRCHFS_MATCHFILES 				0x00000008
#define SRCHFS_NEGATEPARAMS 			0x80000000
#define SRCHFS_VALIDOPTIONSMASK			0x8000000F

struct fssearchblock {
	struct attrlist		*returnattrs;
	void				*returnbuffer;
	size_t				returnbuffersize;
	u_long				maxmatches;
	struct timeval		timelimit;
	void				*searchparams1;
	size_t				sizeofsearchparams1;
	void				*searchparams2;
	size_t				sizeofsearchparams2;
	struct attrlist		searchattrs;
};


struct searchstate {
	u_char				reserved[556];		//	sizeof( SearchState )
};



#define FST_EOF (-1)				/* end-of-file offset */

#define kHFSDataForkName "data"
#define kHFSResourceForkName "rsrc"

#define kReturnObjectName			0x00000001
#define kDontResolveAliases			0x00000002
#define kDontResolveSymlinks		0x00000004
#define kDontTranslateSeparators	0x00000008
#define kContiguous			0x00000010
#define kAllOrNothing			0x00000020
#define kOpenReadOnly				0x00000040

// ************************************ T Y P E D E F S ************************************


/* Data structures for the return of object information: */

struct CommonAttributeInfo
{
    short				objectType;
    dev_t				device;
    u_long				nameEncoding;
    u_long				objectID;
    u_long				instance;
    u_long				parentDirID;
    uid_t				uid;
    gid_t				gid;
    mode_t				mode;
    nlink_t				nlink;
    u_long				finderInfo[8];
    struct timespec		creationTime;
    struct timespec		lastModificationTime;
    struct timespec		lastBackupTime;
    struct timespec		lastChangeTime;
};

struct DirectoryAttributeInfo
{
    u_long			numEntries;
};

struct FileAttributeInfo
{
    off_t			totalSize;		/* size of all forks, in blocks */
    u_long			blockSize;		/* Optimal file I/O blocksize */
    u_long			numForks;		/* Number of forks in the file */
    u_long			attributes;		/* See IM:Files 2-100 */
    off_t			dataLogicalLength;
    off_t			dataPhysicalLength;
    off_t			resourceLogicalLength;
    off_t			resourcePhysicalLength;
    dev_t			deviceType;
};

typedef struct CatalogAttributeInfo
{
    attrgroup_t					commonBitmap;
    attrgroup_t					fileBitmap;
    attrgroup_t					directoryBitmap;
    struct CommonAttributeInfo 	c;
    struct DirectoryAttributeInfo d;
    struct FileAttributeInfo	f;
} CatalogAttributeInfo, *CatalogAttributeInfoPtr;

typedef struct SearchParam
{
	CatalogAttributeInfoPtr searchInfo1;			// I - values and lower bounds
	CatalogAttributeInfoPtr searchInfo2;			// I - masks and upper bounds
	char			*targetNameString;
	size_t			bufferSize;
	void			*buffer;
	u_long			numFoundMatches;
	u_long			maxMatches;
	u_long			nameEncoding;
	u_long			timeLimit;				// I - max time to search
	struct searchstate	state;
} SearchParam, *SearchParamPtr;

typedef struct SearchInfoReturn
{
	u_long					size;
	CatalogAttributeInfo	ci;
	char					*name;
} SearchInfoReturn, *SearchInfoReturnPtr;

typedef struct VolumeAttributeInfo
{
    attrgroup_t			commonBitmap;
    attrgroup_t			volumeBitmap;
    fsvolid_t			volumeID;			// fill in later		
    u_char				name[512];			// Up to 255 Unicode chars 	
    u_long				nameEncoding;		// fill in later
    struct timespec		creationDate;		// fill in later
    struct timespec		lastModDate;		// fill in later
    struct timespec		lastBackupDate;		// fill in later
    u_long				attributes;			// See IM:Files 2-148
    u_long				numAllocBlocks;		// fill in later
    u_long				allocBlockSize;		// fill in later
    u_long				nextItemID;			// Next Dir or file ID
    u_long				numUnusedBlocks;	// fill in later
    u_long				signature;			// fill in later
    u_long				numFiles;			// Total number on volume
    u_long				numDirectories;		// Total number on volume
    u_long				finderInfo[8];		// fill in later
} VolumeAttributeInfo, *VolumeAttributeInfoPtr;

typedef struct VDISpec
{
    fsvolid_t			volID;
    u_long				dirID;
    u_char				name[512];			// Up to 255 Unicode chars 	
} VDISpec, *VDISpecPtr;

/* pointer to array of VDISpecs */
typedef VDISpecPtr VDIArrayPtr;

// *********************************** P R O T O T Y P E S ***********************************

int CancelChangeNotify_VDI 	(	fsvolid_t theVolID,
                              	u_long theDirID,
                                u_long theOptions,
                                port_t theNotifyPort );

int UserAccess_VDI 	(			fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theNamePtr,
                                u_long nameEncoding,
                                u_long theOptions,
                                uid_t theUserID,
								gid_t *theGroupList,
								int nGroups,
                                u_long theAccessRequired );

int Create_VDI 				(	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theFileNamePtr,
                                u_long nameEncoding,
                                u_long theOptions,
                                mode_t theMode );

int CreateLink_VDI 			( 	fsvolid_t theVolID,
                                u_long theNewDirID,
                                const char *theNewNamePtr,
                                u_long nameEncoding,
                                u_long theTargetDirID,
                                const char *theTargetNamePtr,
                                u_long theOptions );

int DirectoryChangeNotify_VDI (	fsvolid_t theVolID,
                                u_long theDirID,
                                u_long theOptions,
                                port_t theNotifyPort,
                                struct timespec *theLastModDatePtr );

int ExchangeFiles_VDI		( 	fsvolid_t theVolID,
                                u_long theDirID1,
                                const char *theName1Ptr,
                                u_long nameEncoding,
                                u_long theDirID2,
                                const char *theName2Ptr,
                                u_long theOptions );

int ForkReserveSpace		( 	int theFD,
                                off_t theReservationSize,
                                u_long theOptions,
                                off_t *theSpaceAvailablePtr );

int GetCatalogInfo			(	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theItemNamePtr,
                                u_long nameEncoding,
                                u_long theOptions,
                                CatalogAttributeInfoPtr theCatInfoPtr,
                                void* nameBuffer,
                                size_t nameBufferSize );

int GetDirEntryAttr			(	void );

int GetNamedAttribute		(	fsvolid_t theVolID,
                                u_long theItemID,
                                u_long theOptions,
                                const char *theAttributeNamePtr,
                                size_t theAttributeNameLength,
                                void *theBufferPtr,
                                size_t theBufferSize,
                                size_t *theSizeReturnedPtr );

int GetVolumeInfo			(	long theVolumeIndex,
                                fsvolid_t theVolID,
                                const char *theVolumeNamePtr,
                                u_long nameEncoding,
                                u_long theOptions,
                                VolumeAttributeInfoPtr theInfoPtr );

int MakeDir_VDI				(	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theDirNamePtr,
                                u_long nameEncoding,
                                u_long theOptions,
                                mode_t theMode );

DIR *OpenDir_VDI			(	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theNamePtr,
                                u_long nameEncoding,
                                u_long theOptions );

int OpenFork_VDI			( 	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theNamePtr,
                                u_long nameEncoding,
                                const char *theForkNamePtr,
                                u_long theOptions );

int Remove_VDI				(	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theFileNamePtr,
                                u_long nameEncoding,
                                u_long theOptions );

int RemoveDir_VDI			(	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theNamePtr,
                                u_long nameEncoding,
                                u_long theOptions );

int Rename_VDI				(	fsvolid_t theVolID,
                                u_long theOldDirID,
                                const char *theOldNamePtr,
                                u_long nameEncoding,
                                u_long theNewDirID,
                                const char *theNewNamePtr,
                                u_long theOptions );

int CreateFileID_VDI		(	fsvolid_t theVolID,
								u_long theDirID,
								const char *theNamePtr,
								u_long nameEncoding,
                                u_long theOptions,
								u_long *theFileIDPtr );
								
int ResolveFileID			(	fsvolid_t theVolID,
                                u_long theFileID,
                                u_long nameEncoding,
                                u_long *theDirIDPtr,
                                char *theFileNamePtr,
                                u_long *theOrigNameEncodingPtr );

int SearchCatalog( fsvolid_t volumeID, u_long options, SearchParam *searchPB );

int SetCatalogInfo			(	fsvolid_t theVolID,
                                u_long theDirID,
                                const char *theItemNamePtr,
                                u_long nameEncoding,
                                u_long theOptions,
                                CatalogAttributeInfoPtr newInfoPtr );



int SetNamedAttribute		(	fsvolid_t theVolID,
                                u_long theItemID,
                                u_long theOptions,
                                const char *theAttributeNamePtr,
                                size_t theAttributeNameLength,
                                void *theBufferPtr,
                                size_t theBufferSize );

int SetVolumeInfo			(	fsvolid_t theVolID,
                                u_long theOptions,
                                VolumeAttributeInfoPtr theInfoPtr );

struct	ifreq {
#define	IFNAMSIZ	16
	char	ifr_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	union {
		struct	sockaddr ifru_addr;
		struct	sockaddr ifru_dstaddr;
		struct	sockaddr ifru_broadaddr;
		short	ifru_flags;
		int	ifru_metric;
		int	ifru_mtu;
		int	ifru_phys;
		int	ifru_media;
		//caddr_t	ifru_data;
	} ifr_ifru;
#define	ifr_addr	ifr_ifru.ifru_addr	/* address */
#define	ifr_dstaddr	ifr_ifru.ifru_dstaddr	/* other end of p-to-p link */
#define	ifr_broadaddr	ifr_ifru.ifru_broadaddr	/* broadcast address */
#define	ifr_flags	ifr_ifru.ifru_flags	/* flags */
#define	ifr_metric	ifr_ifru.ifru_metric	/* metric */
#define	ifr_mtu		ifr_ifru.ifru_mtu	/* mtu */
#define ifr_phys	ifr_ifru.ifru_phys	/* physical wire */
#define ifr_media	ifr_ifru.ifru_media	/* physical media */
#define	ifr_data	ifr_ifru.ifru_data	/* for use by interface */
};

struct	ifconf {
	int	ifc_len;		/* size of associated buffer */
	union {
		char*	ifcu_buf;
		struct	ifreq *ifcu_req;
	} ifc_ifcu;
#define	ifc_buf	ifc_ifcu.ifcu_buf	/* buffer address */
#define	ifc_req	ifc_ifcu.ifcu_req	/* array of structures returned */
};

#define SIOCGIFCONF 0


																		
#endif
#endif

