/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// $Id: QTAtom_stco.h,v 1.2 1999/04/15 22:36:12 lecroy Exp $
//
// QTAtom_stco:
//   The 'stco' QTAtom class.

#ifndef QTAtom_stco_H
#define QTAtom_stco_H


//
// Includes
#include "QTFile.h"
#include "QTAtom.h"


//
// QTAtom class
class QTAtom_stco : public QTAtom {

public:
	//
	// Constructors and destructor.
						QTAtom_stco(QTFile * File, QTFile::AtomTOCEntry * Atom,
							   bool Debug = false, bool DeepDebug = false);
	virtual				~QTAtom_stco(void);


	//
	// Initialization functions.
	virtual	bool		Initialize(void);
	
	//
	// Accessors.
	inline	bool		ChunkOffset(UInt32 ChunkNumber, UInt32 *Offset = NULL) \
							{	if(ChunkNumber && (ChunkNumber<=fNumEntries)) { \
									if( Offset != NULL ) \
										*Offset = ntohl(fTable[ChunkNumber-1]); \
									return true; \
								} else \
									return false; \
							}


	//
	// Debugging functions.
	virtual	void		DumpAtom(void);
	virtual	void		DumpTable(void);


protected:
	//
	// Protected member variables.
	UInt8		fVersion;
	UInt32		fFlags; // 24 bits in the low 3 bytes

	UInt32		fNumEntries;
	char		*fChunkOffsetTable;
	UInt32		*fTable; // longword-aligned version of the above
};

#endif // QTAtom_stco_H
