/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// $Id: QTMutex.h,v 1.1 1999/07/28 23:19:46 rtucker Exp $
//
// QTMutex:
//   The header file which defines the mutexen used in QTFile.

#ifndef QTMutex_H
#define QTMutex_H


//
// Includes
#include <stdio.h>


//
// QTMutex class
class QTMutex {

public:
	//
	// Constructors and destructor.
						QTMutex(void);
	virtual				~QTMutex(void);


	//
	// Lock and unlock functions.
			void		Lock(void);
			void		Unlock(void);


private:
	//
	// Private member variables.
	void				*fMutexData;
};


//
// QTMutexLocker class
class QTMutexLocker {

public:
	//
	// Constructors and destructor.
						QTMutexLocker(QTMutex * Mutex)
							: fMutex(Mutex)
							{ if( fMutex != NULL ) fMutex->Lock(); }
	virtual				~QTMutexLocker(void)
							{ if( fMutex != NULL ) fMutex->Unlock(); }
	
	//
	// Forcible unlock function
	inline	void		Unlock(void)
							{ if( fMutex != NULL ) fMutex->Unlock(); fMutex = NULL; }


private:
	//
	// Private member variables.
	QTMutex				*fMutex;
};


#endif // QTMutex_H
