
#ifndef __BroadcastLog__
#define __BroadcastLog__

/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */



#include "RTSPRollingLog.h"
#include "PLBroadcastDef.h"

#include <string.h>


class BroadcastLog : public RTSPRollingLog
{
	public:
		BroadcastLog( PLBroadcastDef* broadcastParms );
		virtual ~BroadcastLog() {}
	
		virtual char* GetLogName() 
		{ 	// RTSPRollingLog wants to see a "new'd" copy of the file name
			char*	name = new char[strlen( mLogFileName ) + 1 ];
			
			if ( name )
				::strcpy( name, mLogFileName );

			return name;
		}		
		
		virtual char* GetLogDir() 
		{ 	// RTSPRollingLog wants to see a "new'd" copy of the file name
			char *name = new char[strlen( mDirPath ) + 1 ];
			
			if ( name )
				::strcpy( name, mDirPath );

			return name;
		}		
																				
		virtual UInt32 GetRollIntervalInDays() { return 0; /* we dont' roll*/ }
											
		virtual SInt32 GetMaxLogBytes() {  return 0; /* we dont' roll*/ }
		
		void	LogInfo( const char* infoStr );
		void	LogMoviePlay( const char* path, const char* errStr );
		bool	WantsLogging() { return mWantsLogging; }
		const char*	LogFileName() { return mLogFileName; }
		const char*	LogDirName() { return mDirPath; }
	protected:
		char 	mDirPath[256];
		char 	mLogFileName[256];
		bool	mWantsLogging;
	
};

#endif