/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  AFmsg.h

Description:
  Message texts for the TSP audio file routines.

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.13 $  $Date: 1998/06/19 13:40:05 $

----------------------------------------------------------------------*/

#ifndef AFmsg_h_
#define AFmsg_h_

/* File parameter printout formats */
#define AFM_Headerless	"Headerless audio file"
#define AFMF_File	" %s: %s\n"
#define AFMF_stdin	" %s: <stdin>\n"
#define AFMF_stdout	" %s: <stdout>\n"
#define AFMF_Desc	"   Description: %s\n"
#define AFMF_NumSampUnk	"   Number of samples : <unknown>  %.30s\n"
#define AFMF_NumSamp	"   Number of samples : %ld  %.30s\n"
#define AFMF_SFreq	"   Sampling frequency: %.6g Hz\n"
#define AFMF_NumChan	"   Number of channels: %ld (%s)\n"

/* Error message text */

/* Warning messages for parameter setting routines */
/* AFsetFileType
   AFsetHinfo
   AFsetNHpar
*/
#define AFM_BadFormat	"Invalid format keyword"
#define AFM_BadFType	"Invalid file type"
/*      AFM_BadNChan */
#define AFM_BadSFactor	"Invalid scale factor"
#define AFM_BadSFreq	"Invalid sampling frequency"
#define AFM_BadStart	"Invalid start value"
#define AFM_BadSwap	"Invalid swap keyword"
#define AFM_LongInfo	"Information string too long"
#define AFM_TooManyPar	"Too many parameters"

/* Input audio file: Error messages */
#define AFM_BadDLen	"Invalid data length"
#define AFM_BadHeadLen	"Invalid header length"
#define AFM_BadNChan	"Invalid number of channels"
#define AFM_BadNSamp	"Invalid number of samples"
#define AFM_DataErr	"Data format error"
#define AFM_ErrDLen	"Error, data length greater than file length"
#define AFM_NoNSamp	"Unable to determine number of samples"
#define AFM_OpenRErr	"Error opening input audio file"
#define AFM_RAuto	"Input audio file must be random access for \"auto\""
#define AFM_RRAccess	"Input audio file must be random access"
#define AFM_UnkFType	"Unknown audio file type"
#define AFM_UnsupFType	"Unsupported audio file type"

/* Output audio file: Error messages */
#define AFM_BadDataC	"Invalid data format code"
#define AFM_BadFTypeC	"Invalid audio file type code"
/*      AFM_BadNChan */
#define AFM_BadNFrame	"Invalid number of sample frames"
#define AFM_OpenWErr	"Error opening output audio file"

/* I/O errors */
#define AFM_FilePosErr	"File positioning error"
#define AFM_LongLine	"Input line too long"
#define AFM_NoFilePos	"Cannot determine file position"
#define AFM_MoveBack	"Cannot move back in file; File must be random access"
#define AFM_ReadErr	"Read error"
#define AFM_ReadErrOffs	"Error while reading, sample offset:"
#define AFM_ReopenErr	"Cannot reopen file as text file"
#define AFM_UEoF	"Unexpected end-of-file"
#define AFM_UEoFOffs	"Unexpected end-of-file, sample offset:"
#define AFM_UpdHeadErr	"Error updating file header"	
#define AFM_WriteErr	"Write error"

/* Warning messages */
#define AFM_FixDLen	"Fixup, data length greater than file length"
#define AFM_LowDLen	"Fixup, data length less than file length"
#define AFM_NPSFreq	"Non-positive sampling frequency"
#define AFM_NSampNChan	"No. samples not a multiple of no. channels"
#define AFM_NonIntNSamp	"Non-integer number of samples"
#define AFM_OClip	"Output data clipped"

/* Informational message formats */
#define AFMF_BadSFreq	"%s Invalid sampling frequency: \"%g\"; using %g"
#define AFMF_NSampNChan	"%s %ld samples; %ld channels"
#define AFMF_NClip	"%s %ld data values clipped"

/* Error/warning messages for different audio file types */
#define AFM_AIFF_BadId	"Invalid AIFF/AIFF-C file identifier"
#define AFM_AIFF_BadVer	"AIFF/AIFF-C file: Unrecognized version number"
#define AFM_AIFF_FixCOMM "AIFF/AIFF-C file: Fixup for invalid COMM chunk size"
#define AFM_AIFF_NoCOMM	"AIFF/AIFF-C file: Missing COMM chunk"
#define AFM_AIFF_NoSSND	"AIFF/AIFF-C file: Missing SSND chunk"
#define AFM_AIFF_RRAccess "AIFF/AIFF-C file: Input file must be random access"
#define AFM_AIFF_UnsComp "AIFF-C file: Unsupported compression type"
#define AFM_AIFF_UnsData "AIFF-C file: Unsupported data format"
#define AFM_AIFF_UnsSSize "AIFF/AIFF-C file: Unsupported sample size"
#define AFM_AIFF_WRAccess "AIFF-C file: Output file must be random access"

#define AFM_AU_BadId	"Invalid Sun/AFsp audio file identifier"
#define AFM_AU_BadSRate	"AFsp audio file: Invalid sample_rate record"
#define AFM_AU_MisSRate	"AFsp audio file: Sample rate mismatch"
#define AFM_AU_NoIEEE	"Host does not use IEEE float format"
#define AFM_AU_TruncInfo "Header information string too long, truncated"
#define AFM_AU_UnsData	"AFsp/Sun audio file: Unsupported data format"

#define AFM_BL_BadId	"Invalid SPPACK file identifier"
#define AFM_BL_UnsComp	"SPPACK file: Unsupported companding option"
#define AFM_BL_UnsData	"SPPACK file: Unsupported data format"
#define AFM_BL_UnsDomain "SPPACK file: Unsupported domain"
#define AFM_BL_UnsWLen	"SPPACK file: Unsupported data word length"

#define AFM_ES_BadId	"Invalid ESPS file identifier"
#define AFM_ES_IdMatch	"ESPS file: Identifier values do not match"
#define AFM_ES_NoSFreq	"ESPS file: Missing sampling frequency"
#define AFM_ES_UnsData	"ESPS file: Unsupported data format"
#define AFM_ES_UnsEncod	"ESPS file: Unsupported data encoding"
#define AFM_ES_UnsFea	"ESPS file: Unsupported feature file subtype"
#define AFM_ES_UnsType	"ESPS file: Unsupported file type code"

#define AFM_NH_BadFType	"Headerless file: Invalid file code"
#define AFM_NH_NoData	"Headerless file: Data format not specified"

#define AFM_INRS_BadId	"Invalid INRS-Telecom file identifier"

#define AFM_SF_BadId	"Invalid IRCAM soundfile identifier"
#define AFM_SF_MisFloat	"Host and file floating-point formats may differ"
#define AFM_SF_UnsData	"IRCAM soundfile: Unsupported data format"

#define AFM_SP_BadId	"Invalid NIST SPHERE audio file identifier"
#define AFM_SP_BadHLen	"NIST SPHERE audio file: Invalid header length"
#define AFM_SP_NoInter	"NIST SPHERE audio file: Channels may not be interleaved"
#define AFM_SP_UnsByte	"NIST SPHERE audio file: Unsupported byte format"
#define AFM_SP_UnsData	"NIST SPHERE audio file: Unsupported data format"
#define AFM_SP_UnsMulaw	"NIST SPHERE audio file: Unsupported mu-law word length"
#define AFM_SP_UnsPCM	"NIST SPHERE audio file: Unsupported pcm word length"
#define AFM_SP_UnsRes	"NIST SPHERE audio file: Unsupported data resolution"

#define AFMF_SP_NoMatch	"%s No \"%s\" record in NIST SPHERE audio file header"
#define AFMF_SP_BadField \
	"%s NIST SPHERE audio file: Invalid field in \"%s\" record"

#define AFM_SW_AscCmplx	"Comdisco SPW Signal file: Complex ASCII data not supported"
#define AFM_SW_BadId	"Invalid Comdisco SPW Signal file identifier"
#define AFM_SW_BadNSamp	"Comdisco SPW Signal file: Invalid number of samples"
#define AFM_SW_BadSFreq	"Comdisco SPW Signal file: Invalid sampling frequency"
#define AFM_SW_BadSTime	"Comdisco SPW Signal file: Invalid starting time"
#define AFM_SW_IntBin	"Comdisco SPW Signal file: Integer binary data not supported"
#define AFM_SW_LongHead	"Comdisco SPW Signal file: Header too long"
#define AFM_SW_NZSTime	"Comdisco SPW Signal file: Non-zero starting time"
#define AFM_SW_NoData	"Comdisco SPW Signal file: Data type not specified"
#define AFM_SW_NoSFreq	"Comdisco SPW Signal file: Sampling frequency not specified"
#define AFM_SW_UnkCOM	"Comdisco SPW Signal file: Unknown COMMON_INFO field"
#define AFM_SW_UnkKey	"Comdisco SPW Signal file: Unknown keyword"
#define AFM_SW_UnkSys	"Comdisco SPW Signal file: Unknown system type"
#define AFM_SW_UnsCmplx	"Comdisco SPW Signal file: Unsupported complex format"
#define AFM_SW_UnsData	"Comdisco SPW Signal file: Unsupported data type"
#define AFM_SW_UnsDInfo	"Comdisco SPW Signal file: Unsupported DATA_INFO record"
#define AFM_SW_UnsFixP \
	"Comdisco SPW Signal file: Unsupported fixed point format"

#define AFM_TA_BadId	"Invalid Text file identifier"
#define AFM_TA_LongHead	"Text file: Header too long"
#define AFM_TA_NoNSamp	"Text file: Missing sampling frequency"

#define AFM_WV_BadAlaw	"RIFF WAVE file: Invalid A-law data size"
#define AFM_WV_BadId	"Invalid RIFF WAVE file identifier"
#define AFM_WV_BadMulaw	"RIFF WAVE file: Invalid mu-law data size"
#define AFM_WV_BadRIFF	"RIFF WAVE file: Invalid RIFF chunk size"
#define AFM_WV_BadPCM	"RIFF WAVE file: Invalid PCM fmt chunk size"
#define AFM_WV_UnsDSize	"RIFF WAVE file: Unsupported PCM data size"
#define AFM_WV_UnsData	"RIFF WAVE file: Unsupported data format"
#define AFM_WV_WRAccess	"RIFF WAVE file: Output file must be random access"
#define AFM_WV_BadHeader "Malformed file header, fmt chunk not found"

#endif	/* AFmsg_h_ */
