/****************************************************************************/
/*                                                                          */
/* Program:   example.c                                                     */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:30 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/* Demonstration program to invert the pixels in a pgm image.               */
/* compile with:                                                            */
/*     gcc example.c -o example -ILibSrc -LLibSrc -limg                     */
/* or  gcc example.c -o example LibSrc/libimg.a -ILibSrc                    */
/* If you have xv and an image then test with:                              */
/*     example <venice.pgm |xv -                                            */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include "image.h"

int main(void)
{
  it_image *image;
  int x,y,width,height,pix;

  /* Read in the image from stdin */
  image=i_read_image_file(stdin,IT_BYTE,IM_CONTIG);
  if(image==NULL)
    {
      /* Error case - Note that to print messages you need to */
      /* use stderr because stdout is already used to output  */
      /* the image. */
      fprintf(stderr,"Error: failed to import image file.\n");
      return(1);
    }

  /* Find out how big it is */
  width=image->width;
  height=image->height;

  /* Invert the pixels */
  for(y=0;y<height;y++)
    for(x=0;x<width;x++)
      {
	pix=im_byte_value(image,x,y);
	pix=255-pix;
	im_byte_value(image,x,y)=pix;
      }

  /* Write the image out to stdout */
  i_write_image_file(stdout,image,IF_BINARY);

  return(0);
}
/* Version 1.1 (Nov 1994) */
