/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgGrating.c                                                  */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:43 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Grating"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  int width,height,x,y;
  it_image *i;
  double freq,orient,contrast,mean,phase;
  double val,a,b;
  it_float *flt_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Generate a sine wave grating for test purposes\n",
	      PRGNAME);
      fprintf(stderr,"img%s [freq [orient [width height [contrast [mean [phase]]]]]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: None\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  freq is the frequency in radians per pixel\n");
      fprintf(stderr,"  orient is the orientation in degrees from horizontal\n");
      fprintf(stderr,"  phase is the sine-wave phase in degrees\n");
      fprintf(stderr,"  contrast is the sin(90)-sin(0) value difference\n");
      fprintf(stderr,"  default values: pi/2, 90, 256, 256, 1, 0, 0\n");
      exit(0);
    }

  imgStart(PRGNAME);

  /* Arguments are specified in this order */
  freq=M_PI/2.0;
  orient=M_PI/2.0;       /* default is vertical */
  width=height=256;
  contrast=1.0;
  mean=0.0;
  phase=0.0;

  if(argc>8)
    ERROR("too many arguments");
  if(argc>1)
    freq=atof(argv[1]);    /* rad/pix */
  if(argc>2)
    orient=M_PI*atof(argv[2])/180.0;  /* degrees */
  if(argc>3)
    width=atoi(argv[3]);
  if(argc>4)
    height=atoi(argv[4]);
  if(argc>5)
    contrast=atof(argv[5]);
  if(argc>6)
    mean=atof(argv[6]);
  if(argc>7)
    phase=M_PI*atof(argv[7])/180.0;   /* degrees */

  if((i=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT))==NULL)
    ERROR("out of memory");
  
  orient=M_PI_2-orient;
  a=cos(orient);
  b=sin(orient);
  for(y=0;y<height;y++)
    {
      flt_ptr=im_float_row(i,y);
      for(x=0;x<width;x++)
	{
	  val=mean+contrast*sin(phase+(a*(double)x+b*(double)y)*freq);
	  *flt_ptr++=val;
	}
    }
  i->min_value=mean-contrast;
  i->max_value=mean+contrast;
	
  i_write_image_file(stdout,i,IF_BINARY);
  i_destroy_image(i);
  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
