/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgAngle.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:31 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define BIG_ANGLE M_PI

#define PRGNAME "Angle"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1,*i2;
  int width,height,x,y;
  it_float *flt_ptr;
  it_complex *cpx_ptr;
  it_polar *plr_ptr;
  double min,max,val;

  IFHELP
    {
      fprintf(stderr,"img%s - Calculate polar phase information\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Complex, Polar\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }
  imgStart(PRGNAME);

  do {
    i1=i_read_image_file(stdin,IT_COMPLEX | IT_POLAR,IM_FRAGMENT);
    if(i1==NULL)
      ERROR("can't import image file");
    width=i1->width;
    height=i1->height;

    i2=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(i2==NULL)
      ERROR("out of memory");

    min=BIG_ANGLE;
    max= -BIG_ANGLE;
    switch(i1->type)
      {
      case IT_COMPLEX:
	/* Compute the angle */
	for(y=0;y<height;y++)
	  {
	    cpx_ptr=im_complex_row(i1,y);
	    flt_ptr=im_float_row(i2,y);
	    for(x=0;x<width;x++)
	      {
		if(cpx_ptr->Re==0.0)
		  {
		    if(cpx_ptr->Im>0.0)
		      val=M_PI_2;
		    else if(cpx_ptr->Im<0.0)
		      val= -M_PI_2;
		    else
		      val=0.0;
		  }
		else if(cpx_ptr->Re>0.0)
		  /* Right hand two quadrants */
		  val=atan(cpx_ptr->Im/cpx_ptr->Re);
		else if(cpx_ptr->Im>=0.0)
		  /* Top left quadrant */
		  val=M_PI+atan(cpx_ptr->Im/cpx_ptr->Re);
		else
		  /* Bottom left quadrant */
		  val= -M_PI+atan(cpx_ptr->Im/cpx_ptr->Re);
		*flt_ptr++=val;
		cpx_ptr++;
		if(val>max) max=val;
		if(val<min) min=val;
	      }
	  }
	break;
      default:
	/* Just copy the polar angles */
	for(y=0;y<height;y++)
	  {
	    plr_ptr=im_polar_row(i1,y);
	    flt_ptr=im_float_row(i2,y);
	    for(x=0;x<width;x++)
	      {
		val=(plr_ptr++)->ang;
		*flt_ptr++=val;
		if(val>max) max=val;
		if(val<min) min=val;
	      }
	  }
	break;
      }
    i2->min_value=min;
    i2->max_value=max;
    i2->valid_x=i1->valid_x;
    i2->valid_y=i1->valid_y;
    i2->valid_width=i1->valid_width;
    i2->valid_height=i1->valid_height;

    i_destroy_image(i1);
    i_write_image_file(stdout,i2,IF_BINARY);
    i_destroy_image(i2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
