/*
 ******************* X-Mame header file *********************
 * file "xmame.h"
 *
 * by jantonio@dit.upm.es
 *
 ************************************************************
*/

#ifndef __XMAME_H_
#define __XMAME_H_

#ifdef __MAIN_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/*
 * Include files.
 */

#ifdef openstep
#include <libc.h>
#include <math.h>
#endif /* openstep */

#if defined svgalib || defined svgafx
#include <vga.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "osdepend.h"
#include "mame.h"

#ifdef MAME_NET
/* Network */
 
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#endif /* MAME_NET */

/*
 * Definitions.
 */

#ifndef TRUE
#define	TRUE			(1)
#endif

#ifndef FALSE
#define FALSE			(0)
#endif

#define OSD_OK			(0)
#define OSD_NOT_OK		(1)

#define DEBUG(x)

#define MAXPATHC 20 /* at most 20 path entries */
#define MAXPATHL 512 /* at most 511 character path length */

#define FRAMESKIP_LEVELS 12

#ifdef  HAVE_GETTIMEOFDAY

typedef long uclock_t;
uclock_t uclock(void);
#define UCLOCKS_PER_SEC 1000000

#else

typedef clock_t uclock_t
#if (CLOCKS_PER_SEC < 1000)
/* the resolution of the normal clock() call isn't good enough, unless the
   framerate is a division of 100, so we fake a higher resolution */
#define uclock() (clock() << 5)
#define UCLOCKS_PER_SEC (CLOCKS_PER_SEC << 5)
#else
#define UCLOCKS_PER_SEC CLOCKS_PER_SEC
#define uclock() clock()
#endif

#endif

enum { LIST_LIST = 1, LIST_FULL, LIST_GAMES, LIST_CLONES,
   LIST_DETAILS, LIST_ROMS, LIST_SAMPLES, LIST_SAMDIR, LIST_CRC, LIST_DUPCRC,
   LIST_INFO, LIST_COLORS, LIST_LMR, LIST_WRONGORIENTATION, LIST_WRONGMERGE,
   LIST_WRONGFPS, VERIFY_ROMS, VERIFY_SAMPLES };
   
enum { IDENT_IDENT = 1, IDENT_ISKNOWN };

enum { X11_WINDOW, X11_DGA };
#define X11_MODE_COUNT 2

enum { JOY_NONE, JOY_I386, JOY_PAD, JOY_X11, JOY_I386NEW };

#define FRAMESKIP_DRIVER_COUNT 2

/* Taken from common.h since the rest of common.h creates to many conflicts
   with X headers */
struct my_rectangle
{
	int min_x,max_x;
	int min_y,max_y;
};

/*
 * Global variables.
 */

#ifdef MAME_NET
/* Network Variables */
EXTERN int netstate;
EXTERN char global_key[128]; /* keystate table of all pc's in a net game. */
#endif

/* dirty stuff */
#if !defined openstep && !defined xgl
EXTERN unsigned char *dirty_lines;
EXTERN unsigned char **dirty_blocks;
EXTERN unsigned char *old_dirty_lines;
EXTERN unsigned char **old_dirty_blocks;
#endif

/* global variables and miscellaneous flags */

EXTERN int              root_window_id; /* root window id (for swallowing the mame window) */
EXTERN int	 	widthscale;     /* X scale */
EXTERN int	 	heightscale;    /* Y SCALE */
EXTERN float	 	widthscale_f;
EXTERN float	 	heightscale_f;
EXTERN char		*vector_res;
EXTERN int		use_auto_double;
EXTERN int		use_aspect_ratio;
EXTERN char		*geometry;
EXTERN char		rompath[MAXPATHL];
EXTERN char		*spooldir;      /* directory to store high scores */
EXTERN char		*screenshot_dir;
EXTERN char		*home_dir;
EXTERN char		*towns_pad_dev; /* name of FM-TOWNS device */
EXTERN char 		*x11joyname;
EXTERN char             *audiodevice;   /* /dev/dsp or /dev/audio */
EXTERN char		*key;           /* keystate table used by the core  */
EXTERN char		*local_key;     /* keystate table of local keyboard */
EXTERN char		title[50]; 
EXTERN int		analogstick;
EXTERN int		analogmouse;
EXTERN int		joytype;
EXTERN int		use_mouse;
EXTERN int		use_dirty;
EXTERN int		play_sound;
EXTERN int		fake_sound;
EXTERN int		sound_8bit;   /* Sample down to 8bit sound? */
EXTERN int		sound_stereo; /* Do stereo sound? */
EXTERN int		use_private_cmap;
EXTERN int		use_xsync;
EXTERN int		use_tweak;
EXTERN int		use_planar;
EXTERN int		use_linear;
EXTERN int		throttle;
EXTERN int		autoframeskip;
EXTERN int		frameskip;
EXTERN int		snapshot_no;
EXTERN int		game_index;
EXTERN struct osd_bitmap *bitmap;
EXTERN int		frag_size;
EXTERN int		num_frags;
EXTERN int 		use_mit_shm;  /* use mitshm if available */
EXTERN float		gamma_correction;
EXTERN int		brightness;
EXTERN int		totalcolors;
EXTERN int		attenuation;
EXTERN int		x11_video_mode;
EXTERN int		x11_grab_mouse;
EXTERN int		use_xil;
EXTERN int		use_mt_xil;
EXTERN int		show_cursor;
EXTERN int		use_scanlines;
EXTERN int		netkeymap;
EXTERN int		players;
EXTERN char		*mastername;
EXTERN int		doublebuffer;
EXTERN int		cabview;
EXTERN char		*cabname;
EXTERN int		use_winkeys;
EXTERN int		video_16bit;
EXTERN float		display_aspect_ratio;
EXTERN int 		sleep_idle;
EXTERN int 		max_autoframeskip;
EXTERN int		frameskipper;

/* visual is the visual part of the bitmap */
EXTERN int 		visual_width;
EXTERN int		visual_height;
EXTERN struct my_rectangle visual;

/* File descripters for stdout / stderr redirection, without svgalib inter
   fering */
EXTERN FILE *stdout_file;
EXTERN FILE *stderr_file;

/* system dependent functions */
int  sysdep_init(void);
void sysdep_close(void);
int  sysdep_create_display(void);
void sysdep_alloc_palette(void);
void sysdep_alloc_palette_16bpp(unsigned short *pens);
void sysdep_modify_pen(int pen, unsigned char red, unsigned char green, unsigned char blue);
void sysdep_get_pen_16bpp(int pen, unsigned char* red, unsigned char *green, unsigned char *blue);
void sysdep_mark_palette_dirty(void);
void sysdep_update_display(void);
int  sysdep_set_video_mode(void);
void sysdep_set_text_mode(void);

/* audio related */
int  start_timer();
int  osd_audio_init(void);
void osd_audio_close(void);
void osd_audio_update(void);
int  sysdep_audio_init(void);
void sysdep_audio_close(void);
long sysdep_audio_get_freespace(void);
int  sysdep_audio_play(unsigned char *buf, int size);

/* input related */
int  osd_input_initpre(void);
int  osd_input_initpost(void);
void osd_input_close(void);
void sysdep_update_keyboard (void);
int  sysdep_mapkey(char *arg);
int  key_to_pseudo_code(int k);
void sysdep_mouse_poll(void);

/* dirty functions */
int  osd_dirty_init(void);
void osd_dirty_close(void);
void osd_dirty_merge(void);

/* network funtions */
int  osd_net_init(void);
void osd_net_close(void);

/* debug functions */
int  osd_debug_init(void);
void osd_debug_close(void);

/* mode handling functions */
int mode_disable(char *s);
int mode_disabled(int width, int height);
void mode_perfect(int *width, int *height);
int mode_match(int width, int height);

/* frameskip functions */
int dos_skip_next_frame(int show_fps_counter);
int barath_skip_next_frame(int show_fps_counter);

/* miscelaneous */
int get_config (int argc, char *argv[]);
int frontend_list(int list, char *gamename, int showclones);
int frontend_ident(int ident, char *gamename);
int frontend_list_clones(char *gamename);
void init_rom_path(void);
int match_mode(int width, int height);
#undef EXTERN
#endif
