/*
 * Open Sound System sound driver
 */

/* Hacked to use 16bit stereo sound by Mike Oliphant
   (oliphant@ling.ed.ac.uk) */

#include "xmame.h"
#include "sound.h"
#include "devices.h"
#include <sys/ioctl.h>

#if defined FREEBSD && ( ! defined BSDi )
#include <machine/soundcard.h>
#else
#include <sys/soundcard.h>
#endif

static int audio_fd;

int sysdep_audio_init(void)
{
	int log_2_frag, frag;
	int format=(sound_8bit)?AFMT_U8:AFMT_S16_LE;
	int corrected_frag_size;
#ifndef USE_TIMER	
	audio_buf_info info;
#endif

	if (!play_sound) return OSD_OK;
	fprintf(stderr_file,"Linux Sound Driver initialization... \n");
	
	if((audio_fd = open(audiodevice,O_WRONLY,0)) < 0) {
		perror("/dev/dsp");
		goto oss_audio_init_error;
	}
	if (ioctl(audio_fd,SNDCTL_DSP_SETFMT,&format) < 0) {
		perror("SNDCTL_DSP_SETFMT");
		goto oss_audio_init_error;
	}
	if (format != ((sound_8bit)?AFMT_U8:AFMT_S16_LE))
	{
		fprintf(stderr_file, "Error setting sound to %d bits\n",
			(sound_8bit)? 8:16);
		if (sound_8bit) goto oss_audio_init_error;
		fprintf(stderr_file, "Trying again with 8 bits:");
		sound_8bit = TRUE;
		format     = AFMT_U8;
		if (ioctl(audio_fd,SNDCTL_DSP_SETFMT,&format) < 0) {
			perror("SNDCTL_DSP_SETFMT");
			goto oss_audio_init_error;
		}
		if (format != AFMT_U8)
		{
			fprintf(stderr_file, "Failed\n");
			goto oss_audio_init_error;
		}
		fprintf(stderr_file, "Success\n");
	}
	if (ioctl(audio_fd,SNDCTL_DSP_STEREO,&sound_stereo) < 0) {
                perror("SNDCTL_DSP_STEREO");
		goto oss_audio_init_error;
        }
	if (ioctl(audio_fd,SNDCTL_DSP_SPEED,&options.samplerate) < 0) {
                perror("SNDCTL_DSP_SPEED");
		goto oss_audio_init_error;
        }

	corrected_frag_size = (options.samplerate * frag_size) / 22050;
	if (!sound_8bit)  corrected_frag_size *= 2;
	if (sound_stereo) corrected_frag_size *= 2;
	for (log_2_frag=0; (1 << log_2_frag) < corrected_frag_size; log_2_frag++) {}
	frag = log_2_frag + (num_frags << 16);
	
	fprintf(stderr_file, "Setting fragsize to %d, numfrags to %d\n",
		1 << (frag&0x0000FFFF), frag >> 16);
	
	if (ioctl(audio_fd,SNDCTL_DSP_SETFRAGMENT,&frag) < 0) {
                perror("SNDCTL_DSP_SETFRAGMENT");
		goto oss_audio_init_error;
	}

#ifndef USE_TIMER
        /* don't do this in timer mode, usually people use timer mode cause
           this doesn't work. Just hope OSS get's it right */
	if (ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&info) < 0) {
		perror("SNDCTL_DSP_GETOSPACE");
		goto oss_audio_init_error;
	}
	
	frag_size = info.fragsize;
	num_frags = info.fragstotal;
	fprintf(stderr_file,"Fragsize = %d, Numfrags = %d\n", frag_size, num_frags);
#endif

	fprintf(stderr_file,"Audio device %s set to %dbit linear %s %dHz\n",
			audiodevice,(sound_8bit)? 8:16,
			(sound_stereo)? "stereo":"mono",
			options.samplerate);

        return OSD_OK;   

oss_audio_init_error:
	if (audio_fd >= 0) close(audio_fd);
	fprintf(stderr_file,"Sound device init failed. Sound disabled\n");
	play_sound = FALSE;
        return OSD_OK;   
}

/*
 * Cleanup routines to be executed when the program is terminated.
 */
void sysdep_audio_close (void)
{
	if (play_sound) close(audio_fd);
}

long sysdep_audio_get_freespace() {
#ifndef USE_TIMER
       audio_buf_info info;
       int i=ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&info);
       if (i<0) { perror("SNDCTL_DSP_GETOSPACE"); return -1; }
       return (long)(info.bytes);
#else
       return 0;
#endif              
}

int sysdep_audio_play (unsigned char* buf, int bufsize)
{
	return write(audio_fd,buf,bufsize);
}
