#include "xmame.h"
#include "driver.h"
#include "profiler.h"
#include <math.h>

/* don't define this for a production version 
#define barath_debug
*/

static int modframe = 0;

static int barath_skip_this_frame(void)
{   
   return (modframe >= FRAMESKIP_LEVELS); 
}

/* decide whether to skip next frame. */
int barath_skip_next_frame(int showfps)
{
   static uclock_t curr=0;
   static uclock_t prev=0;
   static uclock_t avg_uclocks=0;
   static int frames_skipped=0;
   static int min_skip=0;
   static float framerate=1.0;
   static float speed=1.0;

#ifdef barath_debug   
   static float lag_rate=0.0;
#endif
   
   int uclocks_per_frame = UCLOCKS_PER_SEC/Machine->drv->frames_per_second;
   int scratch_time = uclock();
   int skip_this_frame = barath_skip_this_frame();
   uclock_t target = prev + (frames_skipped + 1) * uclocks_per_frame;
   /* project target display time of this frame */
   
   /* calculate average framerate */
   framerate = (framerate*11 + 1 - skip_this_frame)/12.0;
   
   /* if lagging by more than a 2 frames don't try to make up for it */
   while (scratch_time - target > uclocks_per_frame * 2) 
#ifdef barath_debug
   {
      target+= uclocks_per_frame;
      lag_rate+= 1.0/9.0;
   }
   lag_rate = lag_rate * 0.9;
#else 
   target+= uclocks_per_frame;
#endif   

   if (throttle)
   {
      profiler_mark(PROFILER_IDLE);
      
      if (scratch_time - target < 0)
      {
	 if (autoframeskip) frameskip = (1.0 - framerate) * FRAMESKIP_LEVELS;
	 
	 if (target - scratch_time > uclocks_per_frame * 2)
	   prev = target = scratch_time - uclocks_per_frame * frames_skipped; 
	 /* if we're more than two frames ahead we need to resynch */
	 else
	 { 
	    int leading = (!play_sound || skip_this_frame || (frameskip>0))?uclocks_per_frame:0;
	    /* if no sound and not displaying, don't idle 'til
	     * we are a full frame ahead of real time */
	    
	    while (target - uclock() > leading) if (sleep_idle) usleep(100);
	    /* pass off our timeslice, or tight loop */
	 }
      }
      else if (autoframeskip && (frameskip < max_autoframeskip))
      {  
	 /* calculate percent latency */
	 int cent = 100 * (scratch_time - target) / uclocks_per_frame;
	 /* if latency is excessive increase frameskip */
	 if (cent > 67 * modframe / FRAMESKIP_LEVELS) frameskip++;
	  /* force the next frame to be skipped if we're lagging 67% */
	 if (cent > 66) modframe = FRAMESKIP_LEVELS;
      }
      
      profiler_mark(PROFILER_END);
   }

   if (skip_this_frame && (frames_skipped < FRAMESKIP_LEVELS)) frames_skipped ++;
   else
   {
      /* update frame timer */
      prev = target;
      
      /* calculate speed we're running at */
      scratch_time = curr;
      curr = uclock();
      avg_uclocks = (avg_uclocks * 9 + curr - scratch_time)/(10 + frames_skipped);
      speed = (speed*2 +(float)uclocks_per_frame / avg_uclocks)/3;
      
      if (showfps)
      {
	 static char buf[40]="";
	 static int showme = 6;
	 if (showme++ > 5)
	 {
	    int fps = (Machine->drv->frames_per_second * framerate * speed +.5);
#ifdef barath_debug
	    int lag = lag_rate*100;
	    sprintf(buf,"%2d%%L ",lag);
	    sprintf(buf,"%s%s%s%sfskp%2d %3d%%(%2d/%d fps)",(lag)?buf:"",
		    throttle?"T ":"",(throttle && sleep_idle)?"S ":"",
		    (throttle && autoframeskip)?"auto":"",frameskip,
		    (int)(speed * 100 + .5),fps,Machine->drv->frames_per_second);
#else
	    sprintf(buf,"%s%s%sfskp%2d %3d%%(%2d/%d fps)",
		    throttle?"T ":"",(throttle && sleep_idle)?"S ":"",
		    (throttle && autoframeskip)?"auto":"",frameskip,
		    (int)(speed * 100 + .5),fps,Machine->drv->frames_per_second);
#endif
	    showme=0;
	 }
	 ui_text(buf,Machine->uiwidth-strlen(buf)*Machine->uifontwidth,0);
      }   
      frames_skipped = 0;
   }      

   /* advance frameskip counter */
   if (modframe >= FRAMESKIP_LEVELS) modframe-=FRAMESKIP_LEVELS;
   modframe+=frameskip;

   return barath_skip_this_frame();
}
