;==============================================================================

; file: "_prims.scm"

; Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved.

(include "fixnum.scm")

;------------------------------------------------------------------------------
;
; Primitive procedure database:

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define prim-procs '
(
;                                 side-effects?  strictness  result
;                                             \  pattern     type
; name                       call pattern      \   \         |       standard
;  /                               \            \   \        |         \
("not"                              (1)          #f 0        boolean ieee)
("boolean?"                         (1)          #f 0        boolean ieee)
("eqv?"                             (2)          #f 0        boolean ieee)
("eq?"                              (2)          #f 0        boolean ieee)
("equal?"                           (2)          #f 0        boolean ieee)
("pair?"                            (1)          #f 0        boolean ieee)
("cons"                             (2)          #f ()       pair    ieee)
("car"                              (1)          #f 0        (#f)    ieee)
("cdr"                              (1)          #f 0        (#f)    ieee)
("set-car!"                         (2)          #t (1)      pair    ieee)
("set-cdr!"                         (2)          #t (1)      pair    ieee)
("caar"                             (1)          #f 0        (#f)    ieee)
("cadr"                             (1)          #f 0        (#f)    ieee)
("cdar"                             (1)          #f 0        (#f)    ieee)
("cddr"                             (1)          #f 0        (#f)    ieee)
("caaar"                            (1)          #f 0        (#f)    ieee)
("caadr"                            (1)          #f 0        (#f)    ieee)
("cadar"                            (1)          #f 0        (#f)    ieee)
("caddr"                            (1)          #f 0        (#f)    ieee)
("cdaar"                            (1)          #f 0        (#f)    ieee)
("cdadr"                            (1)          #f 0        (#f)    ieee)
("cddar"                            (1)          #f 0        (#f)    ieee)
("cdddr"                            (1)          #f 0        (#f)    ieee)
("caaaar"                           (1)          #f 0        (#f)    ieee)
("caaadr"                           (1)          #f 0        (#f)    ieee)
("caadar"                           (1)          #f 0        (#f)    ieee)
("caaddr"                           (1)          #f 0        (#f)    ieee)
("cadaar"                           (1)          #f 0        (#f)    ieee)
("cadadr"                           (1)          #f 0        (#f)    ieee)
("caddar"                           (1)          #f 0        (#f)    ieee)
("cadddr"                           (1)          #f 0        (#f)    ieee)
("cdaaar"                           (1)          #f 0        (#f)    ieee)
("cdaadr"                           (1)          #f 0        (#f)    ieee)
("cdadar"                           (1)          #f 0        (#f)    ieee)
("cdaddr"                           (1)          #f 0        (#f)    ieee)
("cddaar"                           (1)          #f 0        (#f)    ieee)
("cddadr"                           (1)          #f 0        (#f)    ieee)
("cdddar"                           (1)          #f 0        (#f)    ieee)
("cddddr"                           (1)          #f 0        (#f)    ieee)
("null?"                            (1)          #f 0        boolean ieee)
("list?"                            (1)          #f 0        boolean ieee)
("list"                             0            #f ()       list    ieee)
("length"                           (1)          #f 0        integer ieee)
("append"                           0            #f 0        list    ieee)
("reverse"                          (1)          #f 0        list    ieee)
("list-ref"                         (2)          #f 0        (#f)    ieee)
("memq"                             (2)          #f 0        list    ieee)
("memv"                             (2)          #f 0        list    ieee)
("member"                           (2)          #f 0        list    ieee)
("assq"                             (2)          #f 0        #f      ieee)
("assv"                             (2)          #f 0        #f      ieee)
("assoc"                            (2)          #f 0        #f      ieee)
("symbol?"                          (1)          #f 0        boolean ieee)
("symbol->string"                   (1)          #f 0        string  ieee)
("string->symbol"                   (1)          #f 0        symbol  ieee)
("number?"                          (1)          #f 0        boolean ieee)
("complex?"                         (1)          #f 0        boolean ieee)
("real?"                            (1)          #f 0        boolean ieee)
("rational?"                        (1)          #f 0        boolean ieee)
("integer?"                         (1)          #f 0        boolean ieee)
("exact?"                           (1)          #f 0        boolean ieee)
("inexact?"                         (1)          #f 0        boolean ieee)
("="                                0            #f 0        boolean ieee)
("<"                                0            #f 0        boolean ieee)
(">"                                0            #f 0        boolean ieee)
("<="                               0            #f 0        boolean ieee)
(">="                               0            #f 0        boolean ieee)
("zero?"                            (1)          #f 0        boolean ieee)
("positive?"                        (1)          #f 0        boolean ieee)
("negative?"                        (1)          #f 0        boolean ieee)
("odd?"                             (1)          #f 0        boolean ieee)
("even?"                            (1)          #f 0        boolean ieee)
("max"                              1            #f 0        number  ieee)
("min"                              1            #f 0        number  ieee)
("+"                                0            #f 0        number  ieee)
("*"                                0            #f 0        number  ieee)
("-"                                1            #f 0        number  ieee)
("/"                                1            #f 0        number  ieee)
("abs"                              (1)          #f 0        number  ieee)
("quotient"                         1            #f 0        integer ieee)
("remainder"                        (2)          #f 0        integer ieee)
("modulo"                           (2)          #f 0        integer ieee)
("gcd"                              1            #f 0        integer ieee)
("lcm"                              1            #f 0        integer ieee)
("numerator"                        (1)          #f 0        integer ieee)
("denominator"                      (1)          #f 0        integer ieee)
("floor"                            (1)          #f 0        integer ieee)
("ceiling"                          (1)          #f 0        integer ieee)
("truncate"                         (1)          #f 0        integer ieee)
("round"                            (1)          #f 0        integer ieee)
("rationalize"                      (2)          #f 0        number  ieee)
("exp"                              (1)          #f 0        number  ieee)
("log"                              (1)          #f 0        number  ieee)
("sin"                              (1)          #f 0        number  ieee)
("cos"                              (1)          #f 0        number  ieee)
("tan"                              (1)          #f 0        number  ieee)
("asin"                             (1)          #f 0        number  ieee)
("acos"                             (1)          #f 0        number  ieee)
("atan"                             (1 2)        #f 0        number  ieee)
("sqrt"                             (1)          #f 0        number  ieee)
("expt"                             (2)          #f 0        number  ieee)
("make-rectangular"                 (2)          #f 0        number  ieee)
("make-polar"                       (2)          #f 0        number  ieee)
("real-part"                        (1)          #f 0        real    ieee)
("imag-part"                        (1)          #f 0        real    ieee)
("magnitude"                        (1)          #f 0        real    ieee)
("angle"                            (1)          #f 0        real    ieee)
("exact->inexact"                   (1)          #f 0        number  ieee)
("inexact->exact"                   (1)          #f 0        number  ieee)
("number->string"                   (1 2)        #f 0        string  ieee)
("string->number"                   (1 2)        #f 0        number  ieee)
("char?"                            (1)          #f 0        boolean ieee)
("char=?"                           0            #f 0        boolean ieee)
("char<?"                           0            #f 0        boolean ieee)
("char>?"                           0            #f 0        boolean ieee)
("char<=?"                          0            #f 0        boolean ieee)
("char>=?"                          0            #f 0        boolean ieee)
("char-ci=?"                        0            #f 0        boolean ieee)
("char-ci<?"                        0            #f 0        boolean ieee)
("char-ci>?"                        0            #f 0        boolean ieee)
("char-ci<=?"                       0            #f 0        boolean ieee)
("char-ci>=?"                       0            #f 0        boolean ieee)
("char-alphabetic?"                 (1)          #f 0        boolean ieee)
("char-numeric?"                    (1)          #f 0        boolean ieee)
("char-whitespace?"                 (1)          #f 0        boolean ieee)
("char-upper-case?"                 (1)          #f 0        boolean ieee)
("char-lower-case?"                 (1)          #f 0        boolean ieee)
("char->integer"                    (1)          #f 0        integer ieee)
("integer->char"                    (1)          #f 0        char    ieee)
("char-upcase"                      (1)          #f 0        char    ieee)
("char-downcase"                    (1)          #f 0        char    ieee)
("string?"                          (1)          #f 0        boolean ieee)
("make-string"                      (1 2)        #f 0        string  ieee)
("string"                           0            #f 0        string  ieee)
("string-length"                    (1)          #f 0        integer ieee)
("string-ref"                       (2)          #f 0        char    ieee)
("string-set!"                      (3)          #t 0        string  ieee)
("string=?"                         0            #f 0        boolean ieee)
("string<?"                         0            #f 0        boolean ieee)
("string>?"                         0            #f 0        boolean ieee)
("string<=?"                        0            #f 0        boolean ieee)
("string>=?"                        0            #f 0        boolean ieee)
("string-ci=?"                      0            #f 0        boolean ieee)
("string-ci<?"                      0            #f 0        boolean ieee)
("string-ci>?"                      0            #f 0        boolean ieee)
("string-ci<=?"                     0            #f 0        boolean ieee)
("string-ci>=?"                     0            #f 0        boolean ieee)
("substring"                        (3)          #f 0        string  ieee)
("string-append"                    0            #f 0        string  ieee)
("vector?"                          (1)          #f 0        boolean ieee)
("make-vector"                      (1 2)        #f (1)      vector  ieee)
("vector"                           0            #f ()       vector  ieee)
("vector-length"                    (1)          #f 0        integer ieee)
("vector-ref"                       (2)          #f 0        (#f)    ieee)
("vector-set!"                      (3)          #t (1 2)    vector  ieee)
("procedure?"                       (1)          #f 0        boolean ieee)
("apply"                            2            #t 0        (#f)    ieee)
("map"                              2            #t 0        list    ieee)
("for-each"                         2            #t 0        #f      ieee)
("call-with-current-continuation"   (1)          #t 0        (#f)    ieee)
("call-with-input-file"             (2)          #t 0        (#f)    ieee)
("call-with-output-file"            (2)          #t 0        (#f)    ieee)
("input-port?"                      (1)          #f 0        boolean ieee)
("output-port?"                     (1)          #f 0        boolean ieee)
("current-input-port"               (0)          #f 0        port    ieee)
("current-output-port"              (0)          #f 0        port    ieee)
("open-input-file"                  (1)          #t 0        port    ieee)
("open-output-file"                 (1)          #t 0        port    ieee)
("close-input-port"                 (1)          #t 0        #f      ieee)
("close-output-port"                (1)          #t 0        #f      ieee)
("eof-object?"                      (1)          #f 0        boolean ieee)
("read"                             (0 1)        #t 0        #f      ieee)
("read-char"                        (0 1)        #t 0        #f      ieee)
("peek-char"                        (0 1)        #t 0        #f      ieee)
("write"                            (0 1)        #t 0        #f      ieee)
("display"                          (0 1)        #t 0        #f      ieee)
("newline"                          (0 1)        #t 0        #f      ieee)
("write-char"                       (1 2)        #t 0        #f      ieee)

; for R4RS Scheme

("list-tail"                        (2)          #f 0        (#f)    r4rs)
("string->list"                     (1)          #f 0        list    r4rs)
("list->string"                     (1)          #f 0        string  r4rs)
("string-copy"                      (1)          #f 0        string  r4rs)
("string-fill!"                     (2)          #t 0        string  r4rs)
("vector->list"                     (1)          #f 0        list    r4rs)
("list->vector"                     (1)          #f 0        vector  r4rs)
("vector-fill!"                     (2)          #t 0        vector  r4rs)
("force"                            (1)          #t 0        #f      r4rs)
("with-input-from-file"             (2)          #t 0        (#f)    r4rs)
("with-output-to-file"              (2)          #t 0        (#f)    r4rs)
("char-ready?"                      (0 1)        #f 0        boolean r4rs)
("load"                             (1)          #t 0        (#f)    r4rs)
("transcript-on"                    (1)          #t 0        #f      r4rs)
("transcript-off"                   (0)          #t 0        #f      r4rs)

; for Multilisp

("touch"                            (1)          #t 0        #f      multilisp)

; for DSSSL

("keyword?"                         (1)          #f 0        boolean extended)
("keyword->string"                  (1)          #f 0        string  extended)
("string->keyword"                  (1)          #f 0        keyword extended)

; other

("void"                             (0)          #t 0        #f      extended)

("will?"                            (1)          #f ()       boolean extended)
("make-will"                        (1 2)        #t ()       #f      extended)
("will-testator"                    (1)          #f ()       (#f)    extended)

("u8vector?"                        (1)          #f 0        boolean extended)
("u8vector"                         0            #f 0        #f      extended)
("make-u8vector"                    (2)          #f 0        #f      extended)
("u8vector-length"                  (1)          #f 0        integer extended)
("u8vector-ref"                     (2)          #f 0        integer extended)
("u8vector-set!"                    (3)          #t 0        #f      extended)
("u8vector->list"                   (1)          #f 0        list    extended)
("list->u8vector"                   (1)          #f 0        #f      extended)

("u16vector?"                       (1)          #f 0        boolean extended)
("u16vector"                        0            #f 0        #f      extended)
("make-u16vector"                   (2)          #f 0        #f      extended)
("u16vector-length"                 (1)          #f 0        integer extended)
("u16vector-ref"                    (2)          #f 0        integer extended)
("u16vector-set!"                   (3)          #t 0        #f      extended)
("u16vector->list"                  (1)          #f 0        list    extended)
("list->u16vector"                  (1)          #f 0        #f      extended)

("u32vector?"                       (1)          #f 0        boolean extended)
("u32vector"                        0            #f 0        #f      extended)
("make-u32vector"                   (2)          #f 0        #f      extended)
("u32vector-length"                 (1)          #f 0        integer extended)
("u32vector-ref"                    (2)          #f 0        integer extended)
("u32vector-set!"                   (3)          #t 0        #f      extended)
("u32vector->list"                  (1)          #f 0        list    extended)
("list->u32vector"                  (1)          #f 0        #f      extended)

("f32vector?"                       (1)          #f 0        boolean extended)
("f32vector"                        0            #f 0        #f      extended)
("make-f32vector"                   (2)          #f 0        #f      extended)
("f32vector-length"                 (1)          #f 0        integer extended)
("f32vector-ref"                    (2)          #f 0        real    extended)
("f32vector-set!"                   (3)          #t 0        #f      extended)
("f32vector->list"                  (1)          #f 0        list    extended)
("list->f32vector"                  (1)          #f 0        #f      extended)

("f64vector?"                       (1)          #f 0        boolean extended)
("f64vector"                        0            #f 0        #f      extended)
("make-f64vector"                   (2)          #f 0        #f      extended)
("f64vector-length"                 (1)          #f 0        integer extended)
("f64vector-ref"                    (2)          #f 0        real    extended)
("f64vector-set!"                   (3)          #t 0        #f      extended)
("f64vector->list"                  (1)          #f 0        list    extended)
("list->f64vector"                  (1)          #f 0        #f      extended)

; for system interface

("##type"                           (1)          #f ()       integer extended)
("##type-cast"                      (2)          #f ()       (#f)    extended)
("##subtype"                        (1)          #f ()       integer extended)
("##subtype-set!"                   (2)          #t ()       #f      extended)

("##not"                            (1)          #f ()       boolean extended)
("##null?"                          (1)          #f ()       boolean extended)
("##unbound?"                       (1)          #f ()       boolean extended)
("##eq?"                            (2)          #f ()       boolean extended)
("##eqv?"                           (2)          #f ()       boolean extended)
("##eof-object?"                    (1)          #f ()       boolean extended)

("##fixnum?"                        (1)          #f ()       boolean extended)
("##flonum?"                        (1)          #f ()       boolean extended)
("##special?"                       (1)          #f ()       boolean extended)
("##pair?"                          (1)          #f ()       boolean extended)
("##subtyped?"                      (1)          #f ()       boolean extended)
("##procedure?"                     (1)          #f ()       boolean extended)
("##promise?"                       (1)          #f ()       boolean extended)
("##vector?"                        (1)          #f ()       boolean extended)
("##symbol?"                        (1)          #f ()       boolean extended)
("##keyword?"                       (1)          #f ()       boolean extended)
("##ratnum?"                        (1)          #f ()       boolean extended)
("##cpxnum?"                        (1)          #f ()       boolean extended)
("##port?"                          (1)          #f ()       boolean extended)
("##readtable?"                     (1)          #f ()       boolean extended)
("##structure?"                     (1)          #f ()       boolean extended)
("##string?"                        (1)          #f ()       boolean extended)
("##bignum?"                        (1)          #f ()       boolean extended)
("##u8vector?"                      (1)          #f ()       boolean extended)
("##u16vector?"                     (1)          #f ()       boolean extended)
("##u32vector?"                     (1)          #f ()       boolean extended)
("##f32vector?"                     (1)          #f ()       boolean extended)
("##f64vector?"                     (1)          #f ()       boolean extended)
("##char?"                          (1)          #f ()       boolean extended)
("##closure?"                       (1)          #f ()       boolean extended)
("##subprocedure?"                  (1)          #f ()       boolean extended)
("##return-dynamic-env-bind?"       (1)          #f ()       boolean extended)

("##fixnum.max"                     1            #f ()       integer extended)
("##fixnum.min"                     1            #f ()       integer extended)
("##fixnum.+"                       0            #f ()       integer extended)
("##fixnum.*"                       0            #f ()       integer extended)
("##fixnum.-"                       1            #f ()       integer extended)
("##fixnum.quotient"                (2)          #f ()       integer extended)
("##fixnum.remainder"               (2)          #f ()       integer extended)
("##fixnum.modulo"                  (2)          #f ()       integer extended)
("##fixnum.logior"                  0            #f ()       integer extended)
("##fixnum.logxor"                  0            #f ()       integer extended)
("##fixnum.logand"                  0            #f ()       integer extended)
("##fixnum.lognot"                  (1)          #f ()       integer extended)
("##fixnum.ashr"                    (2)          #f ()       integer extended)
("##fixnum.lshr"                    (2)          #f ()       integer extended)
("##fixnum.shl"                     (2)          #f ()       integer extended)
("##fixnum.zero?"                   (1)          #f ()       boolean extended)
("##fixnum.positive?"               (1)          #f ()       boolean extended)
("##fixnum.negative?"               (1)          #f ()       boolean extended)
("##fixnum.odd?"                    (1)          #f ()       boolean extended)
("##fixnum.even?"                   (1)          #f ()       boolean extended)
("##fixnum.="                       0            #f ()       boolean extended)
("##fixnum.<"                       0            #f ()       boolean extended)
("##fixnum.>"                       0            #f ()       boolean extended)
("##fixnum.<="                      0            #f ()       boolean extended)
("##fixnum.>="                      0            #f ()       boolean extended)
("##fixnum.->char"                  (1)          #f ()       char    extended)
("##fixnum.<-char"                  (1)          #f ()       integer extended)

("##flonum.->fixnum"                (1)          #f ()       integer extended)
("##flonum.<-fixnum"                (1)          #f ()       real    extended)
("##flonum.max"                     1            #f ()       real    extended)
("##flonum.min"                     1            #f ()       real    extended)
("##flonum.+"                       0            #f ()       real    extended)
("##flonum.*"                       0            #f ()       real    extended)
("##flonum.-"                       1            #f ()       real    extended)
("##flonum./"                       1            #f ()       real    extended)
("##flonum.abs"                     (1)          #f ()       real    extended)
("##flonum.floor"                   (1)          #f ()       real    extended)
("##flonum.ceiling"                 (1)          #f ()       real    extended)
("##flonum.truncate"                (1)          #f ()       real    extended)
("##flonum.round"                   (1)          #f ()       real    extended)
("##flonum.exp"                     (1)          #f ()       real    extended)
("##flonum.log"                     (1)          #f ()       real    extended)
("##flonum.sin"                     (1)          #f ()       real    extended)
("##flonum.cos"                     (1)          #f ()       real    extended)
("##flonum.tan"                     (1)          #f ()       real    extended)
("##flonum.asin"                    (1)          #f ()       real    extended)
("##flonum.acos"                    (1)          #f ()       real    extended)
("##flonum.atan"                    (1 2)        #f ()       real    extended)
("##flonum.sqrt"                    (1)          #f ()       real    extended)
("##flonum.copysign"                (2)          #f ()       real    extended)
("##flonum.zero?"                   (1)          #f ()       boolean extended)
("##flonum.positive?"               (1)          #f ()       boolean extended)
("##flonum.negative?"               (1)          #f ()       boolean extended)
("##flonum.finite?"                 (1)          #f ()       boolean extended)
("##flonum.nan?"                    (1)          #f ()       boolean extended)
("##flonum.="                       0            #f ()       boolean extended)
("##flonum.<"                       0            #f ()       boolean extended)
("##flonum.>"                       0            #f ()       boolean extended)
("##flonum.<="                      0            #f ()       boolean extended)
("##flonum.>="                      0            #f ()       boolean extended)

("##char=?"                         0            #f ()       boolean extended)
("##char<?"                         0            #f ()       boolean extended)
("##char>?"                         0            #f ()       boolean extended)
("##char<=?"                        0            #f ()       boolean extended)
("##char>=?"                        0            #f ()       boolean extended)

("##cons"                           (2)          #f ()       pair    extended)
("##set-car!"                       (2)          #t ()       pair    extended)
("##set-cdr!"                       (2)          #t ()       pair    extended)
("##car"                            (1)          #f ()       (#f)    extended)
("##cdr"                            (1)          #f ()       (#f)    extended)
("##caar"                           (1)          #f ()       (#f)    extended)
("##cadr"                           (1)          #f ()       (#f)    extended)
("##cdar"                           (1)          #f ()       (#f)    extended)
("##cddr"                           (1)          #f ()       (#f)    extended)
("##caaar"                          (1)          #f ()       (#f)    extended)
("##caadr"                          (1)          #f ()       (#f)    extended)
("##cadar"                          (1)          #f ()       (#f)    extended)
("##caddr"                          (1)          #f ()       (#f)    extended)
("##cdaar"                          (1)          #f ()       (#f)    extended)
("##cdadr"                          (1)          #f ()       (#f)    extended)
("##cddar"                          (1)          #f ()       (#f)    extended)
("##cdddr"                          (1)          #f ()       (#f)    extended)
("##caaaar"                         (1)          #f ()       (#f)    extended)
("##caaadr"                         (1)          #f ()       (#f)    extended)
("##caadar"                         (1)          #f ()       (#f)    extended)
("##caaddr"                         (1)          #f ()       (#f)    extended)
("##cadaar"                         (1)          #f ()       (#f)    extended)
("##cadadr"                         (1)          #f ()       (#f)    extended)
("##caddar"                         (1)          #f ()       (#f)    extended)
("##cadddr"                         (1)          #f ()       (#f)    extended)
("##cdaaar"                         (1)          #f ()       (#f)    extended)
("##cdaadr"                         (1)          #f ()       (#f)    extended)
("##cdadar"                         (1)          #f ()       (#f)    extended)
("##cdaddr"                         (1)          #f ()       (#f)    extended)
("##cddaar"                         (1)          #f ()       (#f)    extended)
("##cddadr"                         (1)          #f ()       (#f)    extended)
("##cdddar"                         (1)          #f ()       (#f)    extended)
("##cddddr"                         (1)          #f ()       (#f)    extended)

("##list"                           0            #f ()       list    extended)

("##make-cell"                      (1)          #f ()       pair    extended)
("##cell-ref"                       (1)          #f ()       (#f)    extended)
("##cell-set!"                      (2)          #t ()       pair    extended)

("##will?"                          (1)          #f ()       boolean extended)
("##make-will"                      (1 2)        #t ()       #f      extended)
("##will-testator"                  (1)          #f ()       (#f)    extended)

("##vector"                         0            #f ()       vector  extended)
("##make-vector"                    (2)          #f ()       vector  extended)
("##vector-length"                  (1)          #f ()       integer extended)
("##vector-ref"                     (2)          #f ()       (#f)    extended)
("##vector-set!"                    (3)          #t ()       vector  extended)
("##vector-shrink!"                 (2)          #t ()       vector  extended)

("##string"                         0            #f ()       string  extended)
("##make-string"                    (2)          #f ()       string  extended)
("##string-length"                  (1)          #f ()       integer extended)
("##string-ref"                     (2)          #f ()       char    extended)
("##string-set!"                    (3)          #t ()       string  extended)
("##string-shrink!"                 (2)          #t ()       string  extended)

("##u8vector"                       0            #f ()       #f      extended)
("##make-u8vector"                  (2)          #f ()       #f      extended)
("##u8vector-length"                (1)          #f ()       integer extended)
("##u8vector-ref"                   (2)          #f ()       integer extended)
("##u8vector-set!"                  (3)          #t ()       #f      extended)
("##u8vector-shrink!"               (2)          #t ()       #f      extended)

("##u16vector"                      0            #f ()       #f      extended)
("##make-u16vector"                 (2)          #f ()       #f      extended)
("##u16vector-length"               (1)          #f ()       integer extended)
("##u16vector-ref"                  (2)          #f ()       integer extended)
("##u16vector-set!"                 (3)          #t ()       #f      extended)
("##u16vector-shrink!"              (2)          #t ()       #f      extended)

("##u32vector"                      0            #f ()       #f      extended)
("##make-u32vector"                 (2)          #f ()       #f      extended)
("##u32vector-length"               (1)          #f ()       integer extended)
("##u32vector-ref"                  (2)          #f ()       integer extended)
("##u32vector-set!"                 (3)          #t ()       #f      extended)
("##u32vector-shrink!"              (2)          #t ()       #f      extended)

("##f32vector"                      0            #f ()       #f      extended)
("##make-f32vector"                 (2)          #f ()       #f      extended)
("##f32vector-length"               (1)          #f ()       integer extended)
("##f32vector-ref"                  (2)          #f ()       real    extended)
("##f32vector-set!"                 (3)          #t ()       #f      extended)
("##f32vector-shrink!"              (2)          #t ()       #f      extended)

("##f64vector"                      0            #f ()       #f      extended)
("##make-f64vector"                 (2)          #f ()       #f      extended)
("##f64vector-length"               (1)          #f ()       integer extended)
("##f64vector-ref"                  (2)          #f ()       real    extended)
("##f64vector-set!"                 (3)          #t ()       #f      extended)
("##f64vector-shrink!"              (2)          #t ()       #f      extended)

("##struct-ref"                     (3)          #f ()       (#f)    extended)
("##struct-set!"                    (4)          #t ()       vector  extended)
("##structure-ref"                  (3)          #f ()       (#f)    extended)
("##structure-set!"                 (4)          #t ()       vector  extended)

("##symbol->string"                 (1)          #f ()       string  extended)

("##keyword->string"                (1)          #f ()       string  extended)

("##closure-code"                   (1)          #f ()       #f      extended)
("##closure-ref"                    (2)          #f ()       (#f)    extended)
("##closure-set!"                   (3)          #t ()       #f      extended)

("##subprocedure-id"                (1)          #f ()       #f      extended)
("##subprocedure-parent"            (1)          #f ()       #f      extended)

("##procedure-info"                 (1)          #f ()       #f      extended)

("##make-promise"                   (1)          #f 0        (#f)    extended)
("##force"                          (1)          #t 0        #f      extended)

("##void"                           (0)          #t 0        #f      extended)

("##apply"                          (2)          #t ()       (#f)    extended)
("##call-with-current-continuation" (1)          #t ()       (#f)    extended)
("##make-global-var"                (1)          #t ()       #f      extended)
("##global-var-ref"                 (1)          #f ()       (#f)    extended)
("##global-var-set!"                (2)          #t ()       #f      extended)

("##atomic-car"                     (1)          #f ()       (#f)    extended)
("##atomic-cdr"                     (1)          #f ()       (#f)    extended)
("##atomic-set-car!"                (2)          #t ()       pair    extended)
("##atomic-set-cdr!"                (2)          #t ()       pair    extended)
("##atomic-set-car-if-eq?!"         (3)          #t ()       boolean extended)
("##atomic-set-cdr-if-eq?!"         (3)          #t ()       boolean extended)

("##first-argument"                 1            #f ()       (#f)    extended)
("##check-heap-limit"               (0)          #t ()       (#f)    extended)

; for front end

("##quasi-append"                   0            #f 0        list    extended)
("##quasi-list"                     0            #f ()       list    extended)
("##quasi-cons"                     (2)          #f ()       pair    extended)
("##quasi-list->vector"             (1)          #f 0        vector  extended)
("##case-memv"                      (2)          #f 0        list    extended)

;("callcc"        (1)          #t 0        (#f)    extended)
;("throw"         (2)          #t 0        (#f)    extended)

)
)

;==============================================================================
