package biss.awt;

import biss.CommandQueue;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;

/**
 * vertical scrollbar ( replaces java.awt.Scrollbar)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class VScrollBar
  extends ScrollBar
{

public VScrollBar () {
	super( 0, 0, 0);
}

public VScrollBar ( int min, int max, int pos) {
	super( min, max, pos);
}

public void mouse1Drag( Event evt) {

	if ( DragOffs > 0)
		setPosition((int)((double)(evt.y - DragOffs - Width) *
	                  Max / ((Height - 2 * Width) - SliderRect.height)));
}

public void mouseDownScroll (Event evt) {

	if ( SliderRect.inside( evt.x, evt.y)){
		DragOffs = evt.y - SliderRect.y;
		ScrollOp = 5;
	}
	else if ( (evt.y < Width) && (Pos > Min) ){
		ScrollOp = 1;
		LoopDir = 1;
		redrawSpins();
		Delay = true;
		CommandQueue.appendUnique( this);
	}
	else if ( (evt.y > Height - Width) && (Pos < Max) ){
		ScrollOp = 2;
		LoopDir = 2;
		redrawSpins();
		Delay = true;
		CommandQueue.appendUnique( this);
	}
	else if ( SliderRect.height > 0) {
		if ( evt.y < SliderRect.y)
			ScrollOp = 3;
		else if ( evt.y > SliderRect.y + SliderRect.height)
			ScrollOp = 4;
	}

}

public Dimension preferredSize(){
	return new Dimension( Awt.SysFontWidth, 10*Awt.SysFontHeight);
}

protected void redrawSlider( Graphics g) {
	if ( Height <= 0)
		return;

	int b = FBorder.Ext;
	int w = Width - b;
	int h = Height - 2*w;

	if ( (SliderRect.height > 0) && (SliderRect.height < h )) {
		int y, d = SliderRect.y - w;
		int ww = w-b;
		g.setColor( getBackground() );
		if ( d > 0 )
			g.fillRect( b, w, ww, d);
		y = SliderRect.y + SliderRect.height;
		d = Height - w - y;
		if ( d > 0 )
			g.fillRect( b, y, ww, d);

		GraphicsLib.paint3dBox( g, SliderRect.x, SliderRect.y,
		                        SliderRect.width, SliderRect.height,
		                        false, Awt.ButtonBackClr);
	}
	else {
		g.setColor( getBackground() );
		g.fillRect( b, w, w-b, h);
	}
}

protected void redrawSpins( Graphics g) {
	int b = FBorder.Ext;
	int w = Width - 2*b;

	if ( ScrollOp == 1 )
		GraphicsLib.paintButton( g, b, b, w, w, false, Awt.ButtonBackClr);
	else
		GraphicsLib.paint3dBox( g, b, b, w, w, false, Awt.ButtonBackClr);

	if ( ScrollOp == 2 )
		GraphicsLib.paintButton( g, b, Height-b-w, w, w, false, Awt.ButtonBackClr);
	else
		GraphicsLib.paint3dBox( g, b, Height-b-w, w, w, false, Awt.ButtonBackClr);
}

protected void updatePageInc() {
	if ( AutoPageInc)
		PageInc = Height / StepPels;
}

protected void updateSliderPos() {
	int w = Width - FBorder.Ext;

	SliderRect.y = (int)(((double)Pos / Max) *
	                     ((Height - 2*w) - SliderRect.height)) + w;
}

protected void updateSliderRect() {
	int b = FBorder.Ext;
	int w = Width - b;
	int tl = Height - 2 * w;
	int bl, sPos;

	bl = Math.max( w, (int)(tl * ((double)(PageInc + 1) / (Max - Min + 1))));
	if ( bl < tl) {
		sPos = (int)(((double)Pos / Max) * ( tl - bl)) + w;
		SliderRect.reshape( b, sPos, w-b, bl);
	}
	else
		SliderRect.reshape( 0, 0, 0, 0);
}
}
