package biss.awt;

import biss.ObserverSocket;
import java.util.Observable;
import java.util.Observer;

/**
 * generic dialog for simple String input
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Prompter
  extends ObserverSocket
  implements Observer
{
	PromptViewer View;

public Prompter ( String text, Object selector,
           Observer owner, TopWindow parent ) {
	this( text, null, selector, owner, parent);
}

public Prompter ( String text, String def, Object selector,
           Observer owner, TopWindow parent ) {

	super( owner, selector);
	addObserver( owner);

	View = new PromptViewer( "Please Enter", text, def, parent );
	View.OsClose.addObserver( this);
	View.openCentered();
}

public Prompter ( String title, String text, String def, boolean defSelect,
           Object checker, Object selector, Observer owner, TopWindow parent ) {

	super( owner, selector);
	addObserver( owner);

	View = new PromptViewer( title, text, def, parent );
	View.OsClose.addObserver( this);
	View.openCentered();

	if ( checker != null)	View.Entry.setChecker( checker);
	if ( defSelect)		View.Entry.selectContents();
}

public Prompter ( String title, String text, String def, boolean defSelect,
           Object selector, Observer owner, TopWindow parent ) {

	super( owner, selector);
	addObserver( owner);

	View = new PromptViewer( title, text, def, parent );
	View.OsClose.addObserver( this);
	View.openCentered();

	if ( defSelect)
		View.Entry.selectContents();
}

public String getContents() {
	return View.getContents();
}

public int getContentsAsInt () {
	String s = View.getContents();
	try {
		return Integer.parseInt( s);
	}
	catch ( Exception x ) {
		return 0;
	}
}

public void update ( Observable obs, Object arg ) {
	if ( obs == View.OsClose ) {
		if ( !View.wasCanceled() )
			notifyObservers( Category);
	}
}
}
