package biss.awt;

import java.awt.MenuItem;
import java.awt.peer.MenuComponentPeer;
import java.awt.peer.MenuItemPeer;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * replaces java.awt.Menu
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Menu
  implements HotKeyProcessor, MenuPeer
{
	GUIHandler Handler = null;
	Vector Items = null;

public Menu(){
	Items = new Vector( 5);
}

public Menu( GUIHandler evtHandler){
	Items = new Vector( 5);
	assign( evtHandler);
}

public Menu( String items){
	this();
	StringTokenizer tok = new StringTokenizer( items, ",:;");
	while( tok.hasMoreTokens() )
		addItem( tok.nextToken() );
}

public Menu( Vector items){
	Items = (items != null) ? items : new Vector( 5);
}

public boolean addItem( String text){
	return addItem( new biss.awt.MenuItem( text, null));
}

public boolean addItem( String text, String sel){
	return addItem( new biss.awt.MenuItem( text, sel));    
}

public boolean addItem( biss.awt.MenuItem mi){
	if ( includesItem( mi))
		return false;
	if ( (Handler != null) && (mi.MnKey != 0))
		Handler.addHotKey( mi.MnKey | 32, HotKey.Control, this, mi);
	Items.addElement( mi);
	return true;
}

public void addItem( java.awt.MenuItem item){
	//java.awt.peer.MenuPeer interface
	biss.awt.MenuItem mi = new biss.awt.MenuItem( item.getLabel(), null);
	mi.setEnable( item.isEnabled() );
	addItem( mi );
}

public void addSeparator(){
	//java.awt.peer.MenuPeer interface
	if ( Items == null)
		Items = new Vector( 5);
	Items.addElement( biss.awt.MenuItem.Separator);
}

public void addSeparator( String topSel){
	try {
		itemAt( topSel).addSubItem( biss.awt.MenuItem.Separator);
	}
	catch( Throwable t) {}
}

public boolean addSubItem( String topSel, String text){
	return addSubItem( topSel, text, null);
}

public boolean addSubItem( String topSel, String text, String sel){
	try {
		return addSubItem( itemAt( topSel), text, sel);
	}
	catch( Throwable t) {
		return false;
	}
}

boolean addSubItem( biss.awt.MenuItem mi, String text, String sel){
	if( ! includesItem( mi))
		return false;
	mi.addSubItem( text, sel);
	return true;
}

public void assign( GUIHandler evtHandler){
	Handler = evtHandler;
	Handler.setMenu( Items);
}

public boolean checkItem( String sel){
	try {
		itemAt( sel).check();
		return true;
	}
	catch( Throwable t) {
		return false;
	}
}

public void delItem( int index){
	//java.awt.peer.MenuPeer interface
	try {
		Items.removeElementAt( index);
	}
	catch ( Throwable t){}
}

public void disable(){
	//java.awt.peer.MenuItemPeer interface
}

public boolean disableItem( String sel){
	try {
		itemAt( sel).disable();
		return true;
	}
	catch( Throwable t) {
		return false;
	}
}

public void dispose(){
	//java.awt.peer.MenuItemPeer interface
}

void dumpItems(){
	dumpItems( Items, "");
}

void dumpItems( Vector v, String pre){
	biss.awt.MenuItem mii;
	if ( v == null )
		return;
	for ( int i=0; i<v.size(); i++){
		mii = (biss.awt.MenuItem)v.elementAt( i);
		System.out.println( pre + mii.Selector);
		dumpItems( mii.SubItems, pre + " ");
	}
}

public void enable(){
	//java.awt.peer.MenuItemPeer interface
}

public boolean enableItem( String sel){
	try {
		itemAt( sel).enable();
		return true;
	}
	catch( Throwable t){
		return false;
	}
}

boolean includesItem( Vector v, biss.awt.MenuItem mi){
	biss.awt.MenuItem mii;
	if ( v == null )
		return false;
	for ( int i=0; i<v.size(); i++){
		mii = (biss.awt.MenuItem)v.elementAt( i);
		if ( mii.Selector.equals( mi.Selector))
			return true;
		if ( includesItem( mii.SubItems, mi))
			return true;
	}
	return false;
}

boolean includesItem( biss.awt.MenuItem mi){
	return includesItem( Items, mi);
}

biss.awt.MenuItem itemAt( String sel){
	return itemAt( Items, sel);
}

biss.awt.MenuItem itemAt( Vector v, String sel){
	biss.awt.MenuItem mi, mis;
	if ( v == null)
		return null;
	for ( int i=0; i<v.size(); i++){
		mi = (biss.awt.MenuItem)v.elementAt( i);
		if ( mi.Selector.equals( sel))
			return mi;
		mis = itemAt( mi.SubItems, sel);
		if ( mis != null)
			return mis;
	}
	return null;
}

public static void main( String[] args){
	Menu m = new Menu();
	m.addItem( "1");
	m.addItem( "2");
	m.addSubItem( "2", "2.1");
	m.addSubItem( "2.1", "2.1.1"); 
	m.addSubItem( "2", "2.2");
	m.addSubItem( "2.2", "2.2.1");
	m.addSubItem( "2.2.1", "2.2.1.1");
	m.addItem( "3");

	m.dumpItems();
}

public void processKey( Object sel){
	biss.awt.MenuItem mi = (biss.awt.MenuItem)sel;
	if ( mi.isDisabled() )
		return;
	if ( Handler != null)
		Handler.OsCommand.notifyObservers( mi.Selector);
}

void registerKeys( Vector v, int mods){
	biss.awt.MenuItem mii;
	if ( v == null )
		return;
	for ( int i=0; i<v.size(); i++){
		mii = (biss.awt.MenuItem)v.elementAt( i);
		if ( mii.MnKey != 0)
			Handler.addHotKey( mii.MnKey | 32, mods, this, mii);
		registerKeys( mii.SubItems, mods );
	}
}

void registerKeys( int mods){
	registerKeys( Items, mods);
}

public boolean removeItem( String sel){
	try {
		Items.removeElement( itemAt( sel));
		return true;
	}
	catch( Throwable t) {
		return false;
	}
}

public void setHandler( GUIHandler evtHandler){
	Handler = evtHandler;
}

public void setLabel( String label){
	//java.awt.peer.MenuItemPeer interface
}

public boolean setText( String sel, String text){
	try {
		itemAt( sel).Text = text;
		return true;
	}
	catch( Throwable t) {
		return false;
	}
}

public boolean uncheckItem( String sel){
	try {
		itemAt( sel).uncheck();
		return true;
	}
	catch( Throwable t) {
		return false;
	}
}
}
