package biss.awt;

import biss.VectorLib;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/**
 * Implementation of a FontDialog by means of biss.awt classes (NOT
 * native).
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class FontDialog
  extends DialogWindow
  implements Observer
{
	Choice FamChoice = new Choice();
	SpinButton SizeSpin = new SpinButton();
	Checkbox BoldBtn = new Checkbox( "Bold");
	Checkbox ItalBtn = new Checkbox( "Italic");
	Label Preview = new Label( "The quick brown Fox ...");
	DecoText FamText = new DecoText( "Family");
	DecoText SizeText = new DecoText( "Size");
	Button OkBtn = new Button( "Ok");
	Button CancelBtn = new Button( "Cancel");
	DecoText PreText = new DecoText( "Preview");

public FontDialog () {
	super( "FontDialog", null);

	queryFonts();

	Lo.add( FamText,   0, 0, 0,    0, true, 50,  50,  300, 200, 0);
	Lo.add( FamChoice, 0, 0, 1000, 0, true, 320, 50,  -50, 200, 0);
	Lo.add( SizeText,  0, 0, 0,    0, true, 50,  220, 300, 370, 0);
	Lo.add( SizeSpin,  0, 0, 0,    0, true, 320, 220, 700, 370, 0);
	Lo.add( BoldBtn,   0, 0, 0,    0, true, 750, 220, 1150,370, 0);
	Lo.add( ItalBtn,   0, 0, 0,    0, true, 1150,220, 1550,370, 0);

	Lo.add( PreText,   0, 0, 0,    0, true, 50,  400, 300, 800, 0);
	Lo.add( Preview,   0, 0, 1000, 0, true, 320, 400, -50, 800, 0);

	Lo.add( OkBtn,     0, 0, 0, 0, true, 320, 850, 920, 1000, 0);
	Lo.add( CancelBtn, 0, 0, 0, 0, true, 950, 850, 1550,1000, 0);

	FamChoice.OsSelection.addObserver( this);
	SizeSpin.OsSpinChanged.addObserver( this);
	BoldBtn.OsAction.addObserver( this);
	ItalBtn.OsAction.addObserver( this);
	OkBtn.OsAction.addObserver( this);
	CancelBtn.OsAction.addObserver( this);

	Preview.setCarved( false);
	Preview.setBackground( Color.white);
	Preview.setFont( new Font( (String)FamChoice.getSelection(),
	                           (BoldBtn.isChecked() ? Font.BOLD : Font.PLAIN) |
	                           (ItalBtn.isChecked() ? Font.ITALIC : 0 ),
	                           SizeSpin.getContents() ));

	packClientDlgUnits( 160, 105);
	openCentered();
}

public Font getSelection() {
	return Preview.getFont();
}

public static void main ( String[] args ) {
	new FontDialog();
}

void queryFonts () {
	String[] sa = Toolkit.getDefaultToolkit().getFontList();
	FamChoice.setContents( VectorLib.vectorFromArray( sa));
	SizeSpin.setRange( 2, 50);
	SizeSpin.setContents( 10);
}

public void update ( Observable obs, Object arg ) {
	Font f = Preview.getFont();

	if ( obs == FamChoice.OsSelection)
		Preview.setFont( new Font( (String)arg, f.getStyle(), f.getSize() ));
	else if ( obs == SizeSpin.OsSpinChanged)
		Preview.setFont( new Font( f.getName(), f.getStyle(), SizeSpin.getContents() ));
	else if ( obs == BoldBtn.OsAction)
		Preview.setFont( new Font( f.getName(),
	                           BoldBtn.isChecked() ? (f.getStyle() | Font.BOLD) :
	                           (f.getStyle() &~ Font.BOLD),
	                           f.getSize() ));
	else if ( obs == ItalBtn.OsAction)
		Preview.setFont( new Font( f.getName(),
	                           ItalBtn.isChecked() ? (f.getStyle() | Font.ITALIC) :
	                           (f.getStyle() &~ Font.ITALIC),
	                           f.getSize() ));
	else if ( obs == OkBtn.OsAction)
		process();
	else if ( obs == CancelBtn.OsAction)
		dispose();
	else super.update( obs, arg);
}
}
