namespace eval registry {
    variable registry
}

proc registry::execute { idx } {
    global tkWorld

    # Set the command to execute to be the create method of the
    # selected object (i.e. grep::create if grep is selected).
    set cmd "[$tkWorld(reg_listbox) get $idx]::create"
    
    # Run the command xxx::create which all elements in the
    # registry will have this method.
    eval $cmd
}

proc registry::create { } {
    global tkWorld

    set registry(file_list) [lsort [glob -nocomplain \
	    [file join $tkWorld(registry_dir) *.tcl]]]

    foreach f $registry(file_list) {
	# Build the registry element without the /dir/dir/file.tcl
	# stuff on it.  All we want is file.
	regsub "[file dirname $f]/" $f "" cmd
	regsub "\.tcl" $cmd "" cmd

	# Insert the command in the registry.
	$tkWorld(reg_listbox) insert end $cmd

	# Bind the command to execute the clicked on command.
	bind $tkWorld(reg_listbox) <ButtonRelease-1> \
		{registry::execute [$tkWorld(reg_listbox) curselection]}
    }
}
